/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.hyperlink;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.lib.editor.hyperlink.HyperlinkProviderManager;
import org.netbeans.lib.editor.hyperlink.HyperlinkProviderManagerExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;

public class HyperlinkOperation
implements MouseListener,
MouseMotionListener,
PropertyChangeListener,
KeyListener {
    private static Logger LOG = Logger.getLogger(HyperlinkOperation.class.getName());
    private static final String KEY = "hyperlink-operation";
    private JTextComponent component;
    private Document currentDocument;
    private String operationMimeType;
    private Cursor oldComponentsMouseCursor;
    private boolean hyperlinkUp;
    private boolean listenersSetUp;
    private boolean hyperlinkEnabled;
    private int actionKeyMask;
    private int altActionKeyMask;
    private static Object BAG_KEY = new Object();
    private static AttributeSet defaultHyperlinksHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.BLUE, StyleConstants.Underline, Color.BLUE});

    public static void ensureRegistered(JTextComponent jTextComponent, String string) {
        if (jTextComponent.getClientProperty(KEY) == null) {
            jTextComponent.putClientProperty(KEY, new HyperlinkOperation(jTextComponent, string));
        }
    }

    private static synchronized Cursor getMouseCursor(HyperlinkType hyperlinkType) {
        switch (hyperlinkType) {
            case GO_TO_DECLARATION: 
            case ALT_HYPERLINK: {
                return Cursor.getPredefinedCursor(12);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static synchronized boolean isHyperlinkMouseCursor(Cursor cursor) {
        return cursor == Cursor.getPredefinedCursor(12) || cursor == Cursor.getPredefinedCursor(1) || cursor == Cursor.getPredefinedCursor(13);
    }

    private HyperlinkOperation(JTextComponent jTextComponent, String string) {
        this.component = jTextComponent;
        this.operationMimeType = string;
        this.oldComponentsMouseCursor = null;
        this.hyperlinkUp = false;
        this.listenersSetUp = false;
        this.readSettings();
        if (this.hyperlinkEnabled) {
            jTextComponent.addPropertyChangeListener("document", this);
        }
    }

    private void documentUpdated() {
        if (!this.hyperlinkEnabled) {
            return;
        }
        this.currentDocument = this.component.getDocument();
        if (this.currentDocument instanceof BaseDocument && !this.listenersSetUp) {
            this.component.addMouseListener(this);
            this.component.addMouseMotionListener(this);
            this.component.addKeyListener(this);
            this.listenersSetUp = true;
        }
    }

    private void readSettings() {
        String string = System.getProperty("org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey");
        if (string != null) {
            if ("off".equals(string)) {
                this.hyperlinkEnabled = false;
                this.actionKeyMask = -1;
            } else {
                this.hyperlinkEnabled = true;
                this.actionKeyMask = -1;
                for (int i = 0; i < string.length(); ++i) {
                    int n = 0;
                    switch (string.charAt(i)) {
                        case 'S': {
                            n = 64;
                            break;
                        }
                        case 'C': {
                            n = 128;
                            break;
                        }
                        case 'A': {
                            n = 512;
                            break;
                        }
                        case 'M': {
                            n = 256;
                            break;
                        }
                        default: {
                            LOG.warning("Incorrect value of org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey property (only letters CSAM are allowed): " + string.charAt(i));
                        }
                    }
                    if (n == 0) {
                        this.actionKeyMask = -1;
                        break;
                    }
                    if (this.actionKeyMask == -1) {
                        this.actionKeyMask = n;
                        continue;
                    }
                    this.actionKeyMask |= n;
                }
                if (this.actionKeyMask == -1) {
                    LOG.warning("Some problem with property org.netbeans.lib.editor.hyperlink.HyperlinkOperation.activationKey, more information might be given above. Falling back to the default behaviour.");
                } else {
                    return;
                }
            }
        }
        this.hyperlinkEnabled = true;
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookup(Preferences.class);
        this.actionKeyMask = preferences.getInt("hyperlink-activation-modifiers", 128);
        this.altActionKeyMask = preferences.getInt("alt-hyperlink-activation-modifiers", 640);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        HyperlinkType hyperlinkType = this.getHyperlinkType(mouseEvent);
        if (hyperlinkType != null) {
            int n = this.component.viewToModel(mouseEvent.getPoint());
            if (n < 0) {
                this.unHyperlink(true);
                return;
            }
            this.performHyperlinking(n, hyperlinkType);
        } else {
            this.unHyperlink(true);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private HyperlinkType getHyperlinkType(InputEvent inputEvent) {
        int n = inputEvent.getModifiers() | inputEvent.getModifiersEx();
        if ((n & this.altActionKeyMask) == this.altActionKeyMask) {
            return HyperlinkType.ALT_HYPERLINK;
        }
        if ((n & this.actionKeyMask) == this.actionKeyMask) {
            return HyperlinkType.GO_TO_DECLARATION;
        }
        return null;
    }

    private void performHyperlinking(int n, HyperlinkType hyperlinkType) {
        HyperlinkProviderExt hyperlinkProviderExt = this.findProvider(n, hyperlinkType);
        if (hyperlinkProviderExt != null) {
            int[] nArray = hyperlinkProviderExt.getHyperlinkSpan(this.component.getDocument(), n, hyperlinkType);
            if (nArray != null) {
                this.makeHyperlink(hyperlinkType, hyperlinkProviderExt, nArray[0], nArray[1]);
            }
        } else {
            this.unHyperlink(true);
        }
    }

    private void performAction(int n, HyperlinkType hyperlinkType) {
        HyperlinkProviderExt hyperlinkProviderExt = this.findProvider(n, hyperlinkType);
        if (hyperlinkProviderExt != null) {
            this.unHyperlink(true);
            this.component.getCaret().setDot(n);
            JumpList.checkAddEntry(this.component, n);
            hyperlinkProviderExt.performClickAction(this.component.getDocument(), n, hyperlinkType);
        }
    }

    private HyperlinkProviderExt findProvider(int n, HyperlinkType hyperlinkType) {
        Object object2 = this.component.getDocument().getProperty("mimeType");
        String string = object2 instanceof String ? (String)object2 : this.operationMimeType;
        Collection<? extends HyperlinkProviderExt> collection = HyperlinkProviderManagerExt.getHyperlinkProviderExts(string);
        for (HyperlinkProviderExt object3 : collection) {
            if (!object3.getSupportedHyperlinkTypes().contains((Object)hyperlinkType) || !object3.isHyperlinkPoint(this.component.getDocument(), n, hyperlinkType)) continue;
            return object3;
        }
        if (hyperlinkType != HyperlinkType.GO_TO_DECLARATION) {
            return null;
        }
        Collection<? extends HyperlinkProvider> collection2 = HyperlinkProviderManager.getHyperlinkProviders(string);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            final HyperlinkProvider hyperlinkProvider = (HyperlinkProvider)iterator.next();
            if (!hyperlinkProvider.isHyperlinkPoint(this.component.getDocument(), n)) continue;
            return new HyperlinkProviderExt(){

                @Override
                public Set<HyperlinkType> getSupportedHyperlinkTypes() {
                    return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
                }

                @Override
                public boolean isHyperlinkPoint(Document document, int n, HyperlinkType hyperlinkType) {
                    return hyperlinkProvider.isHyperlinkPoint(document, n);
                }

                @Override
                public int[] getHyperlinkSpan(Document document, int n, HyperlinkType hyperlinkType) {
                    return hyperlinkProvider.getHyperlinkSpan(document, n);
                }

                @Override
                public void performClickAction(Document document, int n, HyperlinkType hyperlinkType) {
                    hyperlinkProvider.performClickAction(document, n);
                }

                @Override
                public String getTooltipText(Document document, int n, HyperlinkType hyperlinkType) {
                    return null;
                }
            };
        }
        return null;
    }

    private synchronized void makeHyperlink(HyperlinkType hyperlinkType, HyperlinkProviderExt hyperlinkProviderExt, int n, int n2) {
        boolean bl = true;
        if (this.hyperlinkUp) {
            this.unHyperlink(false);
            bl = false;
        }
        OffsetsBag offsetsBag = new OffsetsBag(this.component.getDocument());
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors("hyperlinks");
        offsetsBag.addHighlight(n, n2, AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet != null ? attributeSet : defaultHyperlinksHighlight, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, new TooltipResolver(hyperlinkProviderExt, n, hyperlinkType)})}));
        HyperlinkOperation.getBag(this.currentDocument).setHighlights(offsetsBag);
        this.hyperlinkUp = true;
        if (bl) {
            this.oldComponentsMouseCursor = this.component.isCursorSet() ? this.component.getCursor() : null;
            this.component.setCursor(HyperlinkOperation.getMouseCursor(hyperlinkType));
        }
    }

    private synchronized void unHyperlink(boolean bl) {
        if (!this.hyperlinkUp) {
            return;
        }
        HyperlinkOperation.getBag(this.currentDocument).clear();
        if (bl) {
            if (this.component.isCursorSet() && HyperlinkOperation.isHyperlinkMouseCursor(this.component.getCursor())) {
                this.component.setCursor(this.oldComponentsMouseCursor);
            }
            this.oldComponentsMouseCursor = null;
        }
        this.hyperlinkUp = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.currentDocument != this.component.getDocument()) {
            this.documentUpdated();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.getHyperlinkType(keyEvent) == null) {
            this.unHyperlink(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        HyperlinkType hyperlinkType = this.getHyperlinkType(mouseEvent);
        if (hyperlinkType != null && !mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
            int n = this.component.viewToModel(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            this.performAction(n, hyperlinkType);
        }
    }

    private static OffsetsBag getBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(BAG_KEY);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document);
            document.putProperty(BAG_KEY, offsetsBag);
        }
        return offsetsBag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TooltipResolver
    implements HighlightAttributeValue<String> {
        private HyperlinkProviderExt provider;
        private int offset;
        private HyperlinkType type;

        public TooltipResolver(HyperlinkProviderExt hyperlinkProviderExt, int n, HyperlinkType hyperlinkType) {
            this.provider = hyperlinkProviderExt;
            this.offset = n;
            this.type = hyperlinkType;
        }

        public String getValue(JTextComponent jTextComponent, Document document, Object object, int n, int n2) {
            return this.provider.getTooltipText(document, this.offset, this.type);
        }
    }

    public static final class HighlightFactoryImpl
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)HyperlinkOperation.class.getName(), (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(450), (boolean)true, (HighlightsContainer)HyperlinkOperation.getBag(context.getDocument()))};
        }
    }
}

