/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFoldingSideBar
extends JComponent
implements Accessible {
    private static final Logger LOG = Logger.getLogger(CodeFoldingSideBar.class.getName());
    protected Color backColor;
    protected Color foreColor;
    protected Font font;
    protected JTextComponent component;
    private volatile AttributeSet attribs;
    private Lookup.Result<? extends FontColorSettings> fcsLookupResult;
    private final LookupListener fcsTracker = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            CodeFoldingSideBar.this.attribs = null;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeFoldingSideBar.this.updatePreferredSize();
                    CodeFoldingSideBar.this.repaint();
                }
            });
        }
    };
    private final Listener listener = new Listener();
    private boolean enabled = false;
    protected List<Mark> visibleMarks = new ArrayList<Mark>();
    public static final int PAINT_NOOP = 0;
    public static final int PAINT_MARK = 1;
    public static final int PAINT_LINE = 2;
    public static final int PAINT_END_MARK = 3;
    public static final int SINGLE_PAINT_MARK = 4;
    private final Preferences prefs;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (string == null || "code-folding-enable".equals(string)) {
                CodeFoldingSideBar.this.updateColors();
                boolean bl = CodeFoldingSideBar.this.prefs.getBoolean("code-folding-enable", false);
                if (CodeFoldingSideBar.this.enabled != bl) {
                    CodeFoldingSideBar.this.enabled = bl;
                    CodeFoldingSideBar.this.updatePreferredSize();
                }
            }
            SettingsConversions.callSettingsChange(CodeFoldingSideBar.this);
        }
    };

    public CodeFoldingSideBar() {
        this.component = null;
        this.prefs = null;
        throw new IllegalStateException("Do not use this constructor!");
    }

    public CodeFoldingSideBar(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.addMouseListener(this.listener);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)WeakListeners.create(FoldHierarchyListener.class, (EventListener)this.listener, (Object)foldHierarchy));
        Document document = this.getDocument();
        document.addDocumentListener(WeakListeners.document((DocumentListener)this.listener, (Object)document));
        this.setOpaque(true);
        this.prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)jTextComponent)).lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
        this.prefsListener.preferenceChange(null);
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.getColoring().getFont().getSize(), this.component.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private void updateColors() {
        Coloring coloring = this.getColoring();
        this.backColor = coloring.getBackColor();
        this.foreColor = coloring.getForeColor();
        this.font = coloring.getFont();
    }

    protected Color getBackColor() {
        if (this.backColor == null) {
            this.updateColors();
        }
        return this.backColor;
    }

    protected Color getForeColor() {
        if (this.foreColor == null) {
            this.updateColors();
        }
        return this.foreColor;
    }

    protected Font getColoringFont() {
        if (this.font == null) {
            this.updateColors();
        }
        return this.font;
    }

    @Override
    public void update(Graphics graphics) {
    }

    protected void collectPaintInfos(View view, Fold fold, Map<Integer, PaintInfo> map, int n, int n2, int n3) throws BadLocationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends PaintInfo> getPaintInfo(Rectangle rectangle) throws BadLocationException {
        TextUI textUI = this.component.getUI();
        if (!(textUI instanceof BaseTextUI)) {
            return Collections.emptyList();
        }
        BaseTextUI baseTextUI = (BaseTextUI)textUI;
        BaseDocument baseDocument = Utilities.getDocument(this.component);
        if (baseDocument == null) {
            return Collections.emptyList();
        }
        baseDocument.readLock();
        try {
            FoldHierarchy foldHierarchy;
            block15: {
                TreeMap<Integer, PaintInfo> treeMap;
                block16: {
                    List<PaintInfo> list;
                    int n = baseTextUI.getPosFromY(rectangle.y);
                    int n2 = baseTextUI.viewToModel(this.component, 16383, rectangle.y + rectangle.height);
                    n = Utilities.getRowStart(baseDocument, n);
                    n2 = Utilities.getRowEnd(baseDocument, n2);
                    foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
                    foldHierarchy.lock();
                    try {
                        Fold fold;
                        int n3;
                        View view = Utilities.getDocumentView(this.component);
                        if (view == null) break block15;
                        Object[] objectArray = CodeFoldingSideBar.getFoldList(foldHierarchy.getRootFold(), n, n2);
                        List list2 = (List)objectArray[0];
                        int n4 = (Integer)objectArray[1];
                        treeMap = new TreeMap<Integer, PaintInfo>();
                        for (n3 = n4 - 1; n3 >= 0 && this.traverseBackwards(fold = (Fold)list2.get(n3), baseDocument, baseTextUI, n, n2, 0, treeMap); --n3) {
                        }
                        for (n3 = n4; n3 < list2.size() && this.traverseForward(fold = (Fold)list2.get(n3), baseDocument, baseTextUI, n, n2, 0, treeMap); ++n3) {
                        }
                        if (treeMap.size() != 0 || list2.size() <= 0) break block16;
                        assert (list2.size() == 1);
                        list = Collections.singletonList(new PaintInfo(2, 0, rectangle.y, rectangle.height));
                    }
                    catch (Throwable throwable) {
                        foldHierarchy.unlock();
                        throw throwable;
                    }
                    foldHierarchy.unlock();
                    return list;
                }
                ArrayList arrayList = new ArrayList(treeMap.values());
                foldHierarchy.unlock();
                return arrayList;
            }
            List list = Collections.emptyList();
            foldHierarchy.unlock();
            return list;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    private boolean traverseForward(Fold fold, BaseDocument baseDocument, BaseTextUI baseTextUI, int n, int n2, int n3, Map<Integer, PaintInfo> map) throws BadLocationException {
        if (fold.getStartOffset() > n2) {
            return false;
        }
        int n4 = Utilities.getRowStart(baseDocument, fold.getStartOffset());
        int n5 = Utilities.getRowStart(baseDocument, fold.getEndOffset());
        int n6 = baseTextUI.getYFromPos(n4);
        int n7 = baseTextUI.getEditorUI().getLineHeight();
        if (n4 == n5) {
            map.put(n4, new PaintInfo(4, n3, n6, n7, fold.isCollapsed()));
        } else {
            map.put(n4, new PaintInfo(1, n3, n6, n7, fold.isCollapsed()));
            if (!fold.isCollapsed() && fold.getEndOffset() <= n2) {
                int n8 = baseTextUI.getYFromPos(n5);
                map.put(n5, new PaintInfo(3, n3, n8, n7));
            }
        }
        if (!fold.isCollapsed()) {
            Fold fold2;
            int n9;
            Object[] objectArray = CodeFoldingSideBar.getFoldList(fold, n, n2);
            List list = (List)objectArray[0];
            int n10 = (Integer)objectArray[1];
            for (n9 = n10 - 1; n9 >= 0 && this.traverseBackwards(fold2 = (Fold)list.get(n9), baseDocument, baseTextUI, n, n2, n3 + 1, map); --n9) {
            }
            for (n9 = n10; n9 < list.size(); ++n9) {
                fold2 = (Fold)list.get(n9);
                if (this.traverseForward(fold2, baseDocument, baseTextUI, n, n2, n3 + 1, map)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean traverseBackwards(Fold fold, BaseDocument baseDocument, BaseTextUI baseTextUI, int n, int n2, int n3, Map<Integer, PaintInfo> map) throws BadLocationException {
        int n4;
        if (fold.getEndOffset() < n) {
            return false;
        }
        int n5 = Utilities.getRowStart(baseDocument, fold.getStartOffset());
        int n6 = Utilities.getRowStart(baseDocument, fold.getEndOffset());
        int n7 = baseTextUI.getEditorUI().getLineHeight();
        if (n5 == n6) {
            n4 = baseTextUI.getYFromPos(n5);
            map.put(n5, new PaintInfo(4, n3, n4, n7, fold.isCollapsed()));
        } else {
            if (fold.getStartOffset() >= n2) {
                n4 = baseTextUI.getYFromPos(n5);
                map.put(n5, new PaintInfo(1, n3, n4, n7, fold.isCollapsed()));
            }
            if (!fold.isCollapsed() && fold.getEndOffset() <= n2) {
                n4 = baseTextUI.getYFromPos(n6);
                map.put(n6, new PaintInfo(3, n3, n4, n7));
            }
        }
        if (!fold.isCollapsed()) {
            Fold fold2;
            int n8;
            Object[] objectArray = CodeFoldingSideBar.getFoldList(fold, n, n2);
            List list = (List)objectArray[0];
            int n9 = (Integer)objectArray[1];
            for (n8 = n9 - 1; n8 >= 0; --n8) {
                fold2 = (Fold)list.get(n8);
                if (this.traverseBackwards(fold2, baseDocument, baseTextUI, n, n2, n3 + 1, map)) continue;
                return false;
            }
            for (n8 = n9; n8 < list.size() && this.traverseForward(fold2 = (Fold)list.get(n8), baseDocument, baseTextUI, n, n2, n3 + 1, map); ++n8) {
            }
        }
        return true;
    }

    protected EditorUI getEditorUI() {
        return Utilities.getEditorUI(this.component);
    }

    protected Document getDocument() {
        return this.component.getDocument();
    }

    private Fold getLastLineFold(FoldHierarchy foldHierarchy, int n, int n2) {
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)n);
        while (fold != null && fold.getStartOffset() < n2) {
            Fold fold2 = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)(fold.isCollapsed() ? fold.getEndOffset() : fold.getStartOffset() + 1));
            if (fold2 == fold) {
                return fold;
            }
            if (fold2 != null && fold2.getStartOffset() < n2) {
                fold = fold2;
                continue;
            }
            return fold;
        }
        return fold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Mark mark) {
        BaseTextUI baseTextUI = (BaseTextUI)this.component.getUI();
        Element element = baseTextUI.getRootView(this.component).getElement();
        View view = Utilities.getDocumentView(this.component);
        if (view == null) {
            return;
        }
        try {
            int n = view.getViewIndex(baseTextUI.getPosFromY(mark.y + mark.size / 2), Position.Bias.Forward);
            View view2 = view.getView(n);
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
            AbstractDocument abstractDocument = (AbstractDocument)foldHierarchy.getComponent().getDocument();
            abstractDocument.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int n2 = view2.getStartOffset();
                    int n3 = javax.swing.text.Utilities.getRowStart(this.component, n2);
                    int n4 = javax.swing.text.Utilities.getRowEnd(this.component, n2);
                    Fold fold = this.getLastLineFold(foldHierarchy, n3, n4);
                    if (fold != null && fold.getStartOffset() < view2.getEndOffset()) {
                        foldHierarchy.toggle(fold);
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, null, badLocationException);
        }
    }

    protected int getMarkSize(Graphics graphics) {
        FontMetrics fontMetrics;
        if (graphics != null && (fontMetrics = graphics.getFontMetrics(this.getColoring().getFont())) != null) {
            int n = fontMetrics.getAscent() - fontMetrics.getDescent();
            return n - n % 2;
        }
        return -1;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.enabled) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        this.visibleMarks.clear();
        Coloring coloring = this.getColoring();
        graphics.setColor(coloring.getBackColor());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(coloring.getForeColor());
        try {
            List<? extends PaintInfo> list = this.getPaintInfo(rectangle);
            Font font = coloring.getFont();
            int n = this.getMarkSize(graphics);
            int n2 = n / 2;
            int n3 = (font.getSize() - n) / 2;
            int n4 = (int)Math.round((double)n / 3.8);
            int n5 = n3 + n2;
            PaintInfo paintInfo = null;
            for (PaintInfo paintInfo2 : list) {
                boolean bl = paintInfo2.isCollapsed();
                int n6 = paintInfo2.getPaintY();
                int n7 = paintInfo2.getPaintHeight();
                int n8 = n6 + graphics.getFontMetrics(font).getDescent();
                int n9 = paintInfo2.getPaintOperation();
                if (paintInfo == null) {
                    if (paintInfo2.getInnerLevel() > 0 || n9 == 3) {
                        graphics.drawLine(n5, rectangle.y, n5, n6);
                    }
                } else if (paintInfo.getInnerLevel() > 0 || paintInfo.getPaintOperation() == 1 && !paintInfo.isCollapsed()) {
                    graphics.drawLine(n5, paintInfo.getPaintY() + paintInfo.getPaintHeight(), n5, n6);
                }
                if (n9 == 1 || n9 == 4) {
                    graphics.drawRect(n3, n8, n, n);
                    graphics.drawLine(n4 + n3, n8 + n2, n + n3 - n4, n8 + n2);
                    if (bl) {
                        graphics.drawLine(n5, n8 + n4, n5, n8 + n - n4);
                    } else if (n9 != 4) {
                        graphics.drawLine(n5, n8 + n, n5, n6 + n7);
                    }
                    if (paintInfo2.getInnerLevel() > 0) {
                        graphics.drawLine(n5, n6, n5, n8);
                        if (n9 != 4) {
                            graphics.drawLine(n5, n8 + n, n5, n6 + n7);
                        }
                    }
                    this.visibleMarks.add(new Mark(n3, n8, n, bl));
                } else if (n9 == 2) {
                    graphics.drawLine(n5, n6, n5, n6 + n7);
                } else if (n9 == 3) {
                    graphics.drawLine(n5, n6, n5, n6 + n7 / 2);
                    graphics.drawLine(n5, n6 + n7 / 2, n5 + n2, n6 + n7 / 2);
                    if (paintInfo2.getInnerLevel() > 0) {
                        graphics.drawLine(n5, n6 + n7 / 2, n5, n6 + n7);
                    }
                }
                paintInfo = paintInfo2;
            }
            if (paintInfo != null && (paintInfo.getInnerLevel() > 0 || paintInfo.getPaintOperation() == 1 && !paintInfo.isCollapsed())) {
                graphics.drawLine(n5, paintInfo.getPaintY() + paintInfo.getPaintHeight(), n5, rectangle.y + rectangle.height);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, null, badLocationException);
        }
    }

    private static Object[] getFoldList(Fold fold, int n, int n2) {
        Fold fold2;
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        int n3 = fold.getFoldCount();
        int n4 = -1;
        for (int i = FoldUtilities.findFoldEndIndex((Fold)fold, (int)n); i < n3 && (fold2 = fold.getFold(i)).getStartOffset() <= n2; ++i) {
            arrayList.add(fold2);
            if (n4 != -1 || fold2.getStartOffset() < n) continue;
            n4 = arrayList.size() - 1;
        }
        return new Object[]{arrayList, n4 != -1 ? n4 : arrayList.size()};
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSN_CodeFoldingSideBar"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSD_CodeFoldingSideBar"));
        }
        return this.accessibleContext;
    }

    private Coloring getColoring() {
        if (this.attribs == null) {
            FontColorSettings fontColorSettings;
            AttributeSet attributeSet;
            if (this.fcsLookupResult == null) {
                this.fcsLookupResult = MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookupResult(FontColorSettings.class);
                this.fcsLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fcsTracker, this.fcsLookupResult));
            }
            attributeSet = (attributeSet = (fontColorSettings = (FontColorSettings)this.fcsLookupResult.allInstances().iterator().next()).getFontColors("code-folding-bar")) == null ? fontColorSettings.getFontColors("default") : AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet, fontColorSettings.getFontColors("default")});
            this.attribs = attributeSet;
        }
        return Coloring.fromAttributeSet(this.attribs);
    }

    private final class Listener
    extends MouseAdapter
    implements FoldHierarchyListener,
    DocumentListener {
        public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
            this.refresh();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(documentEvent instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            if (baseDocumentEvent.getLFCount() > 0) {
                this.refresh();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(documentEvent instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            if (baseDocumentEvent.getLFCount() > 0) {
                this.refresh();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Mark mark = this.getClickedMark(mouseEvent);
            if (mark != null) {
                mouseEvent.consume();
                CodeFoldingSideBar.this.performAction(mark);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        private Mark getClickedMark(MouseEvent mouseEvent) {
            if (mouseEvent == null || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return null;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (Mark mark : CodeFoldingSideBar.this.visibleMarks) {
                if (n < mark.x || n > mark.x + mark.size || n2 < mark.y || n2 > mark.y + mark.size) continue;
                return mark;
            }
            return null;
        }

        private void refresh() {
            CodeFoldingSideBar.this.repaint();
        }
    }

    public class Mark {
        public int x;
        public int y;
        public int size;
        public boolean isFolded;

        public Mark(int n, int n2, int n3, boolean bl) {
            this.x = n;
            this.y = n2;
            this.size = n3;
            this.isFolded = bl;
        }
    }

    public class PaintInfo {
        int paintOperation;
        int innerLevel;
        int paintY;
        int paintHeight;
        boolean isCollapsed;

        public PaintInfo(int n, int n2, int n3, int n4, boolean bl) {
            this.paintOperation = n;
            this.innerLevel = n2;
            this.paintY = n3;
            this.paintHeight = n4;
            this.isCollapsed = bl;
        }

        public PaintInfo(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, false);
        }

        public int getPaintOperation() {
            return this.paintOperation;
        }

        public int getInnerLevel() {
            return this.innerLevel;
        }

        public int getPaintY() {
            return this.paintY;
        }

        public int getPaintHeight() {
            return this.paintHeight;
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setPaintOperation(int n) {
            this.paintOperation = n;
        }

        public void setInnerLevel(int n) {
            this.innerLevel = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.paintOperation == 0) {
                stringBuffer.append("PAINT_NOOP\n");
            } else if (this.paintOperation == 1) {
                stringBuffer.append("PAINT_MARK\n");
            } else if (this.paintOperation == 2) {
                stringBuffer.append("PAINT_LINE\n");
            } else if (this.paintOperation == 3) {
                stringBuffer.append("PAINT_END_MARK\n");
            }
            stringBuffer.append("level:" + this.innerLevel);
            stringBuffer.append("\ncollapsedFold:" + this.isCollapsed);
            return stringBuffer.toString();
        }
    }
}

