/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import javax.xml.namespace.QName;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.impl.WSDLMessageImpl;
import org.jvnet.wom.impl.WSDLPartImpl;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.handler.AbstractHandler;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.jvnet.wom.impl.parser.handler.Part;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Message
extends AbstractHandler {
    private WSDLContentHandlerEx runtime;
    private String expectedNS;
    private WSDLMessageImpl message;
    private int state;
    private int partIndex = 0;

    public Message(AbstractHandler parent, WSDLEventSource source, WSDLContentHandlerEx runtime, int cookie, String expectedNamespace) {
        super(source, parent, cookie);
        this.runtime = runtime;
        this.expectedNS = expectedNamespace;
        this.state = 1;
    }

    protected Message(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        super(source, parent, parentCookie);
    }

    protected WSDLContentHandlerEx getRuntime() {
        return this.runtime;
    }

    protected void onChildCompleted(Object result, int cookie, boolean needAttCheck) throws SAXException {
        switch (cookie) {
            case 51: {
                WSDLPartImpl part = (WSDLPartImpl)result;
                part.setIndex(this.partIndex++);
                this.message.addPart(part);
            }
        }
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        switch (this.state) {
            case 1: {
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("message")) {
                    this.runtime.onEnterElementConsumed(uri, localName, qname, atts);
                    Attributes test = this.runtime.getCurrentAttributes();
                    this.processAttributes(test);
                    break;
                }
                if (uri.equals("http://schemas.xmlsoap.org/wsdl/") && localName.equals("part")) {
                    Part part = new Part(this, this._source, this.runtime, 51, this.expectedNS);
                    this.spawnChildFromEnterElement(part, uri, localName, qname, atts);
                    break;
                }
                super.enterElement(uri, localName, qname, atts);
            }
        }
    }

    private void processAttributes(Attributes test) throws SAXException {
        int index;
        int[] validattrs = new int[test.getLength()];
        String name = XmlUtil.fixNull(test.getValue("name"));
        if (name.equals("")) {
            this.runtime.getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.missingName", "wsdl:message", name), this.runtime.getLocator()));
        }
        if ((index = test.getIndex("name")) >= 0) {
            validattrs[index] = 1;
        }
        this.message = new WSDLMessageImpl(this.runtime.getLocator(), new QName(this.runtime.currentWSDL.getName().getNamespaceURI(), name), this.runtime.document);
        this.validateAttribute(this.runtime.getErrorHandler(), test, validattrs);
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
        switch (this.state) {
            case 1: {
                if (!uri.equals("http://schemas.xmlsoap.org/wsdl/") || !localName.equals("message")) break;
                this.endProcessingExtentionElement(this.message);
                this.revertToParentFromLeaveElement(this.message, this._cookie, uri, localName, qname);
                this.message.setDocumentation(this.getWSDLDocumentation());
            }
        }
    }
}

