/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.api.parser;

import com.sun.xml.xsom.parser.XMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.jvnet.wom.api.WSDLSet;
import org.jvnet.wom.api.parser.WSDLExtensionHandler;
import org.jvnet.wom.impl.parser.ParserContext;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.XMLParserImpl;
import org.jvnet.wom.impl.parser.handler.Definitions;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class WOMParser {
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private final XMLParser parser;
    private final ParserContext context;

    public WOMParser() {
        this.parser = new XMLParserImpl();
        this.context = new ParserContext(this, this.parser);
    }

    public WOMParser(SAXParserFactory factory) {
        this.parser = new XMLParserImpl(factory);
        this.context = new ParserContext(this, this.parser);
    }

    public WOMParser(XMLParser parser) {
        this.parser = parser;
        this.context = new ParserContext(this, this.parser);
    }

    public WSDLSet parse(InputSource wsdl) throws IOException, SAXException {
        this.context.parse(wsdl);
        return this.context.getResult();
    }

    public WSDLSet parse(File wsdl) throws IOException, SAXException {
        return this.parse(wsdl.toURL());
    }

    public WSDLSet parse(InputStream wsdl) throws SAXException {
        this.context.parse(new InputSource(wsdl));
        return this.context.getResult();
    }

    public WSDLSet parse(URL wsdl) throws SAXException {
        return this.parse(wsdl.toExternalForm());
    }

    public WSDLSet parse(String systemId) throws SAXException {
        this.context.parse(new InputSource(systemId));
        return this.context.getResult();
    }

    public WSDLSet parse(Reader reader) throws SAXException {
        this.context.parse(new InputSource(reader));
        return this.context.getResult();
    }

    public WSDLSet getResult() throws SAXException {
        return this.context.getResult();
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSchemaContentHandler(ContentHandler handler) {
        this.context.setSchemaContentHandler(handler);
    }

    public void addWSDLExtensionHandler(WSDLExtensionHandler extension) {
        this.context.addWSDLExtensionHandler(extension);
    }

    public XMLParser getDefaultXMLParserInstance() {
        return this.parser == null ? new XMLParserImpl() : this.parser;
    }

    public ContentHandler getParserHandler() {
        WSDLContentHandlerEx ch = this.context.createWSDLContentHandler();
        Definitions rootHandler = new Definitions(ch, null);
        ch.setRootHandler(rootHandler);
        return ch;
    }
}

