/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.policy.ConfigurationManager;
import com.sun.xml.ws.rm.runtime.ClientSession;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import com.sun.xml.ws.rm.runtime.ProtocolCommunicator;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import java.io.IOException;
import javax.xml.ws.WebServiceException;

final class RmClientTube
extends AbstractFilterTubeImpl {
    private static final RmLogger LOGGER = RmLogger.getLogger(RmClientTube.class);
    private final ClientSession session;
    private final WSDLPort wsdlPort;
    private Packet requestPacketCopy;

    RmClientTube(RmClientTube original, TubeCloner cloner) {
        super(original, cloner);
        this.session = original.session;
        this.wsdlPort = original.wsdlPort;
        this.requestPacketCopy = null;
    }

    RmClientTube(WsitClientTubeAssemblyContext context) throws RmRuntimeException {
        super(context.getTubelineHead());
        SecureConversationInitiator scInitiator = context.getImplementation(SecureConversationInitiator.class);
        if (scInitiator == null) {
            scInitiator = context.getScInitiator();
        }
        Configuration configuration = ConfigurationManager.createClientConfigurationManager(context.getWsdlPort(), context.getBinding()).getConfigurationAlternatives()[0];
        this.session = ClientSession.create(configuration, new ProtocolCommunicator(this.next, scInitiator, configuration));
        this.wsdlPort = context.getWsdlPort();
        this.requestPacketCopy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmClientTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            RmClientTube rmClientTube = new RmClientTube(this, cloner);
            return rmClientTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processRequest(Packet requestPacket) {
        LOGGER.entering();
        try {
            if (this.isResendAttempt()) {
                this.session.registerForResend(Fiber.current(), requestPacket);
                NextAction nextAction = this.doSuspend(this.next);
                return nextAction;
            }
            requestPacket = this.session.processOutgoingPacket(requestPacket);
            this.prepareForResend(requestPacket);
            NextAction nextAction = super.processRequest(requestPacket);
            return nextAction;
        }
        catch (RmRuntimeException ex) {
            LOGGER.logSevereException(ex);
            NextAction nextAction = this.doThrow((Throwable)((Object)ex));
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet responsePacket) {
        LOGGER.entering();
        try {
            boolean responseToOneWayRequest = this.requestPacketCopy.getMessage().isOneWay(this.wsdlPort);
            responsePacket = this.session.processIncommingPacket(responsePacket, responseToOneWayRequest);
            if (responseToOneWayRequest && this.requestNotAcknowledged(this.requestPacketCopy) || !responseToOneWayRequest && this.responseNotAvailableYet(responsePacket)) {
                LOGGER.fine(LocalizationMessages.WSRM_1102_RESENDING_DROPPED_MESSAGE());
                NextAction nextAction = this.doResend();
                return nextAction;
            }
            this.releaseResendResources();
            NextAction nextAction = super.processResponse(responsePacket);
            return nextAction;
        }
        catch (RmRuntimeException ex) {
            LOGGER.logSevereException(ex);
            this.releaseResendResources();
            NextAction nextAction = this.doThrow((Throwable)((Object)ex));
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processException(Throwable throwable) {
        LOGGER.entering();
        try {
            if (this.isResendPossible(throwable)) {
                NextAction nextAction = this.doResend();
                return nextAction;
            }
            this.releaseResendResources();
            NextAction nextAction = super.processException(throwable);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        LOGGER.entering();
        try {
            this.session.close();
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), ex);
        }
        finally {
            super.preDestroy();
            LOGGER.exiting();
        }
    }

    private boolean isResendPossible(Throwable throwable) {
        if (throwable instanceof IOException) {
            return true;
        }
        return throwable instanceof WebServiceException && throwable.getCause() instanceof IOException;
    }

    private NextAction doResend() {
        return super.doInvokeAndForget(this, this.requestPacketCopy.copy(true));
    }

    private boolean isResendAttempt() {
        return this.requestPacketCopy != null;
    }

    private void prepareForResend(Packet requestPacket) {
        this.requestPacketCopy = requestPacket.copy(true);
    }

    private void releaseResendResources() {
        this.requestPacketCopy = null;
    }

    private boolean responseNotAvailableYet(Packet responsePacket) {
        Message responseMessage = responsePacket.getMessage();
        return responseMessage != null && !responseMessage.hasPayload();
    }

    private boolean requestNotAcknowledged(Packet requestPacket) {
        return !this.session.sequenceManager.getSequence(this.session.outboundSequenceId).isAcknowledged(PacketAdapter.getInstance(this.session.configuration, requestPacket).getMessageNumber());
    }
}

