/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.PacketAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum FlowControledFibers {
    INSTANCE;

    private static final RmLogger LOGGER;
    private final Map<String, Queue<FiberRegistration>> repository = new HashMap<String, Queue<FiberRegistration>>();
    private final ReadWriteLock repositoryLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerForResume(Fiber fiber, PacketAdapter packetAdapter) {
        FiberRegistration registration = new FiberRegistration(fiber, packetAdapter);
        String sequenceId = packetAdapter.getSequenceId();
        try {
            Queue<Object> sequenceFibers;
            this.repositoryLock.writeLock().lock();
            if (!this.repository.containsKey(sequenceId)) {
                sequenceFibers = new PriorityQueue(10);
                this.repository.put(sequenceId, sequenceFibers);
            } else {
                sequenceFibers = this.repository.get(sequenceId);
            }
            if (sequenceFibers.contains(registration)) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("Duplicate registration: Another fiber already suspended for message [ %d ] on the sequence [ %s ]", registration.messageNumber, sequenceId));
                }
                boolean bl = false;
                return bl;
            }
            boolean offerResult = sequenceFibers.offer(registration);
            if (!offerResult && LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("Adding fiber to the suspended fiber's queue failed for message [ %d ] on the sequence [ %s ]", registration.messageNumber, sequenceId));
            }
            boolean bl = offerResult;
            return bl;
        }
        finally {
            this.repositoryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryResume(String sequenceId, long messageId) {
        FiberRegistration registration;
        Queue<FiberRegistration> sequenceBuffer = this.getSequenceBuffer(sequenceId);
        if (sequenceBuffer == null || sequenceBuffer.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("Nothing to resume: No fibers suspended on the sequence [ %s ]", sequenceId));
            }
            return false;
        }
        try {
            this.repositoryLock.writeLock().lock();
            long nextSuspendedMessageId = sequenceBuffer.peek().packetAdapter.getMessageNumber();
            if (nextSuspendedMessageId != messageId) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("No fiber resumed: Next suspended message [ %d ] is not as expected [ %d ] on the sequence [ %s ].", nextSuspendedMessageId, messageId, sequenceId));
                }
                boolean bl = false;
                return bl;
            }
            registration = sequenceBuffer.poll();
        }
        finally {
            this.repositoryLock.writeLock().unlock();
        }
        registration.fiber.resume(registration.packetAdapter.getPacket());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Resuming fiber for the suspended message [ %d ] is on the sequence [ %s ].", registration.messageNumber, sequenceId));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUsedBufferSize(String sequenceId) {
        Queue<FiberRegistration> sequenceBuffer = this.getSequenceBuffer(sequenceId);
        if (sequenceBuffer == null) {
            return 0;
        }
        try {
            this.repositoryLock.readLock().lock();
            int n = sequenceBuffer.size();
            return n;
        }
        finally {
            this.repositoryLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<FiberRegistration> getSequenceBuffer(String sequenceId) {
        try {
            this.repositoryLock.readLock().lock();
            Queue<FiberRegistration> queue = this.repository.get(sequenceId);
            return queue;
        }
        finally {
            this.repositoryLock.readLock().unlock();
        }
    }

    static {
        LOGGER = RmLogger.getLogger(FlowControledFibers.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FiberRegistration
    implements Comparable<FiberRegistration> {
        final PacketAdapter packetAdapter;
        final Fiber fiber;
        final long messageNumber;

        FiberRegistration(Fiber fiber, PacketAdapter packetAdapter) {
            this.fiber = fiber;
            this.packetAdapter = packetAdapter;
            this.messageNumber = packetAdapter.getMessageNumber();
        }

        public boolean equals(Object that) {
            if (!(that instanceof FiberRegistration)) {
                return false;
            }
            FiberRegistration thatRegistration = (FiberRegistration)that;
            return this.messageNumber == thatRegistration.messageNumber;
        }

        public int hashCode() {
            return 371 + (int)this.messageNumber;
        }

        @Override
        public int compareTo(FiberRegistration that) {
            return this.messageNumber < that.messageNumber ? -1 : (this.messageNumber == that.messageNumber ? 0 : 1);
        }
    }
}

