/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.treelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ListUI;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.treelist.RendererPanel;
import org.netbeans.modules.kenai.ui.treelist.TreeListModel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.netbeans.modules.kenai.ui.treelist.TreeListUI;
import org.openide.util.Utilities;

public class TreeList
extends JList {
    static final int INSETS_TOP = 3;
    static final int INSETS_BOTTOM = 3;
    static final int INSETS_LEFT = 4;
    static final int INSETS_RIGHT = 4;
    private static final String ACTION_EXPAND = "expandSet";
    private static final String ACTION_COLLAPSE = "collapseSet";
    private static final String ACTION_DEFAULT = "invokeDefaultAction";
    private Action expandAction;
    private Action collapseAction;
    private Action defaultAction;
    private final TreeListRenderer renderer = new TreeListRenderer();
    static final int ROW_HEIGHT = Math.max(16, Math.max(RendererPanel.getExpandedIcon().getIconHeight(), new JLabel((String)"X").getPreferredSize().height + 3 + 3));

    public TreeList(TreeListModel treeListModel) {
        super(treeListModel);
        this.setSelectionMode(0);
        this.setFixedCellHeight(ROW_HEIGHT + 2);
        this.setCellRenderer(this.renderer);
        this.setBackground(ColorManager.getDefault().getDefaultBackground());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ActionListener actionListener;
                TreeListNode treeListNode;
                if (mouseEvent.getClickCount() != 2 || mouseEvent.isPopupTrigger()) {
                    return;
                }
                int n = TreeList.this.locationToIndex(mouseEvent.getPoint());
                if (n < 0 || n >= TreeList.this.getModel().getSize()) {
                    return;
                }
                Object e = TreeList.this.getModel().getElementAt(n);
                if (e instanceof TreeListNode && null != (treeListNode = (TreeListNode)e) && !treeListNode.isExpandable() && null != (actionListener = treeListNode.getDefaultAction())) {
                    actionListener.actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.paramString()));
                }
            }
        });
    }

    public void setUI(ListUI listUI) {
        super.setUI(new TreeListUI());
    }

    public void updateUI() {
        super.updateUI();
        this.initKeysAndActions();
    }

    private void initKeysAndActions() {
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.expandAction = new ExpandAction();
        this.collapseAction = new CollapseAction();
        this.defaultAction = new DefaultAction();
        InputMap inputMap = this.getInputMap();
        InputMap inputMap2 = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 0), ACTION_EXPAND);
        inputMap.put(KeyStroke.getKeyStroke(37, 0), ACTION_COLLAPSE);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), ACTION_DEFAULT);
        inputMap2.remove(KeyStroke.getKeyStroke(39, 0));
        inputMap2.remove(KeyStroke.getKeyStroke(37, 0));
        inputMap2.remove(KeyStroke.getKeyStroke(10, 0));
        actionMap.put(ACTION_EXPAND, this.expandAction);
        actionMap.put(ACTION_COLLAPSE, this.collapseAction);
        actionMap.put(ACTION_DEFAULT, this.defaultAction);
    }

    private TreeListNode getSelectedTreeListNode() {
        Object e = super.getSelectedValue();
        if (e instanceof TreeListNode) {
            return (TreeListNode)e;
        }
        return null;
    }

    void showPopupMenuAt(int n, Point point) {
        TreeListNode treeListNode = (TreeListNode)this.getModel().getElementAt(n);
        Action[] actionArray = treeListNode.getPopupActions();
        if (null == actionArray || actionArray.length == 0) {
            return;
        }
        this.setSelectedIndex(n);
        JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Component)this);
        jPopupMenu.show(this, point.x, point.y);
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            super(TreeList.ACTION_DEFAULT);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionListener actionListener;
            TreeListNode treeListNode = TreeList.this.getSelectedTreeListNode();
            if (null != treeListNode && null != (actionListener = treeListNode.getDefaultAction())) {
                actionListener.actionPerformed(actionEvent);
            }
        }

        public boolean isEnabled() {
            TreeListNode treeListNode = TreeList.this.getSelectedTreeListNode();
            return null != treeListNode && null != treeListNode.getDefaultAction();
        }
    }

    private class CollapseAction
    extends AbstractAction {
        public CollapseAction() {
            super(TreeList.ACTION_COLLAPSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeListNode treeListNode = TreeList.this.getSelectedTreeListNode();
            if (null != treeListNode && treeListNode.isExpandable()) {
                treeListNode.setExpanded(false);
            }
        }

        public boolean isEnabled() {
            TreeListNode treeListNode = TreeList.this.getSelectedTreeListNode();
            return null != treeListNode && treeListNode.isExpandable();
        }
    }

    private class ExpandAction
    extends AbstractAction {
        public ExpandAction() {
            super(TreeList.ACTION_EXPAND);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeListNode treeListNode = TreeList.this.getSelectedTreeListNode();
            if (null != treeListNode && treeListNode.isExpandable()) {
                treeListNode.setExpanded(true);
            }
        }

        public boolean isEnabled() {
            TreeListNode treeListNode = TreeList.this.getSelectedTreeListNode();
            return null != treeListNode && treeListNode.isExpandable();
        }
    }

    private static class TreeListRenderer
    implements ListCellRenderer {
        private TreeListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof TreeListNode)) {
                return new JLabel();
            }
            TreeListNode treeListNode = (TreeListNode)object;
            int n2 = jList.getFixedCellHeight();
            Color color = bl ? jList.getSelectionBackground() : jList.getBackground();
            Color color2 = bl ? jList.getSelectionForeground() : jList.getForeground();
            return treeListNode.getRenderer(color2, color, bl, bl2, n2);
        }
    }
}

