/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.LoginHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.treelist.LeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.openide.util.NbBundle;

public class UserNode
extends LeafNode {
    private final DashboardImpl dashboard;
    private JPanel panel;
    private JLabel lblUser;
    private JLabel lblProgress;
    private LinkButton btnOpenProject;
    private LinkButton btnRefresh;
    private LinkButton btnLogin;
    private LoginHandle login;
    private boolean projectsAvailable = false;
    private final Object LOCK = new Object();
    private int loadingCounter = 0;

    public UserNode(DashboardImpl dashboardImpl) {
        super(null);
        this.dashboard = dashboardImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComponent getComponent(Color color, Color color2, boolean bl, boolean bl2) {
        if (null == this.panel) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setOpaque(false);
            this.btnLogin = new LinkButton(NbBundle.getMessage(UserNode.class, (String)"LBL_LoginToKenai"), this.dashboard.createLoginAction());
            this.lblUser = new TreeLabel();
            this.lblProgress = this.createProgressLabel(NbBundle.getMessage(UserNode.class, (String)"LBL_OpeningProjects"));
            this.btnOpenProject = new LinkButton(NbBundle.getMessage(UserNode.class, (String)"LBL_OpenProject"), ProjectAccessor.getDefault().getOpenNonMemberProjectAction());
            this.btnRefresh = new LinkButton(NbBundle.getMessage(UserNode.class, (String)"LBL_Refresh"), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DashboardImpl.getInstance().refreshProjects();
                }
            });
            this.panel.add((Component)this.btnLogin, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
            this.panel.add((Component)this.lblUser, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.btnRefresh, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.lblProgress, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.btnOpenProject, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
        }
        this.lblProgress.setForeground(color);
        if (bl) {
            this.lblUser.setForeground(color);
        } else {
            this.lblUser.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        this.btnOpenProject.setForeground(color, bl);
        this.btnRefresh.setForeground(color, bl);
        this.btnLogin.setForeground(color, bl);
        Object object = this.LOCK;
        synchronized (object) {
            this.lblProgress.setVisible(this.loadingCounter > 0);
            this.btnRefresh.setVisible(this.loadingCounter <= 0 && (this.projectsAvailable || null != this.login));
        }
        if (null != this.login) {
            this.lblUser.setText(this.login.getUserName());
        }
        this.btnLogin.setVisible(null == this.login);
        this.lblUser.setVisible(null != this.login);
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadingStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            ++this.loadingCounter;
            this.fireContentChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadingFinished() {
        Object object = this.LOCK;
        synchronized (object) {
            --this.loadingCounter;
            if (this.loadingCounter < 0) {
                this.loadingCounter = 0;
            }
            this.fireContentChanged();
        }
    }

    void set(LoginHandle loginHandle, boolean bl) {
        this.projectsAvailable = bl;
        this.login = loginHandle;
        this.fireContentChanged();
    }
}

