/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.netbeans.modules.kenai.ui.treelist.AsynchronousLeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryNode
extends AsynchronousLeafNode<List<QueryResultHandle>>
implements PropertyChangeListener {
    private final QueryHandle query;
    private JPanel panel;
    private List<JLabel> labels = new ArrayList<JLabel>(15);
    private List<LinkButton> buttons = new ArrayList<LinkButton>(10);
    private final Object LOCK = new Object();

    public QueryNode(QueryHandle queryHandle, TreeListNode treeListNode) {
        super(treeListNode, queryHandle.getDisplayName());
        this.query = queryHandle;
        queryHandle.addPropertyChangeListener(this);
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.query.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("queryResult".equals(propertyChangeEvent.getPropertyName())) {
            this.refresh();
        }
    }

    @Override
    public ActionListener getDefaultAction() {
        return QueryAccessor.getDefault().getDefaultAction(this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configure(JComponent jComponent, Color color, Color color2, boolean bl, boolean bl2) {
        Object object = this.LOCK;
        synchronized (object) {
            for (JLabel jComponent2 : this.labels) {
                jComponent2.setForeground(color);
            }
            for (LinkButton linkButton : this.buttons) {
                linkButton.setForeground(color, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent createComponent(List<QueryResultHandle> list) {
        QueryAccessor queryAccessor = QueryAccessor.getDefault();
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.labels.clear();
            this.buttons.clear();
            int n = 0;
            TreeLabel treeLabel = new TreeLabel(this.query.getDisplayName());
            this.labels.add(treeLabel);
            this.panel.add((Component)treeLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            treeLabel = new TreeLabel("(");
            this.labels.add(treeLabel);
            this.panel.add((Component)treeLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            for (int i = 0; i < list.size(); ++i) {
                QueryResultHandle queryResultHandle = list.get(i);
                LinkButton linkButton = new LinkButton(queryResultHandle.getText(), queryAccessor.getOpenQueryResultAction(queryResultHandle));
                this.buttons.add(linkButton);
                this.panel.add((Component)linkButton, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                if (i >= list.size() - 1) continue;
                treeLabel = new TreeLabel("|");
                this.labels.add(treeLabel);
                this.panel.add((Component)treeLabel, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
            }
            treeLabel = new TreeLabel(")");
            this.labels.add(treeLabel);
            this.panel.add((Component)treeLabel, new GridBagConstraints(n++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.panel;
    }

    @Override
    protected List<QueryResultHandle> load() {
        QueryAccessor queryAccessor = QueryAccessor.getDefault();
        return queryAccessor.getQueryResults(this.query);
    }
}

