/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;

public class LinkButton
extends JButton {
    public LinkButton(Image image, ActionListener actionListener) {
        this(new ImageIcon(image), actionListener);
    }

    public LinkButton(Icon icon, ActionListener actionListener) {
        this.setIcon(icon);
        this.setPressedIcon(icon);
        this.init(actionListener);
    }

    public LinkButton(String string, Icon icon, ActionListener actionListener) {
        super(string);
        this.setIcon(icon);
        this.setPressedIcon(icon);
        this.init(actionListener);
    }

    public LinkButton(String string, ActionListener actionListener) {
        super(string);
        this.init(actionListener);
    }

    public void setForeground(Color color, boolean bl) {
        if (bl) {
            if (color instanceof UIResource) {
                color = new Color(color.getRGB());
            }
            this.setForeground(color);
        } else if (this.isEnabled()) {
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
    }

    private void init(ActionListener actionListener) {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.setContentAreaFilled(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setModel(new Model());
        if (null != actionListener) {
            this.addActionListener(actionListener);
            this.setForeground(ColorManager.getDefault().getLinkColor());
        } else {
            this.setEnabled(false);
            this.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        this.setFont(UIManager.getFont("Tree.font"));
    }

    private static class Model
    extends DefaultButtonModel {
        private Model() {
        }

        public boolean isPressed() {
            return false;
        }
    }
}

