/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.ui.NbProjectHandleImpl;
import org.netbeans.modules.kenai.ui.RecentProjectsCache;
import org.netbeans.modules.kenai.ui.spi.NbProjectHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.versioning.system.cvss.api.CVS;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceHandleImpl
extends SourceHandle
implements PropertyChangeListener {
    private KenaiFeature feature;
    private Preferences prefs;
    private ProjectHandle projectHandle;
    private static final int MAX_PROJECTS = 5;
    private static final String RECENTPROJECTS_PREFIX = "recent.projects.";
    private String externalScmType = "unknown";
    public static final String SCM_TYPE_UNKNOWN = "unknown";
    public static final String SCM_TYPE_CVS = "cvs";
    List<NbProjectHandle> recent = new ArrayList<NbProjectHandle>();

    public String getExternalScmType() {
        return this.externalScmType;
    }

    public SourceHandleImpl(ProjectHandle projectHandle, KenaiFeature kenaiFeature) {
        this.feature = kenaiFeature;
        if ("mercurial".equals(this.feature.getService())) {
            this.prefs = NbPreferences.forModule(Mercurial.class);
        } else if ("subversion".equals(this.feature.getService())) {
            this.prefs = NbPreferences.forModule(Subversion.class);
        } else if ("external_repository".equals(this.feature.getService())) {
            if (Subversion.isRepository((String)this.feature.getLocation())) {
                this.externalScmType = "subversion";
                return;
            }
            if (CVS.isRepository((String)this.feature.getLocation())) {
                this.externalScmType = SCM_TYPE_CVS;
                return;
            }
            if (Mercurial.isRepository((String)this.feature.getLocation())) {
                this.externalScmType = "mercurial";
                return;
            }
        }
        this.projectHandle = projectHandle;
        OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjects.getDefault()));
        this.initRecent();
    }

    @Override
    public String getDisplayName() {
        return this.feature.getDisplayName();
    }

    @Override
    public boolean isSupported() {
        return "subversion".equals(this.feature.getService()) || "mercurial".equals(this.feature.getService()) || "external_repository".equals(this.feature.getService());
    }

    @Override
    public List<NbProjectHandle> getRecentProjects() {
        return this.recent;
    }

    @Override
    public File getWorkingDirectory() {
        if (this.prefs == null) {
            return this.guessWorkdir();
        }
        try {
            String string = this.prefs.get("working.dir." + this.feature.getLocation(), null);
            if (string != null) {
                URI uRI = new URI(string);
                File file = new File(uRI);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject == null || !fileObject.isValid()) {
                    return null;
                }
                return file;
            }
            return this.guessWorkdir();
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
            return this.guessWorkdir();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        List<Project> list = this.getNewProjects((Project[])propertyChangeEvent.getOldValue(), (Project[])propertyChangeEvent.getNewValue());
        this.addToRecentProjects(list, true);
    }

    void remove(NbProjectHandleImpl nbProjectHandleImpl) {
        this.recent.remove(nbProjectHandleImpl);
        this.storeRecent();
        this.projectHandle.firePropertyChange("sourceList", null, null);
    }

    void refresh() {
        if (this.projectHandle != null) {
            this.projectHandle.firePropertyChange("sourceList", null, null);
        }
    }

    private void addToRecentProjects(List<Project> list, boolean bl) {
        for (Project project : list) {
            try {
                if (!this.isUnder(project.getProjectDirectory())) continue;
                NbProjectHandleImpl nbProjectHandleImpl = RecentProjectsCache.getDefault().getProjectHandle(project, this);
                this.recent.remove(nbProjectHandleImpl);
                this.recent.add(0, nbProjectHandleImpl);
                if (this.recent.size() > 5) {
                    this.recent.remove(5);
                }
                this.storeRecent();
                if (!bl) continue;
                this.projectHandle.firePropertyChange("sourceList", null, null);
            }
            catch (IOException iOException) {
                Logger.getLogger(SourceHandleImpl.class.getName()).fine("Project not found for " + project);
            }
        }
    }

    private List<Project> getNewProjects(Project[] projectArray, Project[] projectArray2) {
        if (projectArray2 == null) {
            return Collections.emptyList();
        }
        if (projectArray == null) {
            return Arrays.asList(projectArray2);
        }
        ArrayList<Project> arrayList = new ArrayList<Project>();
        arrayList.addAll(Arrays.asList(projectArray2));
        arrayList.removeAll(Arrays.asList(projectArray));
        return arrayList;
    }

    private File guessWorkdir() {
        if (this.recent.isEmpty()) {
            return null;
        }
        try {
            FileObject fileObject = ((NbProjectHandleImpl)this.recent.iterator().next()).getProject().getProjectDirectory().getParent();
            if (fileObject.isValid()) {
                return FileUtil.toFile((FileObject)fileObject);
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void initRecent() {
        Object iOException;
        if (this.prefs == null) {
            return;
        }
        List<String> list = SourceHandleImpl.getStringList(this.prefs, RECENTPROJECTS_PREFIX + this.feature.getLocation());
        for (String object22 : list) {
            try {
                iOException = RecentProjectsCache.getDefault().getProjectHandle(new URL(object22), this);
                if (iOException == null) continue;
                this.recent.add((NbProjectHandle)iOException);
            }
            catch (IOException iOException2) {
                Logger.getLogger(SourceHandleImpl.class.getName()).fine("Project not found for " + object22);
            }
        }
        int n = this.recent.size();
        LinkedList<Project> linkedList = new LinkedList<Project>();
        iOException = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; n < 5 && i < ((Project[])iOException).length; ++i) {
            if (!this.isUnder(iOException[i].getProjectDirectory())) continue;
            linkedList.add(iOException[i]);
            ++n;
        }
        this.addToRecentProjects(linkedList, false);
    }

    private boolean isUnder(FileObject fileObject) {
        String string = (String)fileObject.getAttribute("ProvidedExtensions.RemoteLocation");
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.feature.getLocation().equals(string);
    }

    private void storeRecent() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (NbProjectHandle nbProjectHandle : this.recent) {
            arrayList.add(((NbProjectHandleImpl)nbProjectHandle).url.toString());
        }
        if (this.prefs != null) {
            SourceHandleImpl.putStringList(this.prefs, RECENTPROJECTS_PREFIX + this.feature.getLocation(), arrayList);
        }
    }

    public static List<String> getStringList(Preferences preferences, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = preferences.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || !string2.startsWith(string)) continue;
                int n = Integer.parseInt(string2.substring(string2.lastIndexOf(46) + 1));
                arrayList.add(n + "." + preferences.get(string2, null));
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
            arrayList2.addAll(arrayList);
            for (String string3 : arrayList) {
                int n = string3.indexOf(46);
                int n2 = Integer.parseInt(string3.substring(0, n));
                arrayList2.set(n2, string3.substring(n + 1));
            }
            return arrayList2;
        }
        catch (Exception exception) {
            Logger.getLogger(SourceHandleImpl.class.getName()).log(Level.INFO, null, exception);
            return new ArrayList<String>(0);
        }
    }

    public static void putStringList(Preferences preferences, String string, List<String> list) {
        try {
            int n;
            String[] stringArray = preferences.keys();
            for (n = 0; n < stringArray.length; ++n) {
                String string2 = stringArray[n];
                if (string2 == null || !string2.startsWith(string + ".")) continue;
                preferences.remove(string2);
            }
            n = 0;
            for (String string3 : list) {
                preferences.put(string + "." + n++, string3);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(SourceHandleImpl.class.getName()).log(Level.INFO, null, backingStoreException);
        }
    }
}

