/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.SourceAndIssuesWizardPanel;
import org.netbeans.modules.kenai.ui.Utilities;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAndIssuesWizardPanelGUI
extends JPanel {
    private WizardDescriptor settings;
    private SourceAndIssuesWizardPanel panel;
    private List<KenaiService> repositoriesList = null;
    private List<KenaiService> issuesList = null;
    static final String REPO_NAME_PREVIEW_MSG = "https://kenai.com/{0}/{1}~{2}";
    private static final String HG_REPO_NAME = "hg";
    static final String SVN_REPO_NAME = "svn";
    private static final String DEFAULT_REPO_FOLDER = "{0}~{1}";
    private static final String SVN_REPO_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.SubversionOnKenai");
    private static final String HG_REPO_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.MercurialOnKenai");
    private static final String EXT_REPO_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.External");
    private static final String NO_REPO_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.None");
    private static final String BGZ_ISSUES_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.BugzillaOnKenai");
    private static final String JIRA_ISSUES_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.JIRAOnKenai");
    private static final String EXT_ISSUES_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.External");
    private static final String NO_ISSUES_ITEM = NbBundle.getMessage(SourceAndIssuesWizardPanel.class, (String)"SourceAndIssuesWizardPanelGUI.None");
    static final String SVN_DEFAULT_NAME = "subversion";
    private static final String HG_DEFAULT_NAME = "mercurial";
    private static final int PANEL_HEIGHT = 110;
    private boolean localFolderPathEdited = false;
    private String criticalMessage = null;
    private JSeparator chatSeparator;
    private JCheckBox createChatRoom;
    private JLabel downloadsLabel;
    private JLabel featuresDescLabel;
    private JLabel forumsLabel;
    private JLabel issueTrackingLabel;
    private JLabel issueTrackingUrlLabel;
    private JComboBox issuesComboBox;
    private JPanel issuesSpacerPanel;
    private JTextField issuesUrlTextField;
    private JSeparator itSeparator;
    private JButton localFolderBrowseButton;
    private JTextField localFolderTextField;
    private JLabel localRepoFolderLabel;
    private JLabel mListsLabel;
    private JLabel noIssueTrackingDescLabel;
    private JLabel noneRepoDescLabel;
    private JLabel otherFeaturesLabel;
    private JComboBox repoComboBox;
    private JLabel repoNameLabel;
    private JLabel repoNamePreviewLabel;
    private JTextField repoNameTextField;
    private JPanel repoSpacerPanel;
    private JLabel repoUrlLabel;
    private JTextField repoUrlTextField;
    private JSeparator scSeparator;
    private JLabel sourceCodeLabel;
    private JPanel spacerPanel;
    private JLabel wikiLabel;

    public SourceAndIssuesWizardPanelGUI(SourceAndIssuesWizardPanel sourceAndIssuesWizardPanel) {
        this.panel = sourceAndIssuesWizardPanel;
        this.initComponents();
        this.spacerPanel.setPreferredSize(this.localFolderBrowseButton.getPreferredSize());
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SourceAndIssuesWizardPanelGUI.this.panel.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SourceAndIssuesWizardPanelGUI.this.panel.fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SourceAndIssuesWizardPanelGUI.this.panel.fireChangeEvent();
            }
        };
        DocumentListener documentListener2 = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SourceAndIssuesWizardPanelGUI.this.updateRepoNamePreview();
                SourceAndIssuesWizardPanelGUI.this.updateRepoPath();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SourceAndIssuesWizardPanelGUI.this.updateRepoNamePreview();
                SourceAndIssuesWizardPanelGUI.this.updateRepoPath();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SourceAndIssuesWizardPanelGUI.this.updateRepoNamePreview();
                SourceAndIssuesWizardPanelGUI.this.updateRepoPath();
            }
        };
        this.repoNameTextField.getDocument().addDocumentListener(documentListener2);
        this.repoNameTextField.getDocument().addDocumentListener(documentListener);
        this.localFolderTextField.getDocument().addDocumentListener(documentListener);
        this.repoUrlTextField.getDocument().addDocumentListener(documentListener);
        this.issuesUrlTextField.getDocument().addDocumentListener(documentListener);
        this.setupServicesListModels();
        this.showRepoOnKenaiGUI();
        this.showIssuesOnKenaiGUI();
        this.createChatRoom.setVisible(false);
        this.chatSeparator.setVisible(false);
        if (!System.getProperty("kenai.com.url", "https://kenai.com").endsWith("testkenai.com")) {
            this.createChatRoom.setSelected(false);
        }
        this.setPreferredSize(new Dimension(Math.max(700, this.getPreferredSize().width), 450));
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.panelName");
    }

    private void setupServicesListModels() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String string;
                Collection collection = null;
                try {
                    collection = Kenai.getDefault().getServices();
                }
                catch (KenaiException kenaiException) {
                    // empty catch block
                }
                boolean bl = false;
                ArrayList<KenaiService> arrayList = new ArrayList<KenaiService>();
                final DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
                ArrayList<KenaiService> arrayList2 = new ArrayList<KenaiService>();
                final DefaultComboBoxModel<Object> defaultComboBoxModel2 = new DefaultComboBoxModel<Object>();
                if (collection != null) {
                    bl = true;
                    for (KenaiService kenaiService : collection) {
                        if (kenaiService.getType() != KenaiService.Type.SOURCE) continue;
                        arrayList.add(kenaiService);
                    }
                    for (KenaiService kenaiService : collection) {
                        if (kenaiService.getType() != KenaiService.Type.ISSUES) continue;
                        arrayList2.add(kenaiService);
                    }
                } else {
                    bl = false;
                    defaultComboBoxModel.addElement(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noRepoAvailable"));
                    defaultComboBoxModel2.addElement(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noIssuesAvailable"));
                }
                if (!arrayList.isEmpty()) {
                    for (KenaiService kenaiService : arrayList) {
                        string = kenaiService.getName();
                        if (SourceAndIssuesWizardPanelGUI.SVN_DEFAULT_NAME.equals(string)) {
                            defaultComboBoxModel.addElement(new KenaiServiceItem(kenaiService, SVN_REPO_ITEM));
                            continue;
                        }
                        if (SourceAndIssuesWizardPanelGUI.HG_DEFAULT_NAME.equals(string)) {
                            defaultComboBoxModel.addElement(new KenaiServiceItem(kenaiService, HG_REPO_ITEM));
                            continue;
                        }
                        if (!"external_repository".equals(string)) continue;
                        defaultComboBoxModel.addElement(new KenaiServiceItem(kenaiService, EXT_REPO_ITEM));
                    }
                    defaultComboBoxModel.addElement(new KenaiServiceItem(null, NO_REPO_ITEM));
                    SourceAndIssuesWizardPanelGUI.this.setRepositories(arrayList);
                }
                if (!arrayList2.isEmpty()) {
                    for (KenaiService kenaiService : arrayList2) {
                        string = kenaiService.getName();
                        if ("bugzilla".equals(string)) {
                            defaultComboBoxModel2.addElement(new KenaiServiceItem(kenaiService, BGZ_ISSUES_ITEM));
                            continue;
                        }
                        if ("jira".equals(string)) {
                            defaultComboBoxModel2.addElement(new KenaiServiceItem(kenaiService, JIRA_ISSUES_ITEM));
                            continue;
                        }
                        if (!"external_issues".equals(string)) continue;
                        defaultComboBoxModel2.addElement(new KenaiServiceItem(kenaiService, EXT_ISSUES_ITEM));
                    }
                    defaultComboBoxModel2.addElement(new KenaiServiceItem(null, NO_ISSUES_ITEM));
                    SourceAndIssuesWizardPanelGUI.this.setIssues(arrayList2);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SourceAndIssuesWizardPanelGUI.this.repoComboBox.setModel(defaultComboBoxModel);
                        SourceAndIssuesWizardPanelGUI.this.repoComboBox.setEnabled(true);
                        SourceAndIssuesWizardPanelGUI.this.issuesComboBox.setModel(defaultComboBoxModel2);
                        SourceAndIssuesWizardPanelGUI.this.issuesComboBox.setEnabled(true);
                    }
                });
            }
        });
    }

    private synchronized void setRepositories(List<KenaiService> list) {
        this.repositoriesList = list;
    }

    private synchronized List<KenaiService> getRepositories() {
        return this.repositoriesList;
    }

    private synchronized void setIssues(List<KenaiService> list) {
        this.issuesList = list;
    }

    private synchronized List<KenaiService> getIssues() {
        return this.issuesList;
    }

    private void updateRepoNamePreview() {
        String string;
        String string2 = (String)this.settings.getProperty("projectName");
        if (SVN_DEFAULT_NAME.equals(this.getRepoType())) {
            string = SVN_REPO_NAME;
        } else if (HG_DEFAULT_NAME.equals(this.getRepoType())) {
            string = HG_REPO_NAME;
        } else {
            return;
        }
        String string3 = MessageFormat.format(REPO_NAME_PREVIEW_MSG, string, string2, this.repoNameTextField.getText());
        this.repoNamePreviewLabel.setText(string3);
    }

    private void updateRepoPath() {
        if (!this.localFolderPathEdited) {
            String string = (String)this.settings.getProperty("projectName");
            this.setRepoLocal(Utilities.getDefaultRepoFolder().getPath() + File.separator + MessageFormat.format(DEFAULT_REPO_FOLDER, string, this.getRepoName()));
        }
    }

    private void setDefaultRepoName() {
        if (SVN_DEFAULT_NAME.equals(this.getRepoType()) && (HG_DEFAULT_NAME.equals(this.getRepoName()) || "".equals(this.getRepoName()))) {
            this.setRepoName(SVN_DEFAULT_NAME);
        } else if (HG_DEFAULT_NAME.equals(this.getRepoType()) && (SVN_DEFAULT_NAME.equals(this.getRepoName()) || "".equals(this.getRepoName()))) {
            this.setRepoName(HG_DEFAULT_NAME);
        }
    }

    private void initComponents() {
        this.sourceCodeLabel = new JLabel();
        this.repoComboBox = new JComboBox();
        this.issueTrackingLabel = new JLabel();
        this.issuesComboBox = new JComboBox();
        this.otherFeaturesLabel = new JLabel();
        this.downloadsLabel = new JLabel();
        this.forumsLabel = new JLabel();
        this.mListsLabel = new JLabel();
        this.wikiLabel = new JLabel();
        this.featuresDescLabel = new JLabel();
        this.scSeparator = new JSeparator();
        this.itSeparator = new JSeparator();
        this.repoNameLabel = new JLabel();
        this.repoNameTextField = new JTextField();
        this.localRepoFolderLabel = new JLabel();
        this.repoNamePreviewLabel = new JLabel();
        this.localFolderTextField = new JTextField();
        this.chatSeparator = new JSeparator();
        this.createChatRoom = new JCheckBox();
        this.localFolderBrowseButton = new JButton();
        this.spacerPanel = new JPanel();
        this.repoUrlLabel = new JLabel();
        this.repoUrlTextField = new JTextField();
        this.noneRepoDescLabel = new JLabel();
        this.issueTrackingUrlLabel = new JLabel();
        this.issuesUrlTextField = new JTextField();
        this.noIssueTrackingDescLabel = new JLabel();
        this.issuesSpacerPanel = new JPanel();
        this.repoSpacerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.sourceCodeLabel.setLabelFor(this.repoComboBox);
        Mnemonics.setLocalizedText((JLabel)this.sourceCodeLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.sourceCodeLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.sourceCodeLabel, gridBagConstraints);
        this.sourceCodeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.sourceCodeLabel.AccessibleContext.accessibleDescription"));
        this.repoComboBox.setEnabled(false);
        this.repoComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceAndIssuesWizardPanelGUI.this.repoComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.add((Component)this.repoComboBox, gridBagConstraints);
        this.repoComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoComboBox.AccessibleContext.accessibleName"));
        this.repoComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoComboBox.AccessibleContext.accessibleDescription"));
        this.issueTrackingLabel.setLabelFor(this.issuesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.issueTrackingLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.issueTrackingLabel, gridBagConstraints);
        this.issueTrackingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingLabel.AccessibleContext.accessibleDescription"));
        this.issuesComboBox.setEnabled(false);
        this.issuesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceAndIssuesWizardPanelGUI.this.issuesComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.issuesComboBox, gridBagConstraints);
        this.issuesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesComboBox.AccessibleContext.accessibleName"));
        this.issuesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesComboBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.otherFeaturesLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.otherFeaturesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.otherFeaturesLabel, gridBagConstraints);
        this.otherFeaturesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.otherFeaturesLabel.AccessibleContext.accessibleDescription"));
        this.downloadsLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/dot.png")));
        Mnemonics.setLocalizedText((JLabel)this.downloadsLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.downloadsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.downloadsLabel, gridBagConstraints);
        this.forumsLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/dot.png")));
        Mnemonics.setLocalizedText((JLabel)this.forumsLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.forumsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.forumsLabel, gridBagConstraints);
        this.mListsLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/dot.png")));
        Mnemonics.setLocalizedText((JLabel)this.mListsLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.mListsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.mListsLabel, gridBagConstraints);
        this.wikiLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/kenai/ui/resources/dot.png")));
        Mnemonics.setLocalizedText((JLabel)this.wikiLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.wikiLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.wikiLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.featuresDescLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.featuresDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.featuresDescLabel, gridBagConstraints);
        this.featuresDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.featuresDescLabel.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.scSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.itSeparator, gridBagConstraints);
        this.repoNameLabel.setLabelFor(this.repoNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.repoNameLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.repoNameLabel, gridBagConstraints);
        this.repoNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameLabel.AccessibleContext.accessibleDescription"));
        this.repoNameTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.repoNameTextField, gridBagConstraints);
        this.repoNameTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameTextField.AccessibleContext.accessibleName"));
        this.repoNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNameTextField.AccessibleContext.accessibleDescription"));
        this.localRepoFolderLabel.setLabelFor(this.localFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.localRepoFolderLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localRepoFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.localRepoFolderLabel, gridBagConstraints);
        this.localRepoFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localRepoFolderLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.repoNamePreviewLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNamePreviewLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 16, 0);
        this.add((Component)this.repoNamePreviewLabel, gridBagConstraints);
        this.repoNamePreviewLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNamePreviewLabel.AccessibleContext.accessibleName"));
        this.repoNamePreviewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoNamePreviewLabel.AccessibleContext.accessibleDescription"));
        this.localFolderTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderTextField.text"));
        this.localFolderTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SourceAndIssuesWizardPanelGUI.this.localFolderTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.localFolderTextField, gridBagConstraints);
        this.localFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderTextField.AccessibleContext.accessibleName"));
        this.localFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderTextField.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.chatSeparator, gridBagConstraints);
        this.createChatRoom.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createChatRoom, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.createChatRoom.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.createChatRoom, gridBagConstraints);
        this.createChatRoom.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.createChatRoom.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.localFolderBrowseButton, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderBrowseButton.text"));
        this.localFolderBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceAndIssuesWizardPanelGUI.this.localFolderBrowseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.localFolderBrowseButton, gridBagConstraints);
        this.localFolderBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.localFolderBrowseButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.spacerPanel, gridBagConstraints);
        this.repoUrlLabel.setLabelFor(this.repoUrlTextField);
        Mnemonics.setLocalizedText((JLabel)this.repoUrlLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.repoUrlLabel, gridBagConstraints);
        this.repoUrlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlLabel.AccessibleContext.accessibleDescription"));
        this.repoUrlTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.repoUrlTextField, gridBagConstraints);
        this.repoUrlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlTextField.AccessibleContext.accessibleName"));
        this.repoUrlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.repoUrlTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.noneRepoDescLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noneRepoDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.noneRepoDescLabel, gridBagConstraints);
        this.noneRepoDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noneRepoDescLabel.AccessibleContext.accessibleDescription"));
        this.issueTrackingUrlLabel.setLabelFor(this.issuesUrlTextField);
        Mnemonics.setLocalizedText((JLabel)this.issueTrackingUrlLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingUrlLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.issueTrackingUrlLabel, gridBagConstraints);
        this.issueTrackingUrlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issueTrackingUrlLabel.AccessibleContext.accessibleDescription"));
        this.issuesUrlTextField.setText(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesUrlTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 0);
        this.add((Component)this.issuesUrlTextField, gridBagConstraints);
        this.issuesUrlTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesUrlTextField.AccessibleContext.accessibleName"));
        this.issuesUrlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.issuesUrlTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.noIssueTrackingDescLabel, (String)NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noIssueTrackingDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.noIssueTrackingDescLabel, gridBagConstraints);
        this.noIssueTrackingDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.noIssueTrackingDescLabel.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        this.add((Component)this.issuesSpacerPanel, gridBagConstraints);
        this.repoSpacerPanel.setMinimumSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        this.add((Component)this.repoSpacerPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceAndIssuesWizardPanelGUI.class, (String)"SourceAndIssuesWizardPanelGUI.AccessibleContext.accessibleDescription"));
    }

    private void repoComboBoxActionPerformed(ActionEvent actionEvent) {
        KenaiServiceItem kenaiServiceItem = (KenaiServiceItem)this.repoComboBox.getSelectedItem();
        if (kenaiServiceItem != null && kenaiServiceItem.getService() != null) {
            if (SVN_DEFAULT_NAME.equals(kenaiServiceItem.getService().getName()) || HG_DEFAULT_NAME.equals(kenaiServiceItem.getService().getName())) {
                this.showRepoOnKenaiGUI();
                this.setDefaultRepoName();
                this.updateRepoNamePreview();
                this.updateRepoPath();
            } else if ("external_repository".equals(kenaiServiceItem.getService().getName())) {
                this.showExtRepoGUI();
            }
        } else {
            this.showNoRepoGUI();
        }
        this.panel.fireChangeEvent();
    }

    private void localFolderBrowseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        File file = new File(this.localFolderTextField.getText());
        if (file.exists()) {
            jFileChooser.setCurrentDirectory(FileUtil.normalizeFile((File)file));
        }
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.localFolderTextField.setText(file2.getAbsolutePath());
            this.localFolderPathEdited = true;
        }
        this.panel.fireChangeEvent();
    }

    private void issuesComboBoxActionPerformed(ActionEvent actionEvent) {
        KenaiServiceItem kenaiServiceItem = (KenaiServiceItem)this.issuesComboBox.getSelectedItem();
        if (kenaiServiceItem != null && kenaiServiceItem.getService() != null) {
            if ("bugzilla".equals(kenaiServiceItem.getService().getName()) || "jira".equals(kenaiServiceItem.getService().getName())) {
                this.showIssuesOnKenaiGUI();
            } else if ("external_issues".equals(kenaiServiceItem.getService().getName())) {
                this.showExtIssuesGUI();
            }
        } else {
            this.showNoIssuesGUI();
        }
        this.panel.fireChangeEvent();
    }

    private void localFolderTextFieldKeyTyped(KeyEvent keyEvent) {
        this.localFolderPathEdited = true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.panel.fireChangeEvent();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.putClientProperty("exceptionErrorMessage", null);
    }

    public boolean valid() {
        String string = this.checkForErrors();
        if (string != null) {
            this.settings.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        this.settings.putProperty("WizardPanel_errorMessage", null);
        string = this.checkForWarnings();
        if (string != null) {
            this.settings.putProperty("WizardPanel_warningMessage", (Object)string);
            return false;
        }
        this.settings.putProperty("WizardPanel_warningMessage", null);
        string = this.checkForInfos();
        if (string != null) {
            this.settings.putProperty("WizardPanel_infoMessage", (Object)string);
            return false;
        }
        this.settings.putProperty("WizardPanel_infoMessage", null);
        return true;
    }

    private String checkForErrors() {
        String string = (String)this.getClientProperty("exceptionErrorMessage");
        if (string != null) {
            return string;
        }
        return null;
    }

    private String checkForWarnings() {
        return null;
    }

    private String checkForInfos() {
        String string = this.getRepoLocal();
        if ((SVN_DEFAULT_NAME.equals(this.getRepoType()) || HG_DEFAULT_NAME.equals(this.getRepoType())) && ("".equals(string) || string == null)) {
            return "Local repository folder path is required";
        }
        String string2 = this.getRepoUrl();
        if ("external_repository".equals(this.getRepoType()) && ("".equals(string2) || string2 == null)) {
            return "External repository URL is required";
        }
        String string3 = this.getIssuesUrl();
        if ("external_issues".equals(this.getIssuesType()) && ("".equals(string3) || string3 == null)) {
            return "External issue tracking URL is required";
        }
        return null;
    }

    public void validateWizard() throws WizardValidationException {
    }

    public void read(WizardDescriptor wizardDescriptor) {
        String string;
        this.settings = wizardDescriptor;
        String string2 = (String)this.settings.getProperty("projectSCMType");
        String string3 = (String)this.settings.getProperty("projectSCMName");
        if (string3 == null || "".equals(string3.trim())) {
            this.setDefaultRepoName();
        } else {
            this.setRepoName(string3);
        }
        String string4 = (String)this.settings.getProperty("projectSCMUrl");
        if (string4 == null || "".equals(string4.trim())) {
            this.setRepoUrl("");
        } else {
            this.setRepoUrl(string4);
        }
        String string5 = (String)this.settings.getProperty("projectSCMLocal");
        if (string5 == null || "".equals(string5.trim())) {
            string = (String)this.settings.getProperty("projectName");
            this.setRepoLocal(Utilities.getDefaultRepoFolder().getPath() + File.separator + MessageFormat.format(DEFAULT_REPO_FOLDER, string, this.getRepoName()));
        } else {
            this.setRepoLocal(string5);
        }
        string = (String)this.settings.getProperty("projectIssues");
        String string6 = (String)this.settings.getProperty("projectIssuesUrl");
        if (string6 == null || "".equals(string6.trim())) {
            this.setRepoUrl("");
        } else {
            this.setRepoUrl(string6);
        }
        Boolean bl = (Boolean)this.settings.getProperty("projectCreateChat");
        if (bl != null) {
            this.createChatRoom.setSelected(bl);
        }
    }

    public void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("projectSCMType", (Object)this.getRepoType());
        wizardDescriptor.putProperty("projectSCMName", (Object)this.getRepoName());
        wizardDescriptor.putProperty("projectSCMUrl", (Object)this.getRepoUrl());
        wizardDescriptor.putProperty("projectSCMLocal", (Object)this.getRepoLocal());
        wizardDescriptor.putProperty("projectIssues", (Object)this.getIssuesType());
        wizardDescriptor.putProperty("projectIssuesUrl", (Object)this.getIssuesUrl());
        wizardDescriptor.putProperty("projectCreateChat", (Object)this.createChatRoom.isSelected());
    }

    private void setRepoType(String string) {
    }

    private String getRepoType() {
        KenaiServiceItem kenaiServiceItem = (KenaiServiceItem)this.repoComboBox.getSelectedItem();
        if (kenaiServiceItem != null && kenaiServiceItem.getService() != null) {
            return kenaiServiceItem.getService().getName();
        }
        return "none";
    }

    private void setRepoName(String string) {
        this.repoNameTextField.setText(string);
    }

    private String getRepoName() {
        return this.repoNameTextField.getText();
    }

    private void setRepoUrl(String string) {
        this.repoUrlTextField.setText(string);
    }

    private String getRepoUrl() {
        return this.repoUrlTextField.getText();
    }

    private void setRepoLocal(String string) {
        this.localFolderTextField.setText(string);
    }

    private String getRepoLocal() {
        return this.localFolderTextField.getText();
    }

    private void setIssuesType(String string) {
    }

    private String getIssuesType() {
        KenaiServiceItem kenaiServiceItem = (KenaiServiceItem)this.issuesComboBox.getSelectedItem();
        if (kenaiServiceItem != null && kenaiServiceItem.getService() != null) {
            return kenaiServiceItem.getService().getName();
        }
        return "none";
    }

    private void setIssuesUrl(String string) {
        this.issuesUrlTextField.setText(string);
    }

    private String getIssuesUrl() {
        return this.issuesUrlTextField.getText();
    }

    private void showRepoOnKenaiGUI() {
        this._setRepoOnKenaiGUIVisible(true);
        this.hideExtRepoGUI();
        this.hideNoRepoGUI();
        int n = this.repoNameTextField.getPreferredSize().height + 8;
        int n2 = this.repoNamePreviewLabel.getPreferredSize().height + 16;
        int n3 = this.localFolderTextField.getPreferredSize().height;
        int n4 = 110 - (n + n2 + n3) - 1;
        this.repoSpacerPanel.setPreferredSize(new Dimension(10, n4));
        this.revalidate();
        this.repaint();
    }

    private void hideRepoOnKenaiGUI() {
        this._setRepoOnKenaiGUIVisible(false);
    }

    private void _setRepoOnKenaiGUIVisible(boolean bl) {
        this.repoNameLabel.setVisible(bl);
        this.repoNameTextField.setVisible(bl);
        this.repoNamePreviewLabel.setVisible(bl);
        this.localRepoFolderLabel.setVisible(bl);
        this.localFolderTextField.setVisible(bl);
        this.localFolderBrowseButton.setVisible(bl);
    }

    private void showExtRepoGUI() {
        this.hideRepoOnKenaiGUI();
        this._setExtRepoGUIVisible(true);
        this.hideNoRepoGUI();
        int n = this.repoUrlTextField.getPreferredSize().height + 8;
        int n2 = 110 - n;
        this.repoSpacerPanel.setPreferredSize(new Dimension(10, n2));
        this.revalidate();
        this.repaint();
    }

    private void hideExtRepoGUI() {
        this._setExtRepoGUIVisible(false);
    }

    private void _setExtRepoGUIVisible(boolean bl) {
        this.repoUrlLabel.setVisible(bl);
        this.repoUrlTextField.setVisible(bl);
    }

    private void showNoRepoGUI() {
        this.hideRepoOnKenaiGUI();
        this.hideExtRepoGUI();
        this._setNoRepoGUIVisible(true);
        int n = this.noneRepoDescLabel.getPreferredSize().height;
        int n2 = 110 - n;
        this.repoSpacerPanel.setPreferredSize(new Dimension(10, n2));
        this.revalidate();
        this.repaint();
    }

    private void hideNoRepoGUI() {
        this._setNoRepoGUIVisible(false);
    }

    private void _setNoRepoGUIVisible(boolean bl) {
        this.noneRepoDescLabel.setVisible(bl);
    }

    private void showIssuesOnKenaiGUI() {
        this.hideExtIssuesGUI();
        this.hideNoIssuesGUI();
        this.issuesSpacerPanel.setPreferredSize(new Dimension(10, 110));
        this.revalidate();
        this.repaint();
    }

    private void hideIssuesOnKenaiGUI() {
    }

    private void _setIssuesOnKenaiGUIVisible(boolean bl) {
    }

    private void showExtIssuesGUI() {
        this._setExtIssuesGUIVisible(true);
        this.hideNoIssuesGUI();
        int n = this.issuesUrlTextField.getPreferredSize().height + 8;
        int n2 = 110 - n;
        this.issuesSpacerPanel.setPreferredSize(new Dimension(10, n2));
        this.revalidate();
        this.repaint();
    }

    private void hideExtIssuesGUI() {
        this._setExtIssuesGUIVisible(false);
    }

    private void _setExtIssuesGUIVisible(boolean bl) {
        this.issueTrackingUrlLabel.setVisible(bl);
        this.issuesUrlTextField.setVisible(bl);
    }

    private void showNoIssuesGUI() {
        this.hideExtIssuesGUI();
        this._setNoIssuesGUIVisible(true);
        int n = this.noIssueTrackingDescLabel.getPreferredSize().height;
        int n2 = 110 - n;
        this.issuesSpacerPanel.setPreferredSize(new Dimension(10, n2));
        this.revalidate();
        this.repaint();
    }

    private void hideNoIssuesGUI() {
        this._setNoIssuesGUIVisible(false);
    }

    private void _setNoIssuesGUIVisible(boolean bl) {
        this.noIssueTrackingDescLabel.setVisible(bl);
    }

    private static class KenaiServiceItem {
        private KenaiService kenaiService;
        private String displayName;

        public KenaiServiceItem(KenaiService kenaiService, String string) {
            this.kenaiService = kenaiService;
            this.displayName = string;
        }

        public KenaiService getService() {
            return this.kenaiService;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

