/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.OpenKenaiProjectAction;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.RemoveProjectAction;
import org.netbeans.modules.kenai.ui.URLDisplayerAction;
import org.netbeans.modules.kenai.ui.spi.LoginHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.mercurial.api.Mercurial;
import org.netbeans.modules.subversion.api.Subversion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAccessorImpl
extends ProjectAccessor {
    private Kenai kenai = Kenai.getDefault();

    @Override
    public List<ProjectHandle> getMemberProjects(LoginHandle loginHandle, boolean bl) {
        try {
            LinkedList<ProjectHandle> linkedList = new LinkedList<ProjectHandle>();
            for (KenaiProject kenaiProject : this.kenai.getMyProjects(bl)) {
                linkedList.add(new ProjectHandleImpl(kenaiProject));
                for (KenaiFeature kenaiFeature : kenaiProject.getFeatures(KenaiService.Type.SOURCE)) {
                    if ("subversion".equals(kenaiFeature.getService())) {
                        try {
                            Subversion.addRecentUrl((String)kenaiFeature.getLocation());
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                        continue;
                    }
                    if (!"mercurial".equals(kenaiFeature.getService())) continue;
                    try {
                        Mercurial.addRecentUrl((String)kenaiFeature.getLocation());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            }
            return linkedList;
        }
        catch (KenaiException kenaiException) {
            Logger.getLogger(ProjectAccessorImpl.class.getName()).log(Level.INFO, "getMyProject() failed", kenaiException);
            return null;
        }
    }

    @Override
    public ProjectHandle getNonMemberProject(String string, boolean bl) {
        try {
            return new ProjectHandleImpl(this.kenai.getProject(string, bl));
        }
        catch (KenaiException kenaiException) {
            Logger.getLogger(ProjectAccessorImpl.class.getName()).log(Level.INFO, "getProject() " + string + " failed", kenaiException);
            return null;
        }
    }

    @Override
    public ActionListener getOpenNonMemberProjectAction() {
        return new OpenKenaiProjectAction();
    }

    @Override
    public ActionListener getDetailsAction(ProjectHandle projectHandle) {
        return new URLDisplayerAction(NbBundle.getMessage(ProjectAccessorImpl.class, (String)"CTL_EditProject"), ((ProjectHandleImpl)projectHandle).getKenaiProject().getWebLocation());
    }

    @Override
    public ActionListener getDefaultAction(ProjectHandle projectHandle) {
        return this.getDetailsAction(projectHandle);
    }

    @Override
    public Action[] getPopupActions(final ProjectHandle projectHandle) {
        Action[] actionArray = new Action[]{(Action)this.getDetailsAction(projectHandle), new RemoveProjectAction(projectHandle), new AbstractAction(NbBundle.getMessage(ProjectAccessorImpl.class, (String)"CTL_RefreshProject")){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            Kenai.getDefault().getProject(projectHandle.getId(), true);
                            projectHandle.firePropertyChange("content", null, projectHandle);
                        }
                        catch (KenaiException kenaiException) {
                            Exceptions.printStackTrace((Throwable)kenaiException);
                        }
                    }
                });
            }
        }};
        return actionArray;
    }

    @Override
    public ActionListener getOpenWikiAction(ProjectHandle projectHandle) {
        try {
            KenaiFeature[] kenaiFeatureArray = ((ProjectHandleImpl)projectHandle).getKenaiProject().getFeatures(KenaiService.Type.WIKI);
            if (kenaiFeatureArray.length == 1) {
                return new URLDisplayerAction(kenaiFeatureArray[0].getDisplayName(), kenaiFeatureArray[0].getWebLocation());
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        return null;
    }

    @Override
    public ActionListener getOpenDownloadsAction(ProjectHandle projectHandle) {
        try {
            KenaiFeature[] kenaiFeatureArray = ((ProjectHandleImpl)projectHandle).getKenaiProject().getFeatures(KenaiService.Type.DOWNLOADS);
            if (kenaiFeatureArray.length == 1) {
                return new URLDisplayerAction(kenaiFeatureArray[0].getDisplayName(), kenaiFeatureArray[0].getWebLocation());
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        return null;
    }
}

