/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.logging.Logger;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class KenaiTopComponent
extends TopComponent {
    private static KenaiTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/kenai/ui/resources/kenai-small.png";
    private static final String PREFERRED_ID = "KenaiTopComponent";

    private KenaiTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(KenaiTopComponent.class, (String)"CTL_KenaiTopComponent"));
        this.setToolTipText(NbBundle.getMessage(KenaiTopComponent.class, (String)"HINT_KenaiTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.setLayout(new BorderLayout());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized KenaiTopComponent getDefault() {
        if (instance == null) {
            instance = new KenaiTopComponent();
        }
        return instance;
    }

    public static synchronized KenaiTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(KenaiTopComponent.class.getName()).warning("Cannot find KenaiTopComponent component. It will not be located properly in the window system.");
            return KenaiTopComponent.getDefault();
        }
        if (topComponent instanceof KenaiTopComponent) {
            return (KenaiTopComponent)topComponent;
        }
        Logger.getLogger(KenaiTopComponent.class.getName()).warning("There seem to be multiple components with the 'KenaiTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return KenaiTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.removeAll();
        this.add(DashboardImpl.getInstance().getComponent(), "Center");
    }

    public void componentClosed() {
        DashboardImpl.getInstance().close();
        this.removeAll();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return KenaiTopComponent.getDefault();
        }
    }
}

