/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelectorBuilder;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.FileToRepoMappingStorage;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BugtrackingOwnerSupport {
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.bridge.BugtrackingOwnerSupport");
    private Map<File, Repository> fileToRepo = new HashMap<File, Repository>(10);
    private static BugtrackingOwnerSupport instance;

    private BugtrackingOwnerSupport() {
    }

    public static BugtrackingOwnerSupport getInstance() {
        if (instance == null) {
            instance = new BugtrackingOwnerSupport();
        }
        return instance;
    }

    public Repository getRepository(ContextType contextType) {
        switch (contextType) {
            case MAIN_PROJECT_ONLY: {
                Project project = OpenProjects.getDefault().getMainProject();
                if (project == null) break;
                return this.getRepository(project, false);
            }
            case MAIN_OR_SINGLE_PROJECT: {
                Project project = BugtrackingOwnerSupport.getMainOrSingleProject();
                if (project == null) break;
                return this.getRepository(project, false);
            }
            case ALL_PROJECTS: {
                return this.getRepository(OpenProjects.getDefault().getOpenProjects());
            }
            case SELECTED_FILE_AND_ALL_PROJECTS: {
                File file = BugtrackingUtil.getLargerContext();
                if (file == null) break;
                return this.getRepositoryForContext(file, false);
            }
            default: {
                assert (false);
                break;
            }
        }
        return null;
    }

    public static Project getMainOrSingleProject() {
        OpenProjects openProjects = OpenProjects.getDefault();
        Project[] projectArray = openProjects.getOpenProjects();
        if (projectArray.length == 1) {
            return projectArray[0];
        }
        return openProjects.getMainProject();
    }

    public Repository getRepository(Project[] projectArray) {
        if (projectArray.length == 0) {
            return null;
        }
        if (projectArray.length == 1) {
            return this.getRepository(projectArray[0], false);
        }
        Repository repository = null;
        for (Project project : projectArray) {
            Repository repository2 = this.getRepository(project, false);
            if (repository2 == null) continue;
            if (repository == null) {
                repository = repository2;
                continue;
            }
            if (repository2 != repository) break;
        }
        return repository;
    }

    public Repository getRepository(Project project, boolean bl) {
        FileObject fileObject = project.getProjectDirectory();
        try {
            Repository repository = BugtrackingOwnerSupport.getKenaiBugtrackingRepository(fileObject);
            if (repository != null) {
                return repository;
            }
        }
        catch (KenaiException kenaiException) {
            return null;
        }
        File file = BugtrackingUtil.getLargerContext(project);
        return this.getRepositoryForContext(file, null, bl);
    }

    public Repository getRepository(File file, boolean bl) {
        return this.getRepository(file, null, bl);
    }

    public Repository getRepository(File file, String string, boolean bl) {
        Repository repository = this.fileToRepo.get(file);
        if (repository != null) {
            LOG.log(Level.FINER, " found cached repository [{0}] for file {1}", new Object[]{repository, file});
            return repository;
        }
        LOG.log(Level.FINER, " no repository cached for file {1}", new Object[]{file});
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            LOG.log(Level.WARNING, " did not find a FileObject for file {0}", new Object[]{file});
            return null;
        }
        try {
            repository = BugtrackingOwnerSupport.getKenaiBugtrackingRepository(fileObject);
            if (repository != null) {
                return repository;
            }
        }
        catch (KenaiException kenaiException) {
            return null;
        }
        File file2 = BugtrackingUtil.getLargerContext(file, fileObject);
        if (file2 == null) {
            return null;
        }
        return this.getRepositoryForContext(file2, string, bl);
    }

    private Repository getRepositoryForContext(File file, boolean bl) {
        return this.getRepositoryForContext(file, null, bl);
    }

    private Repository getRepositoryForContext(File file, String string, boolean bl) {
        Repository repository = this.fileToRepo.get(file);
        if (repository != null) {
            LOG.log(Level.FINER, " found cached repository [" + repository + "] for directory " + file);
            return repository;
        }
        repository = FileToRepoMappingStorage.getInstance().getFirmlyAssociatedRepository(file);
        if (repository != null) {
            LOG.log(Level.FINER, " found stored repository [" + repository + "] for directory " + file);
            this.fileToRepo.put(file, repository);
            return repository;
        }
        Repository repository2 = FileToRepoMappingStorage.getInstance().getLooselyAssociatedRepository(file);
        if (!bl) {
            return repository2;
        }
        repository = this.askUserToSpecifyRepository(string, repository2);
        if (repository != null) {
            return repository;
        }
        return null;
    }

    private static Repository getKenaiBugtrackingRepository(FileObject fileObject) throws KenaiException {
        Object object = fileObject.getAttribute("ProvidedExtensions.RemoteLocation");
        if (object instanceof String) {
            try {
                Repository repository = BugtrackingOwnerSupport.getKenaiBugtrackingRepository((String)object);
                if (repository != null) {
                    return repository;
                }
            }
            catch (KenaiException kenaiException) {
                if ("Not Found".equals(kenaiException.getMessage())) {
                    LOG.log(Level.INFO, "Kenai project corresponding to URL " + object + " does not exist.");
                } else {
                    LOG.throwing(BugtrackingOwnerSupport.class.getName(), "getKenaiBugtrackingRepository(String)", kenaiException);
                }
                throw kenaiException;
            }
        }
        return null;
    }

    private static Repository getKenaiBugtrackingRepository(String string) throws KenaiException {
        KenaiProject kenaiProject = KenaiProject.forRepository((String)string);
        return kenaiProject != null ? BugtrackingUtil.getKenaiBugtrackingRepository(kenaiProject) : null;
    }

    public void setLooseAssociation(ContextType contextType, Repository repository) {
        OpenProjects openProjects = OpenProjects.getDefault();
        File file = null;
        switch (contextType) {
            case MAIN_PROJECT_ONLY: {
                Project project = openProjects.getMainProject();
                if (project == null) break;
                file = BugtrackingUtil.getLargerContext(project);
                break;
            }
            case MAIN_OR_SINGLE_PROJECT: {
                Project project = BugtrackingOwnerSupport.getMainOrSingleProject();
                if (project == null) break;
                file = BugtrackingUtil.getLargerContext(project);
                break;
            }
            case ALL_PROJECTS: {
                file = BugtrackingUtil.getContextFromProjects();
                break;
            }
            case SELECTED_FILE_AND_ALL_PROJECTS: {
                file = BugtrackingUtil.getLargerContext();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (file != null) {
            FileToRepoMappingStorage.getInstance().setLooseAssociation(file, repository);
        }
    }

    public void setLooseAssociation(File file, Repository repository) {
        FileToRepoMappingStorage.getInstance().setLooseAssociation(BugtrackingUtil.getLargerContext(file), repository);
    }

    public void setFirmAssociations(File[] fileArray, Repository repository) {
        if (fileArray == null) {
            throw new IllegalArgumentException("files is null");
        }
        if (fileArray.length == 0) {
            return;
        }
        this.fileToRepo.clear();
        for (int i = 0; i < fileArray.length; ++i) {
            this.fileToRepo.put(fileArray[i], repository);
        }
        FileToRepoMappingStorage.getInstance().setFirmAssociation(BugtrackingUtil.getLargerContext(fileArray[0]), repository);
    }

    public void setFirmAssociation(File file, Repository repository) {
        this.fileToRepo.clear();
        this.fileToRepo.put(file, repository);
        FileToRepoMappingStorage.getInstance().setFirmAssociation(BugtrackingUtil.getLargerContext(file), repository);
    }

    private Repository askUserToSpecifyRepository(String string, Repository repository) {
        Repository[] repositoryArray = BugtrackingUtil.getKnownRepositories();
        BugtrackingConnector[] bugtrackingConnectorArray = BugtrackingUtil.getBugtrackingConnectors();
        RepositorySelectorBuilder repositorySelectorBuilder = new RepositorySelectorBuilder();
        repositorySelectorBuilder.setDisplayFormForExistingRepositories(true);
        repositorySelectorBuilder.setExistingRepositories(repositoryArray);
        repositorySelectorBuilder.setBugtrackingConnectors(bugtrackingConnectorArray);
        repositorySelectorBuilder.setPreselectedRepository(repository);
        repositorySelectorBuilder.setLabelAboveComboBox();
        String string2 = this.getMessage("LBL_BugtrackerSelectorTitle");
        DialogDescriptor dialogDescriptor = repositorySelectorBuilder.createDialogDescriptor(string2);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == NotifyDescriptor.OK_OPTION) {
            Repository repository2 = repositorySelectorBuilder.getSelectedRepository();
            try {
                repository2.getController().applyChanges();
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, null, iOException);
                repository2 = null;
            }
            return repository2;
        }
        return null;
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(BugtrackingOwnerSupport.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextType {
        MAIN_PROJECT_ONLY,
        MAIN_OR_SINGLE_PROJECT,
        ALL_PROJECTS,
        SELECTED_FILE_AND_ALL_PROJECTS;

    }
}

