/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchPopup;

class SearchResultRender
extends JLabel
implements ListCellRenderer {
    private QuickSearchPopup popup;
    private QuickSearchComboBar combo;
    private JPanel rendererComponent;
    private JPanel dividerLine;
    private JLabel resultLabel;
    private JPanel itemPanel;

    public SearchResultRender(QuickSearchComboBar quickSearchComboBar, QuickSearchPopup quickSearchPopup) {
        this.popup = quickSearchPopup;
        this.combo = quickSearchComboBar;
        this.configRenderer();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (!(object instanceof PopupItem)) {
            BugtrackingManager.LOG.warning("wrong search list item " + object);
            return null;
        }
        PopupItem popupItem = (PopupItem)object;
        String string = popupItem instanceof PopupItem.IssueItem ? ((PopupItem.IssueItem)popupItem).highlite(this.combo.getCommand().getText(), popupItem.getDisplayText()) : popupItem.getDisplayText();
        this.resultLabel.setText(string);
        this.itemPanel.setPreferredSize(new Dimension(this.popup.getResultWidth(), this.itemPanel.getPreferredSize().height));
        if (bl) {
            this.resultLabel.setBackground(jList.getSelectionBackground());
            this.resultLabel.setForeground(jList.getSelectionForeground());
        } else {
            this.resultLabel.setBackground(QuickSearchComboBar.getResultBackground());
            this.resultLabel.setForeground(jList.getForeground());
        }
        if (n == jList.getModel().getSize() - 1) {
            this.rendererComponent.add((Component)this.dividerLine, "North");
        } else {
            this.rendererComponent.remove(this.dividerLine);
        }
        return this.rendererComponent;
    }

    private void configRenderer() {
        this.resultLabel = new JLabel();
        this.resultLabel.setOpaque(true);
        this.resultLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.itemPanel = new JPanel();
        this.itemPanel.setBackground(QuickSearchComboBar.getResultBackground());
        this.itemPanel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 3));
        this.itemPanel.setLayout(new BorderLayout());
        this.itemPanel.add((Component)this.resultLabel, "Center");
        this.rendererComponent = new JPanel();
        this.rendererComponent.setLayout(new BorderLayout());
        this.rendererComponent.add((Component)this.itemPanel, "Center");
        this.dividerLine = new JPanel();
        this.dividerLine.setBackground(QuickSearchComboBar.getPopupBorderColor());
        this.dividerLine.setPreferredSize(new Dimension(this.dividerLine.getPreferredSize().width, 1));
    }
}

