/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issuetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.IssueNode;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.QueryNotifyListener;
import org.netbeans.modules.bugtracking.ui.issuetable.NodeTableModel;
import org.netbeans.modules.bugtracking.ui.issuetable.TableSorter;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class IssueTable
implements MouseListener,
AncestorListener,
KeyListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private TableSorter sorter;
    private int seenColumnIdx = -1;
    private int recentChangesColumnIdx = -1;
    private Query query;
    private Query.Filter filter;
    private static final MessageFormat issueNewFormat = IssueTable.getFormat("issueNewFormat");
    private static final MessageFormat issueObsoleteFormat = IssueTable.getFormat("issueObsoleteFormat");
    private static final MessageFormat issueModifiedFormat = IssueTable.getFormat("issueModifiedFormat");
    private static final Color unevenLineColor = new Color(15988477);
    private static final Color newHighlightColor = new Color(46080);
    private static final Color modifiedHighlightColor = new Color(255);
    private static final Color obsoleteHighlightColor = new Color(0x999999);
    private static final Color defaultForegroundColor = new JLabel().getForeground();
    private static Icon seenHeaderIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/seen-header.png"));
    private static Icon seenValueIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/seen-value.png"));
    private Set<Issue> issues = new HashSet<Issue>();
    private static final Comparator<IssueNode.IssueProperty> NodeComparator = new Comparator<IssueNode.IssueProperty>(){

        @Override
        public int compare(IssueNode.IssueProperty issueProperty, IssueNode.IssueProperty issueProperty2) {
            Integer n = (Integer)issueProperty.getValue("sortkey");
            if (n != null) {
                Integer n2 = (Integer)issueProperty2.getValue("sortkey");
                return n.compareTo(n2);
            }
            try {
                return issueProperty.compareTo(issueProperty2);
            }
            catch (Exception exception) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, exception);
                return 0;
            }
        }
    };

    public IssueTable(Query query) {
        this.query = query;
        query.addNotifyListener(new NotifyListener());
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter(this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new JTable(this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color color = UIManager.getColor("scrollpane_border");
        if (color == null) {
            color = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
        this.table.addMouseListener(this);
        this.table.addKeyListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new CellRenderer());
        this.table.getTableHeader().setDefaultRenderer(new HeaderRenderer(this.table.getTableHeader().getDefaultRenderer()));
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IssueTable.class, (String)"ACSN_IssueTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssueTable.class, (String)"ACSD_IssueTable"));
        this.initColumns();
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        BugtrackingUtil.fixFocusTraversalKeys(this.table);
    }

    public void setFilter(Query.Filter filter) {
        this.filter = filter;
        ArrayList<IssueNode> arrayList = new ArrayList<IssueNode>(this.issues.size());
        for (Issue issue : this.issues) {
            if (filter != null && !filter.accept(issue)) continue;
            arrayList.add(issue.getNode());
        }
        this.setTableModel(arrayList.toArray(new IssueNode[arrayList.size()]));
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Query.ColumnDescriptor[] columnDescriptorArray = IssueTable.this.query.getColumnDescriptors();
                for (int i = 0; i < columnDescriptorArray.length; ++i) {
                    Query.ColumnDescriptor columnDescriptor = columnDescriptorArray[i];
                    int n = columnDescriptor.getWidth();
                    if (n <= 0) continue;
                    IssueTable.this.table.getColumnModel().getColumn(i).setMinWidth(10);
                    IssueTable.this.table.getColumnModel().getColumn(i).setMaxWidth(10000);
                    IssueTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(n);
                }
                if (IssueTable.this.query.isSaved()) {
                    IssueTable.this.table.getColumnModel().getColumn(IssueTable.this.recentChangesColumnIdx).setMaxWidth(10000);
                    IssueTable.this.table.getColumnModel().getColumn(IssueTable.this.recentChangesColumnIdx).setMinWidth(10);
                    IssueTable.this.table.getColumnModel().getColumn(IssueTable.this.recentChangesColumnIdx).setPreferredWidth(BugtrackingUtil.getColumnWidthInPixels(25, (JComponent)IssueTable.this.table));
                    IssueTable.this.table.getColumnModel().getColumn(IssueTable.this.seenColumnIdx).setMaxWidth(28);
                    IssueTable.this.table.getColumnModel().getColumn(IssueTable.this.seenColumnIdx).setPreferredWidth(28);
                }
            }
        });
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.setDefaultColumnSizes();
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    public JComponent getComponent() {
        return this.component;
    }

    public final void initColumns() {
        this.setModelProperties(this.query);
        Query.ColumnDescriptor[] columnDescriptorArray = this.query.getColumnDescriptors();
        for (int i = 0; i < columnDescriptorArray.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
        }
        this.setDefaultColumnSizes();
    }

    private void setModelProperties(Query query) {
        int n;
        Query.ColumnDescriptor[] columnDescriptorArray = query.getColumnDescriptors();
        ArrayList<Query.ColumnDescriptor> arrayList = new ArrayList<Query.ColumnDescriptor>(columnDescriptorArray.length + (query.isSaved() ? 2 : 0));
        for (n = 0; n < columnDescriptorArray.length; ++n) {
            Query.ColumnDescriptor columnDescriptor = columnDescriptorArray[n];
            arrayList.add(columnDescriptor);
        }
        if (query.isSaved()) {
            arrayList.add(new RecentChangesDescriptor());
            arrayList.add(new SeenDescriptor());
            this.recentChangesColumnIdx = n;
            this.seenColumnIdx = n + 1;
        }
        this.tableModel.setProperties(arrayList.toArray(new Node.Property[arrayList.size()]));
    }

    private void setTableModel(IssueNode[] issueNodeArray) {
        this.tableModel.setNodes((Node[])issueNodeArray);
    }

    void focus() {
        this.table.requestFocus();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            int n = this.table.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            n = this.sorter.modelIndex(n);
            if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                Action action = this.tableModel.getNodes()[n].getPreferredAction();
                if (action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                }
            } else {
                int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
                if (n2 != this.seenColumnIdx) {
                    return;
                }
                IssueNode issueNode = (IssueNode)this.tableModel.getNodes()[n];
                final Issue issue = (Issue)issueNode.getLookup().lookup(Issue.class);
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    public void run() {
                        try {
                            issue.setSeen(!issue.wasSeen());
                        }
                        catch (IOException iOException) {
                            BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
                        }
                    }
                });
            }
        }
    }

    private static MessageFormat getFormat(String string) {
        String string2 = NbBundle.getMessage(IssueTable.class, (String)string);
        return new MessageFormat(string2);
    }

    public void keyTyped(KeyEvent keyEvent) {
        Action action;
        int n;
        if (keyEvent.getKeyChar() == '\n' && (n = this.table.getSelectedRow()) != -1 && (action = this.tableModel.getNodes()[n].getPreferredAction()).isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (keyEvent.getKeyChar() == '\n' && (n = this.table.getSelectedRow()) != -1) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecentChangesDescriptor
    extends Query.ColumnDescriptor<String> {
        public RecentChangesDescriptor() {
            super(Issue.LABEL_RECENT_CHANGES, String.class, NbBundle.getBundle(Issue.class).getString("CTL_Issue_Recent"), NbBundle.getBundle(Issue.class).getString("CTL_Issue_Recent_Desc"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SeenDescriptor
    extends Query.ColumnDescriptor<Boolean> {
        public SeenDescriptor() {
            super(Issue.LABEL_NAME_SEEN, Boolean.class, "", NbBundle.getBundle(Issue.class).getString("CTL_Issue_Seen_Desc"));
        }
    }

    private class NotifyListener
    implements QueryNotifyListener {
        private NotifyListener() {
        }

        public void notifyData(Issue issue) {
            IssueTable.this.issues.add(issue);
            if (IssueTable.this.filter == null || IssueTable.this.filter.accept(issue)) {
                final IssueNode issueNode = issue.getNode();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IssueTable.this.tableModel.insertNode((Node)issueNode);
                    }
                });
            }
        }

        public void started() {
            IssueTable.this.issues.clear();
            IssueTable.this.setTableModel(new IssueNode[0]);
        }

        public void finished() {
        }
    }

    private class HeaderRenderer
    extends DefaultTableCellRenderer {
        private JLabel seenCell = new JLabel();
        private TableCellRenderer delegate;

        public HeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.delegate = tableCellRenderer;
            this.seenCell.setIcon(seenHeaderIcon);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (IssueTable.this.query.isSaved() && n2 == IssueTable.this.seenColumnIdx) {
                Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.seenCell.setFont(component.getFont());
                this.seenCell.setForeground(component.getForeground());
                this.seenCell.setBorder(((JComponent)component).getBorder());
                return this.seenCell;
            }
            return this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private JLabel seenCell = new JLabel();
        private static final int VISIBLE_START_CHARS = 0;

        private String computeFitText(String string) {
            String string2;
            if (string == null || string.length() <= 3) {
                return string;
            }
            int n = this.getSize().width;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = fontMetrics.stringWidth(string2 = "...");
            int n3 = n - n2 - 10;
            if (n3 <= 0) {
                return string;
            }
            for (int i = 0; i <= string.length() - 1; ++i) {
                String string3 = string.substring(0, i);
                int n4 = fontMetrics.stringWidth(string3);
                if (n4 < n3) continue;
                return string3.length() > 0 ? string3 + string2 : string;
            }
            return string;
        }

        public CellRenderer() {
            this.seenCell.setBackground(Color.RED);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            Object object3;
            MessageFormat messageFormat = null;
            Color color = null;
            Color color2 = null;
            Component component = null;
            String string = null;
            if (object instanceof IssueNode.SeenProperty) {
                object3 = (IssueNode.SeenProperty)object;
                this.seenCell.setIcon(((IssueNode.SeenProperty)object3).getValue() == false ? seenValueIcon : null);
                component = this.seenCell;
            }
            object3 = null;
            if (IssueTable.this.query.isSaved() && object instanceof IssueNode.IssueProperty) {
                object2 = (IssueNode.IssueProperty)object;
                try {
                    object3 = ((IssueNode.IssueProperty)object2).getIssue();
                    if (!IssueTable.this.query.contains((Issue)object3)) {
                        messageFormat = issueObsoleteFormat;
                        if (bl) {
                            color = obsoleteHighlightColor;
                            color2 = Color.WHITE;
                        } else {
                            color = n % 2 != 0 ? unevenLineColor : Color.WHITE;
                        }
                    } else {
                        int n3 = IssueTable.this.query.getIssueStatus((Issue)object3);
                        if (!((Issue)object3).wasSeen()) {
                            switch (n3) {
                                case 4: {
                                    messageFormat = issueNewFormat;
                                    color = newHighlightColor;
                                    color2 = Color.WHITE;
                                    break;
                                }
                                case 8: {
                                    messageFormat = issueModifiedFormat;
                                    color = modifiedHighlightColor;
                                    color2 = Color.WHITE;
                                }
                            }
                        }
                    }
                    Object object4 = object2.getValue();
                    if (object4 instanceof String) {
                        string = (String)object4;
                    }
                }
                catch (Exception exception) {
                    BugtrackingManager.LOG.log(Level.WARNING, null, exception);
                }
            }
            if (component == null) {
                component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (bl) {
                messageFormat = null;
            } else {
                color = n % 2 != 0 ? unevenLineColor : Color.WHITE;
                color2 = defaultForegroundColor;
            }
            if (component instanceof JComponent) {
                object2 = component;
                ((JComponent)object2).putClientProperty("format", messageFormat);
                ((JComponent)component).setToolTipText(string);
                if (color != null) {
                    ((JComponent)object2).setBackground(color);
                }
                if (color2 != null) {
                    ((JComponent)object2).setForeground(color2);
                }
            }
            return component;
        }

        protected void paintComponent(Graphics graphics) {
            MessageFormat messageFormat = (MessageFormat)this.getClientProperty("format");
            String string = this.computeFitText(this.getText());
            if (messageFormat != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html>");
                messageFormat.format(new Object[]{string}, stringBuffer, (FieldPosition)null);
                stringBuffer.append("</html>");
                string = stringBuffer.toString();
            }
            this.setText(string);
            super.paintComponent(graphics);
        }
    }
}

