/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.IssueNode;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Issue {
    private static final int SHORT_DISP_NAME_LENGTH = 15;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String ATTR_DATE_MODIFICATION = "date.modification";
    public static String LABEL_NAME_SEEN = "issue.seen";
    public static String LABEL_RECENT_CHANGES = "issue.recent_changes";
    public static final String EVENT_ISSUE_DATA_CHANGED = "issue.data_changed";
    public static final String EVENT_ISSUE_SEEN_CHANGED = "issue.seen_changed";
    public static final int ISSUE_STATUS_UNKNOWN = 0;
    public static final int ISSUE_STATUS_SEEN = 2;
    public static final int ISSUE_STATUS_NEW = 4;
    public static final int ISSUE_STATUS_MODIFIED = 8;
    public static final int ISSUE_STATUS_ALL = 14;
    public static final int ISSUE_STATUS_NOT_SEEN = 12;
    private Repository repository;

    public Issue(Repository repository) {
        this.repository = repository;
    }

    public abstract String getDisplayName();

    public String getShortenedDisplayName() {
        int n;
        String string = this.getDisplayName();
        int n2 = string.length();
        if (n2 <= (n = 15)) {
            return string;
        }
        String string2 = string.substring(0, n).trim();
        StringBuilder stringBuilder = new StringBuilder(n + 4);
        stringBuilder.append(string2);
        if (n2 > n + 1 && Character.isSpaceChar(string.charAt(n))) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("...");
        return stringBuilder.toString();
    }

    public abstract String getTooltip();

    public abstract boolean refresh();

    public abstract void addComment(String var1, boolean var2);

    public abstract void attachPatch(File var1, String var2);

    public abstract BugtrackingController getController();

    public static void open(final Repository repository, final String string) {
        final ProgressHandle[] progressHandleArray = new ProgressHandle[]{ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{string}))};
        progressHandleArray[0].start();
        final IssueTopComponent issueTopComponent = IssueTopComponent.find(string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                final Issue issue = issueTopComponent.getIssue();
                if (issue == null) {
                    issueTopComponent.initNoIssue();
                }
                issueTopComponent.open();
                issueTopComponent.requestActive();
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (issue != null) {
                                progressHandleArray[0].finish();
                                progressHandleArray[0] = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_REFRESING_ISSUE", (Object[])new Object[]{string}));
                                progressHandleArray[0].start();
                                issue.refresh();
                            } else {
                                final Issue issue2 = repository.getIssue(string);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        issueTopComponent.setIssue(issue2);
                                    }
                                });
                                try {
                                    issue2.setSeen(true);
                                }
                                catch (IOException iOException) {
                                    BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
                                }
                            }
                        }
                        finally {
                            progressHandleArray[0].finish();
                        }
                    }
                });
            }
        });
    }

    public final void open() {
        this.open(false);
    }

    public final void open(final boolean bl) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_OPENING_ISSUE", (Object[])new Object[]{this.getID()}));
        progressHandle.start();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent issueTopComponent = IssueTopComponent.find(Issue.this);
                issueTopComponent.open();
                issueTopComponent.requestActive();
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block6: {
                            if (!bl || Issue.this.refresh()) break block6;
                            progressHandle.finish();
                            return;
                        }
                        try {
                            try {
                                Issue.this.setSeen(true);
                            }
                            catch (IOException iOException) {
                                BugtrackingManager.LOG.log(Level.SEVERE, null, iOException);
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            progressHandle.finish();
                        }
                    }
                });
            }
        });
    }

    public abstract IssueNode getNode();

    public abstract String getID();

    public abstract String getSummary();

    public abstract String getRecentChanges();

    public boolean wasSeen() {
        return this.repository.getCache().wasSeen(this.getID());
    }

    public void setSeen(boolean bl) throws IOException {
        boolean bl2 = this.wasSeen();
        this.repository.getCache().setSeen(this.getID(), bl);
        this.fireSeenChanged(bl2, bl);
    }

    public abstract Map<String, String> getAttributes();

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    protected void fireDataChanged() {
        this.support.firePropertyChange(EVENT_ISSUE_DATA_CHANGED, null, null);
    }

    protected void fireSeenChanged(boolean bl, boolean bl2) {
        this.support.firePropertyChange(EVENT_ISSUE_SEEN_CHANGED, bl, bl2);
    }
}

