/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositories;
import org.netbeans.modules.bugtracking.kenai.MissingJiraSupportPanel;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeJiraSupport {
    private static final String JIRA_SUBSTRING = "kenai.com/jira/";
    private String projectUrl;
    private String createIssueUrl;
    private static Map<String, FakeJiraSupport> supportedProjects = new HashMap<String, FakeJiraSupport>();
    private static List<QueryHandle> queryHandles;

    private FakeJiraSupport(String string, String string2) {
        this.projectUrl = string;
        this.createIssueUrl = string2;
    }

    static synchronized FakeJiraSupport get(ProjectHandle projectHandle) {
        FakeJiraSupport fakeJiraSupport = supportedProjects.get(projectHandle.getId());
        if (fakeJiraSupport != null) {
            return fakeJiraSupport;
        }
        KenaiProject kenaiProject = KenaiRepositories.getKenaiProject(projectHandle);
        if (kenaiProject == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        try {
            KenaiFeature[] kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.ISSUES);
            string = null;
            string2 = null;
            KenaiFeature[] kenaiFeatureArray2 = kenaiFeatureArray;
            int n = kenaiFeatureArray2.length;
            int n2 = 0;
            if (n2 < n) {
                KenaiFeature kenaiFeature = kenaiFeatureArray2[n2];
                if (!"jira".equals(kenaiFeature.getService())) {
                    return null;
                }
                string = kenaiFeature.getLocation();
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
        if (string == null) {
            return null;
        }
        int n = string.indexOf(JIRA_SUBSTRING);
        if (n > -1) {
            string2 = string.substring(0, n + JIRA_SUBSTRING.length()) + "secure/CreateIssue!default.jspa?pname=" + kenaiProject.getName();
        }
        fakeJiraSupport = new FakeJiraSupport(string, string2);
        supportedProjects.put(projectHandle.getId(), fakeJiraSupport);
        return fakeJiraSupport;
    }

    ActionListener getCreateIssueListener() {
        return this.getJiraListener(this.createIssueUrl);
    }

    ActionListener getOpenProjectListener() {
        return this.getJiraListener(this.projectUrl);
    }

    private ActionListener getJiraListener(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            BugtrackingManager.LOG.log(Level.SEVERE, null, malformedURLException);
            return null;
        }
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    public void run() {
                        HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
                        if (uRLDisplayer != null) {
                            uRLDisplayer.showURL(uRL);
                        } else {
                            BugtrackingManager.LOG.warning("No URLDisplayer found.");
                        }
                    }
                });
            }
        };
    }

    List<QueryHandle> getQueries() {
        if (queryHandles == null) {
            queryHandles = this.createQueryHandles();
        }
        return queryHandles;
    }

    private List<QueryHandle> createQueryHandles() {
        ArrayList<QueryHandle> arrayList = new ArrayList<QueryHandle>(2);
        arrayList.add(new FakeJiraQueryHandle(NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_MyIssues")));
        arrayList.add(new FakeJiraQueryHandle(NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_AllIssues")));
        return arrayList;
    }

    static void notifyJiraSupport() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new MissingJiraSupportPanel(), NbBundle.getMessage(FakeJiraSupport.class, (String)"CTL_MissingJiraPlugin"), true, new Object[]{DialogDescriptor.YES_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.YES_OPTION, 0, new HelpCtx(FakeJiraSupport.class), null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.YES_OPTION) {
            try {
                ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                Class<?> clazz = classLoader.loadClass("org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction");
                CallableSystemAction callableSystemAction = (CallableSystemAction)CallableSystemAction.findObject(clazz, (boolean)true);
                callableSystemAction.putValue("InitialTab", (Object)"available");
                callableSystemAction.performAction();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    static class FakeJiraQueryResultHandle
    extends QueryResultHandle
    implements ActionListener {
        FakeJiraQueryResultHandle() {
        }

        public String getText() {
            return NbBundle.getMessage(FakeJiraSupport.class, (String)"LBL_QueryResultTotal", (Object[])new Object[]{0});
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FakeJiraSupport.notifyJiraSupport();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FakeJiraQueryHandle
    extends QueryHandle
    implements ActionListener {
        private final String displayName;
        private static List<QueryResultHandle> results;

        public FakeJiraQueryHandle(String string) {
            this.displayName = string;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FakeJiraSupport.notifyJiraSupport();
        }

        List<QueryResultHandle> getQueryResults() {
            if (results == null) {
                results = new ArrayList<QueryResultHandle>(1);
                results.add(new FakeJiraQueryResultHandle());
            }
            return results;
        }
    }
}

