/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.bugtracking.BugtrackingRuntime;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositories;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public final class BugtrackingManager
implements LookupListener {
    private static final BugtrackingManager instance = new BugtrackingManager();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    public static final String EVENT_REPOSITORIES_CHANGED = "bugtracking.repositories.changed";
    private boolean initialized;
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.bugracking.BugtrackingManager");
    private RequestProcessor rp = new RequestProcessor("Bugtracking manager", 1);
    private final Collection<BugtrackingConnector> connectors = new ArrayList<BugtrackingConnector>(2);
    private final Lookup.Result<BugtrackingConnector> connectorsLookup = Lookup.getDefault().lookup(new Lookup.Template(BugtrackingConnector.class));

    public static BugtrackingManager getInstance() {
        instance.init();
        return instance;
    }

    private BugtrackingManager() {
    }

    public Repository[] getKnownRepositories() {
        Repository[] repositoryArray = KenaiRepositories.getInstance().getRepositories();
        Repository[] repositoryArray2 = this.getRepositories();
        Repository[] repositoryArray3 = new Repository[repositoryArray.length + repositoryArray2.length];
        System.arraycopy(repositoryArray, 0, repositoryArray3, 0, repositoryArray.length);
        System.arraycopy(repositoryArray2, 0, repositoryArray3, repositoryArray.length, repositoryArray2.length);
        return repositoryArray3;
    }

    public Repository[] getRepositories() {
        BugtrackingConnector[] bugtrackingConnectorArray;
        ArrayList<Repository> arrayList = new ArrayList<Repository>(10);
        for (BugtrackingConnector bugtrackingConnector : bugtrackingConnectorArray = this.getConnectors()) {
            Repository[] repositoryArray = bugtrackingConnector.getRepositories();
            if (repositoryArray == null) continue;
            for (Repository repository : repositoryArray) {
                arrayList.add(repository);
            }
        }
        return arrayList.toArray(new Repository[arrayList.size()]);
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.connectorsLookup.addLookupListener((LookupListener)this);
        this.refreshConnectors();
        BugtrackingRuntime.getInstance().init();
        LOG.fine("Bugtracking manager initialized");
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BugtrackingConnector[] getConnectors() {
        Collection<BugtrackingConnector> collection = this.connectors;
        synchronized (collection) {
            return this.connectors.toArray(new BugtrackingConnector[this.connectors.size()]);
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refreshConnectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConnectors() {
        Collection collection = this.connectorsLookup.allInstances();
        if (LOG.isLoggable(Level.FINER)) {
            for (BugtrackingConnector bugtrackingConnector : collection) {
                LOG.finer("registered provider: " + bugtrackingConnector.getDisplayName());
            }
        }
        Collection<BugtrackingConnector> collection2 = this.connectors;
        synchronized (collection2) {
            this.connectors.clear();
            this.connectors.addAll(collection);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void fireRepositoriesChanged() {
        this.changeSupport.firePropertyChange(EVENT_REPOSITORIES_CHANGED, null, null);
    }
}

