/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen.resource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceCategoryDescriptor;
import org.netbeans.modules.vmd.api.screen.resource.ScreenResourceItemPresenter;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.resource.ResourceItemPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCategoryPanel
extends JPanel {
    private static final Color LABEL_COLOR = new Color(0x868686);
    private static final Color BORDER_COLOR = new Color(13355457);
    private static final Color GRADIENT_COLOR = new Color(0xD5D5D5);
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private JLabel label;

    public ResourceCategoryPanel(ScreenResourceCategoryDescriptor screenResourceCategoryDescriptor) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBackground(MainPanel.BACKGROUND_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.label = new JLabel(screenResourceCategoryDescriptor.getTitle(), 0){

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.getHeight(), GRADIENT_COLOR));
                graphics2D.fill(new Rectangle(this.getWidth(), this.getHeight()));
                super.paint(graphics);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 8;
                dimension.height += 8;
                return dimension;
            }
        };
        this.label.setBorder(null);
        this.label.setFont(this.getFont().deriveFont(1));
        this.label.setToolTipText(screenResourceCategoryDescriptor.getToolTip());
        this.label.setBackground(null);
        this.label.setForeground(LABEL_COLOR);
        this.label.setOpaque(false);
    }

    public void reload(ArrayList<ScreenResourceItemPresenter> arrayList) {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = EMPTY_INSETS;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.label, gridBagConstraints);
        for (ScreenResourceItemPresenter screenResourceItemPresenter : arrayList) {
            JPanel jPanel = new JPanel();
            Dimension dimension = new Dimension(0, 1);
            jPanel.setPreferredSize(dimension);
            jPanel.setBackground(BORDER_COLOR);
            this.add((Component)jPanel, gridBagConstraints);
            ResourceItemPanel resourceItemPanel = new ResourceItemPanel(screenResourceItemPresenter.getRelatedComponent());
            resourceItemPanel.reload();
            this.add((Component)resourceItemPanel, gridBagConstraints);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.clip(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 8.0f, 8.0f));
        super.paint(graphics);
        graphics2D.setClip(shape);
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(BORDER_COLOR);
        graphics2D.draw(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 8.0f, 8.0f));
    }
}

