/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.spi.indicator.TickerListener;
import org.netbeans.modules.dlight.util.DLightExecutorService;

final class IndicatorTickerService {
    private static final IndicatorTickerService instance = new IndicatorTickerService();
    private Future tickerService;
    private boolean started = false;
    private final Object lock = new Object();
    private final Object listenersLock = new Object();
    private final List<TickerListener> listeners = new ArrayList<TickerListener>();

    private IndicatorTickerService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IndicatorTickerService getInstance() {
        Object object = IndicatorTickerService.instance.lock;
        synchronized (object) {
            if (!IndicatorTickerService.instance.started) {
                instance.startIfNeed();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners() {
        TickerListener[] tickerListenerArray;
        Object object = this.listenersLock;
        synchronized (object) {
            tickerListenerArray = this.listeners.toArray(new TickerListener[0]);
            if (tickerListenerArray.length == 0) {
                return;
            }
        }
        object = new CountDownLatch(tickerListenerArray.length);
        for (final TickerListener tickerListener : tickerListenerArray) {
            DLightExecutorService.submit((Runnable)new Runnable((CountDownLatch)object){
                final /* synthetic */ CountDownLatch val$doneFlag;
                {
                    this.val$doneFlag = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        tickerListener.tick();
                    }
                    finally {
                        this.val$doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + tickerListener));
        }
        try {
            ((CountDownLatch)object).await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startIfNeed() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.tickerService = DLightExecutorService.scheduleAtFixedRate((Runnable)new Runnable(){

                    public void run() {
                        IndicatorTickerService.this.notifyListeners();
                    }
                }, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"IndicatorTickerService");
                this.started = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subsribe(TickerListener tickerListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listeners.contains(tickerListener)) {
                this.listeners.add(tickerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribe(TickerListener tickerListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(tickerListener);
            if (this.listeners.isEmpty()) {
                Object object2 = this.lock;
                synchronized (object2) {
                    if (this.started) {
                        this.tickerService.cancel(true);
                        this.started = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                this.tickerService.cancel(true);
            }
        }
    }
}

