/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.support.ValidateableSupport;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.impl.IndicatorRepairActionProviderAccessor;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndicatorRepairActionProvider
implements ValidationListener {
    private final DLightConfiguration configuration;
    private final DLightTool currentTool;
    private final DLightTarget targetToRepairFor;
    private ValidationStatus currentStatus;
    private final List<IndicatorDataProvider<?>> toReValidate;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final Object listenersLock = new String("IndicatorRepairActionProvider.Listeners");
    private Future<Boolean> repairTask;

    private IndicatorRepairActionProvider(DLightConfiguration dLightConfiguration, DLightTool dLightTool, DLightTarget dLightTarget) {
        this.configuration = dLightConfiguration;
        this.currentTool = dLightTool;
        this.targetToRepairFor = dLightTarget;
        this.currentStatus = ValidationStatus.initialStatus();
        List<IndicatorDataProvider<?>> list = dLightConfiguration.getConfigurationOptions(false).getIndicatorDataProviders(this.currentTool);
        this.toReValidate = new ArrayList();
        for (IndicatorDataProvider<?> indicatorDataProvider : list) {
            if (indicatorDataProvider.getValidationStatus().isKnown() && (!indicatorDataProvider.getValidationStatus().isKnown() || !indicatorDataProvider.getValidationStatus().isInvalid())) continue;
            indicatorDataProvider.addValidationListener(this);
            this.toReValidate.add(indicatorDataProvider);
            this.currentStatus = indicatorDataProvider.getValidationStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeListener(ChangeListener changeListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.changeListeners.contains(changeListener)) {
                this.changeListeners.add(changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChangeListener(ChangeListener changeListener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.changeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChangeListeners() {
        Object object = this.listenersLock;
        synchronized (object) {
            ChangeListener[] changeListenerArray;
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : changeListenerArray = this.changeListeners.toArray(new ChangeListener[0])) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public final String getMessage(ValidationStatus validationStatus) {
        if (validationStatus.isValid()) {
            String string = NbBundle.getMessage(IndicatorRepairActionProvider.class, (String)"NextRun");
            if (!this.configuration.getConfigurationOptions(false).areCollectorsTurnedOn()) {
                string = NbBundle.getMessage(IndicatorRepairActionProvider.class, (String)"DataCollectorDisabled");
            }
            return string;
        }
        return validationStatus.getReason();
    }

    public boolean isValid() {
        return this.currentStatus.isValid();
    }

    public boolean needRepair() {
        return !this.currentStatus.isKnown();
    }

    public String getReason() {
        return this.currentStatus.getReason();
    }

    public final ValidationStatus getValidationStatus() {
        return this.currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> asyncRepair() {
        IndicatorRepairActionProvider indicatorRepairActionProvider = this;
        synchronized (indicatorRepairActionProvider) {
            if (this.repairTask == null || this.repairTask.isDone()) {
                this.repairTask = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (IndicatorDataProvider indicatorDataProvider : IndicatorRepairActionProvider.this.toReValidate) {
                            ValidateableSupport<DLightTarget> validateableSupport = new ValidateableSupport<DLightTarget>(indicatorDataProvider);
                            final Future<ValidationStatus> future = validateableSupport.asyncValidate(IndicatorRepairActionProvider.this.targetToRepairFor, true);
                            Future future2 = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                                @Override
                                public Boolean call() throws Exception {
                                    final ValidationStatus validationStatus = (ValidationStatus)future.get();
                                    UIThread.invoke((Runnable)new Runnable(){

                                        public void run() {
                                            IndicatorRepairActionProvider.this.currentStatus = validationStatus;
                                        }
                                    });
                                    return validationStatus.isKnown();
                                }
                            }, (String)("IndicatorRepairActionProvider task for " + indicatorDataProvider.getName()));
                            try {
                                if (!((Boolean)future2.get()).booleanValue()) continue;
                                return true;
                            }
                            catch (InterruptedException interruptedException) {
                                Exceptions.printStackTrace((Throwable)interruptedException);
                            }
                            catch (ExecutionException executionException) {
                                Exceptions.printStackTrace((Throwable)executionException);
                            }
                        }
                        return true;
                    }
                }, (String)"IndicatorRepairActionProvider asyncRepair");
            }
        }
        return this.repairTask;
    }

    @Override
    public void validationStateChanged(Validateable validateable, ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus2.isKnown()) {
            validateable.removeValidationListener(this);
            this.currentStatus = validationStatus2;
            this.notifyChangeListeners();
        }
    }

    static {
        IndicatorRepairActionProviderAccessor.setDefault(new IndicatorRepairActionProviderAccessorImpl());
    }

    private static class IndicatorRepairActionProviderAccessorImpl
    extends IndicatorRepairActionProviderAccessor {
        private IndicatorRepairActionProviderAccessorImpl() {
        }

        public IndicatorRepairActionProvider createNew(DLightConfiguration dLightConfiguration, DLightTool dLightTool, DLightTarget dLightTarget) {
            return new IndicatorRepairActionProvider(dLightConfiguration, dLightTool, dLightTarget);
        }
    }
}

