/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.impl.IndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorActionListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorRepairActionProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorTickerService;
import org.netbeans.modules.dlight.spi.indicator.TickerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Indicator<T extends IndicatorConfiguration>
implements DLightTargetListener,
ChangeListener {
    private static final int PADDING = 2;
    private final Object lock = new Object();
    private final IndicatorMetadata metadata;
    private final int position;
    private String toolName;
    private final List<IndicatorActionListener> listeners = Collections.synchronizedList(new ArrayList());
    private final TickerListener tickerListener;
    private IndicatorRepairActionProvider indicatorRepairActionProvider = null;
    private List<VisualizerConfiguration> visualizerConfiguraitons;

    protected final void notifyListeners() {
        for (IndicatorActionListener indicatorActionListener : this.listeners) {
            indicatorActionListener.mouseClickedOnIndicator(this);
        }
    }

    protected Indicator(T t) {
        this.metadata = IndicatorConfigurationAccessor.getDefault().getIndicatorMetadata((IndicatorConfiguration)t);
        this.visualizerConfiguraitons = IndicatorConfigurationAccessor.getDefault().getVisualizerConfigurations((IndicatorConfiguration)t);
        this.position = IndicatorConfigurationAccessor.getDefault().getIndicatorPosition((IndicatorConfiguration)t);
        this.tickerListener = new TickerListener(){

            public void tick() {
                Indicator.this.tick();
            }
        };
    }

    public final Action getDefaultAction() {
        AbstractAction abstractAction = new AbstractAction(this.toolName){

            public void actionPerformed(ActionEvent actionEvent) {
                Indicator.this.notifyListeners();
            }
        };
        return abstractAction;
    }

    protected abstract void repairNeeded(boolean var1);

    private void setRepairActionProviderFor(IndicatorRepairActionProvider indicatorRepairActionProvider) {
        this.indicatorRepairActionProvider = indicatorRepairActionProvider;
        this.indicatorRepairActionProvider.addChangeListener(this);
        this.repairNeeded(true);
    }

    public final int getPosition() {
        return this.position;
    }

    protected final IndicatorRepairActionProvider getRepairActionProvider() {
        return this.indicatorRepairActionProvider;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        boolean bl;
        if (this.indicatorRepairActionProvider == null || changeEvent.getSource() != this.indicatorRepairActionProvider) {
            return;
        }
        boolean bl2 = bl = this.indicatorRepairActionProvider.needRepair() || !this.indicatorRepairActionProvider.getValidationStatus().isValid();
        if (!bl) {
            this.indicatorRepairActionProvider.removeChangeListener(this);
        }
        this.repairNeeded(bl);
    }

    @Override
    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                return;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetStarted(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            IndicatorTickerService.getInstance().subsribe(this.tickerListener);
        }
    }

    protected abstract void tick();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget dLightTarget) {
        Object object = this.lock;
        synchronized (object) {
            IndicatorTickerService.getInstance().unsubscribe(this.tickerListener);
        }
    }

    private void initMouseListener() {
        final JComponent jComponent = this.getComponent();
        if (jComponent == null) {
            return;
        }
        jComponent.setCursor(Cursor.getPredefinedCursor(12));
        jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jComponent.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (jComponent == null) {
                    return;
                }
                jComponent.setBorder(BorderFactory.createEtchedBorder());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (jComponent == null) {
                    return;
                }
                jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                jComponent.requestFocus();
                Indicator.this.notifyListeners();
            }
        });
        final Color color = jComponent.getBackground();
        final Color color2 = color == null ? (UIManager.getColor("Panel.background") == null ? color : UIManager.getColor("Panel.background").darker()) : color.darker();
        jComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (jComponent == null) {
                    return;
                }
                jComponent.setBorder(BorderFactory.createEtchedBorder());
                jComponent.setBackground(color2);
                JRootPane jRootPane = jComponent.getRootPane();
                if (jRootPane == null) {
                    return;
                }
                InputMap inputMap = jRootPane.getInputMap(1);
                inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
                ActionMap actionMap = jRootPane.getActionMap();
                actionMap.put("enter", new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Indicator.this.notifyListeners();
                    }
                });
            }

            public void focusLost(FocusEvent focusEvent) {
                if (jComponent == null) {
                    return;
                }
                jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                jComponent.setBackground(color);
            }
        });
    }

    void setToolName(String string) {
        this.toolName = string;
    }

    List<VisualizerConfiguration> getVisualizerConfigurations() {
        return this.visualizerConfiguraitons;
    }

    void addIndicatorActionListener(IndicatorActionListener indicatorActionListener) {
        if (!this.listeners.contains(indicatorActionListener)) {
            this.listeners.add(indicatorActionListener);
        }
    }

    void removeIndicatorActionListener(IndicatorActionListener indicatorActionListener) {
        this.listeners.remove(indicatorActionListener);
    }

    public abstract void updated(List<DataRow> var1);

    public abstract void reset();

    public IndicatorMetadata getMetadata() {
        return this.metadata;
    }

    protected List<DataTableMetadata.Column> getMetadataColumns() {
        return this.metadata.getColumns();
    }

    protected String getMetadataColumnName(int n) {
        if (n < 0 || n >= this.metadata.getColumnsCount()) {
            return null;
        }
        DataTableMetadata.Column column = this.metadata.getColumns().get(n);
        return column.getColumnName();
    }

    public abstract JComponent getComponent();

    static {
        IndicatorAccessor.setDefault(new IndicatorAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndicatorAccessorImpl
    extends IndicatorAccessor {
        private IndicatorAccessorImpl() {
        }

        @Override
        public void setToolName(Indicator<?> indicator, String string) {
            indicator.setToolName(string);
        }

        @Override
        public List<DataTableMetadata.Column> getMetadataColumns(Indicator<?> indicator) {
            return indicator.getMetadataColumns();
        }

        @Override
        public String getMetadataColumnName(Indicator<?> indicator, int n) {
            return indicator.getMetadataColumnName(n);
        }

        @Override
        public List<VisualizerConfiguration> getVisualizerConfigurations(Indicator<?> indicator) {
            return indicator.getVisualizerConfigurations();
        }

        @Override
        public void addIndicatorActionListener(Indicator<?> indicator, IndicatorActionListener indicatorActionListener) {
            indicator.addIndicatorActionListener(indicatorActionListener);
        }

        @Override
        public void removeIndicatorActionListener(Indicator<?> indicator, IndicatorActionListener indicatorActionListener) {
            indicator.removeIndicatorActionListener(indicatorActionListener);
        }

        @Override
        public String getToolName(Indicator<?> indicator) {
            return ((Indicator)indicator).toolName;
        }

        @Override
        public void initMouseListener(Indicator<?> indicator) {
            ((Indicator)indicator).initMouseListener();
        }

        @Override
        public void setRepairActionProviderFor(Indicator<?> indicator, IndicatorRepairActionProvider indicatorRepairActionProvider) {
            ((Indicator)indicator).setRepairActionProviderFor(indicatorRepairActionProvider);
        }
    }
}

