/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLDataStorage
extends DataStorage {
    public static final String SQL_DATA_STORAGE_TYPE = "db:sql";
    private LinkedBlockingQueue<Request> requestQueue;
    private final Object insertPreparedStatmentsLock = new Object();
    private final Map<String, PreparedStatement> insertPreparedStatments;
    private static final int WAIT_INTERVALS = 100;
    private static final int MAX_BULK_SIZE = 10000;
    private static final int BUFFER_COUNT = 6;
    private static final Logger logger = DLightLogger.getLogger(SQLDataStorage.class);
    protected Connection connection;
    protected HashMap<String, DataTableMetadata> tables = new HashMap();
    protected static final HashMap<Class, String> classToType = new HashMap();
    private boolean enabled = false;
    private AsyncThread asyncThread = null;
    private final Map<String, PreparedStatement> stmts;
    private final Map<String, String> serviceInfoMap = new ConcurrentHashMap<String, String>();

    protected SQLDataStorage() {
        this.stmts = new HashMap<String, PreparedStatement>();
        this.insertPreparedStatments = new HashMap<String, PreparedStatement>();
    }

    protected SQLDataStorage(String string) throws SQLException {
        this();
        this.connect(string);
        if (!this.enabled) {
            this.enable();
        }
    }

    @Override
    public boolean shutdown() {
        this.disable();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return true;
    }

    protected abstract String getSQLQueriesDelimeter();

    protected void finalize() throws Throwable {
        this.disable();
    }

    private synchronized void disable() {
        this.asyncThread.shutdown();
        this.enabled = false;
        this.asyncThread = null;
    }

    protected abstract void connect(String var1) throws SQLException;

    protected String classToType(Class clazz) {
        return classToType.get(clazz);
    }

    protected final boolean createTable(final DataTableMetadata dataTableMetadata) {
        if (this.tables.containsKey(dataTableMetadata.getName())) {
            return true;
        }
        String string = dataTableMetadata.getName();
        StringBuilder stringBuilder = new StringBuilder("create table " + string + "(");
        stringBuilder.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(dataTableMetadata.getColumns(), new Convertor<DataTableMetadata.Column>(){

            @Override
            public String toString(DataTableMetadata.Column column) {
                return column.getColumnName() + " " + SQLDataStorage.this.classToType(column.getColumnClass());
            }
        }));
        stringBuilder.append(")" + this.getSQLQueriesDelimeter());
        logger.fine("About to execute query: " + stringBuilder.toString());
        try {
            this.connection.prepareCall(stringBuilder.toString()).execute();
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
            return false;
        }
        logger.fine("Table " + string + " created");
        this.tables.put(string, dataTableMetadata);
        for (DataTableMetadata.Column column : dataTableMetadata.getIndexedColumns()) {
            try {
                this.connection.prepareStatement("create index " + string + "_" + column.getColumnName() + "_index on " + string + "(" + column.getColumnName() + ")").execute();
            }
            catch (SQLException sQLException) {
                logger.log(Level.SEVERE, null, sQLException);
            }
        }
        DLightExecutorService.submit((Runnable)new Runnable(){

            public void run() {
                SQLDataStorage.this.getPreparedInsertStatement(dataTableMetadata);
            }
        }, (String)("SQL: Prepare Insert Statement for " + dataTableMetadata.getName()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedInsertStatement(DataTableMetadata dataTableMetadata) {
        Object object = this.insertPreparedStatmentsLock;
        synchronized (object) {
            PreparedStatement preparedStatement = this.insertPreparedStatments.get(dataTableMetadata.getName());
            if (preparedStatement != null) {
                return preparedStatement;
            }
            String string = dataTableMetadata.getName();
            StringBuilder stringBuilder = new StringBuilder("insert into " + string + " (");
            stringBuilder.append(new EnumStringConstructor<String>().constructEnumString(dataTableMetadata.getColumnNames(), new Convertor<String>(){

                @Override
                public String toString(String string) {
                    return string;
                }
            }));
            stringBuilder.append(") values (");
            int n = dataTableMetadata.getColumnsCount();
            for (int i = 0; i < n - 1; ++i) {
                stringBuilder.append("?, ");
            }
            stringBuilder.append("? ) " + this.getSQLQueriesDelimeter());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SQL: dispatching " + stringBuilder.toString());
            }
            try {
                Map<String, PreparedStatement> map = this.insertPreparedStatments;
                synchronized (map) {
                    this.insertPreparedStatments.put(string, this.connection.prepareStatement(stringBuilder.toString()));
                }
            }
            catch (SQLException sQLException) {
                Exceptions.printStackTrace((Throwable)sQLException);
            }
            return preparedStatement;
        }
    }

    public ResultSet select(String string, List<DataTableMetadata.Column> list) {
        return this.select(string, list, null);
    }

    @Override
    public Collection<DataStorageType> getStorageTypes() {
        return Arrays.asList(DataStorageTypeFactory.getInstance().getDataStorageType(SQL_DATA_STORAGE_TYPE));
    }

    public ResultSet select(String string, List<DataTableMetadata.Column> list, String string2) {
        Object object;
        if (string2 == null) {
            object = new StringBuilder("select ");
            ((StringBuilder)object).append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(list, new Convertor<DataTableMetadata.Column>(){

                @Override
                public String toString(DataTableMetadata.Column column) {
                    return column.getExpression() == null ? column.getColumnName() : column.getExpression();
                }
            }));
            ((StringBuilder)object).append(" from ").append(string);
            string2 = ((StringBuilder)object).toString();
        }
        object = null;
        try {
            object = this.connection.prepareCall(string2).executeQuery();
        }
        catch (SQLException sQLException) {
            logger.log(Level.SEVERE, null, sQLException);
        }
        return object;
    }

    protected final Connection getConnection() {
        return this.connection;
    }

    public final void execute(BufferedReader bufferedReader) throws SQLException, IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        Statement statement = this.connection.createStatement();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("-- ")) continue;
            stringBuilder.append(string);
            if (!string.endsWith(";")) continue;
            String string2 = stringBuilder.toString();
            stringBuilder.setLength(0);
            String string3 = string2.substring(0, string2.length() - 1) + this.getSQLQueriesDelimeter();
            statement.execute(string3);
        }
        statement.close();
    }

    protected final void execute(String string) throws SQLException {
        this.requestQueue.add(new CustomRequest(this.connection.prepareStatement(string)));
    }

    protected void addInsertInQueue(PreparedStatement preparedStatement) {
        this.requestQueue.add(new CustomRequest(preparedStatement));
    }

    @Override
    public final void addData(String string, List<DataRow> list) {
        for (DataRow dataRow : list) {
            this.requestQueue.add(new DataRowInsertRequest(string, dataRow));
        }
    }

    private PreparedStatement createRowInsertStatement(String string, DataRow dataRow) {
        if (logger.isLoggable(Level.INFO)) {
            logger.fine("Will add to the queue with using prepared statement");
        }
        StringBuilder stringBuilder = new StringBuilder("insert into " + string + " (");
        stringBuilder.append(new EnumStringConstructor<String>().constructEnumString(dataRow.getColumnNames(), new Convertor<String>(){

            @Override
            public String toString(String string) {
                return string;
            }
        }));
        stringBuilder.append(") values (");
        stringBuilder.append(new EnumStringConstructor<Object>().constructEnumString(dataRow.getData(), new Convertor<Object>(){

            @Override
            public String toString(Object object) {
                return String.valueOf(object);
            }
        }));
        stringBuilder.append(")" + this.getSQLQueriesDelimeter());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("----------SQL: dispatching " + stringBuilder.toString());
        }
        try {
            return this.connection.prepareStatement(stringBuilder.toString());
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return null;
        }
    }

    private void enable() {
        if (!this.enabled) {
            this.requestQueue = new LinkedBlockingQueue();
            this.enabled = true;
            if (this.asyncThread == null) {
                this.asyncThread = new AsyncThread();
            }
            this.asyncThread.start();
        }
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SQL: prepare statement " + string);
        }
        if ((preparedStatement = this.stmts.get(string)) == null) {
            preparedStatement = string.startsWith("INSERT INTO ") ? this.connection.prepareStatement(string, 1) : this.connection.prepareStatement(string);
            this.stmts.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    @Override
    public final Map<String, String> getInfo() {
        return this.serviceInfoMap;
    }

    @Override
    public final String getValue(String string) {
        return this.serviceInfoMap.get(string);
    }

    @Override
    public final String put(String string, String string2) {
        return this.serviceInfoMap.put(string, string2);
    }

    static {
        classToType.put(Integer.class, "int");
        classToType.put(Double.class, "double");
        classToType.put(Float.class, "double");
        classToType.put(Long.class, "bigint");
        classToType.put(String.class, "varchar");
    }

    private class AsyncReadThread
    extends Thread {
        private boolean shutdown;
        private int emptyBufferCount;
        List<Request> requestList = new ArrayList<Request>();

        public AsyncReadThread() {
            this.setDaemon(true);
            this.setName("DLIGHT: SQL Storage AsyncFillModelThread");
        }

        public void run() {
            while (this.emptyBufferCount < 6) {
                for (int i = 0; i < 10000; ++i) {
                    try {
                        Request request = (Request)SQLDataStorage.this.requestQueue.poll(100L, TimeUnit.MILLISECONDS);
                        if (request == null) break;
                        this.requestList.add(request);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.requestList.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        for (Request request : this.requestList) {
                            request.execute();
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "SQLDataStorage_db_write_failed", exception);
                }
                this.requestList.clear();
            }
        }

        private void shutdown() {
            this.shutdown = true;
            while (this.emptyBufferCount < 6) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class AsyncThread
    extends Thread {
        private boolean shutdown;
        private int emptyBufferCount;
        List<Request> requestList = new ArrayList<Request>();

        public AsyncThread() {
            this.setDaemon(true);
            this.setName("DLIGHT: SQL Storage AsyncThread");
        }

        public void run() {
            while (this.emptyBufferCount < 6) {
                for (int i = 0; i < 10000; ++i) {
                    try {
                        Request request = (Request)SQLDataStorage.this.requestQueue.poll(100L, TimeUnit.MILLISECONDS);
                        if (request == null) break;
                        this.requestList.add(request);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.requestList.isEmpty()) {
                        if (this.shutdown) {
                            ++this.emptyBufferCount;
                        }
                    } else {
                        for (Request request : this.requestList) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("EXECUTEEEEEEEEEEEEEEE !!!SQL: dispatching request  " + request.toString());
                            }
                            request.execute();
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "SQLDataStorage.async_db_write_failed", exception);
                }
                this.requestList.clear();
            }
        }

        private void shutdown() {
            this.shutdown = true;
            while (this.emptyBufferCount < 6) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Convertor<T> {
        public String toString(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumStringConstructor<T> {
        private EnumStringConstructor() {
        }

        public String constructEnumString(Collection<? extends T> collection, Convertor<T> convertor) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                stringBuilder.append(convertor.toString(t));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }
    }

    private class DataRowInsertRequest
    extends BaseRequest {
        final String tableName;
        final DataRow dataRow;

        public DataRowInsertRequest(String string, DataRow dataRow) {
            this.tableName = string;
            this.dataRow = dataRow;
        }

        PreparedStatement getPreparedStatement() throws SQLException {
            DataTableMetadata dataTableMetadata = SQLDataStorage.this.tables.get(this.tableName);
            PreparedStatement preparedStatement = SQLDataStorage.this.getPreparedInsertStatement(dataTableMetadata);
            if (preparedStatement == null) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            List<DataTableMetadata.Column> list = dataTableMetadata.getColumns();
            List<String> list2 = this.dataRow.getColumnNames();
            if (list2.size() != list.size()) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                DataTableMetadata.Column column = list.get(i);
                preparedStatement.setObject(i + 1, this.dataRow.getData(column.getColumnName()));
            }
            return preparedStatement;
        }
    }

    private static class CustomRequest
    extends BaseRequest {
        PreparedStatement preparedStatement;

        public CustomRequest(PreparedStatement preparedStatement) {
            this.preparedStatement = preparedStatement;
        }

        PreparedStatement getPreparedStatement() throws SQLException {
            return this.preparedStatement;
        }
    }

    private static abstract class BaseRequest
    implements Request {
        private BaseRequest() {
        }

        abstract PreparedStatement getPreparedStatement() throws SQLException;

        public void execute() throws SQLException {
            PreparedStatement preparedStatement = this.getPreparedStatement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SQL: dispatching insert  " + preparedStatement.toString());
            }
            preparedStatement.execute();
        }
    }

    private static interface Request {
        public void execute() throws SQLException;
    }
}

