/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.impl.DLightToolConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightToolConfiguration {
    private final String toolName;
    private final String detailedToolName;
    private final List<DataCollectorConfiguration> dataCollectors;
    private final List<IndicatorDataProviderConfiguration> indicatorDataProvidersConfiguration;
    private final List<IndicatorConfiguration> indicators;
    private String iconPath = null;

    public DLightToolConfiguration(String string) {
        this(string, string);
    }

    public DLightToolConfiguration(String string, String string2) {
        this.toolName = string;
        this.detailedToolName = string2;
        this.dataCollectors = Collections.synchronizedList(new ArrayList());
        this.indicators = Collections.synchronizedList(new ArrayList());
        this.indicatorDataProvidersConfiguration = Collections.synchronizedList(new ArrayList());
    }

    public void addDataCollectorConfiguration(DataCollectorConfiguration dataCollectorConfiguration) {
        this.dataCollectors.add(dataCollectorConfiguration);
    }

    public void setIcon(String string) {
        this.iconPath = string;
    }

    public void addIndicatorConfiguration(IndicatorConfiguration indicatorConfiguration) {
        this.indicators.add(indicatorConfiguration);
    }

    public void addIndicatorDataProviderConfiguration(IndicatorDataProviderConfiguration indicatorDataProviderConfiguration) {
        if (indicatorDataProviderConfiguration == null) {
            throw new NullPointerException("An attempt to add NULL IndicatorDataProviderConfiguration");
        }
        this.indicatorDataProvidersConfiguration.add(indicatorDataProviderConfiguration);
    }

    List<DataCollectorConfiguration> getDataCollectors() {
        return this.dataCollectors;
    }

    List<IndicatorDataProviderConfiguration> getIndicatorDataProviders() {
        return this.indicatorDataProvidersConfiguration;
    }

    List<IndicatorConfiguration> getIndicators() {
        return this.indicators;
    }

    String getToolName() {
        return this.toolName;
    }

    String getDetailedToolName() {
        return this.detailedToolName;
    }

    static {
        DLightToolConfigurationAccessor.setDefault(new DLightToolConfigurationAccessorIml());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DLightToolConfigurationAccessorIml
    extends DLightToolConfigurationAccessor {
        private DLightToolConfigurationAccessorIml() {
        }

        @Override
        public List<DataCollectorConfiguration> getDataCollectors(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getDataCollectors();
        }

        @Override
        public List<IndicatorDataProviderConfiguration> getIndicatorDataProviders(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getIndicatorDataProviders();
        }

        @Override
        public List<IndicatorConfiguration> getIndicators(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getIndicators();
        }

        @Override
        public String getToolName(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getToolName();
        }

        @Override
        public String getDetailedToolName(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.getDetailedToolName();
        }

        @Override
        public String getIconPath(DLightToolConfiguration dLightToolConfiguration) {
            return dLightToolConfiguration.iconPath;
        }
    }
}

