/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.impl.DLightToolConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.impl.DataCollectorProvider;
import org.netbeans.modules.dlight.spi.impl.IDPProvider;
import org.netbeans.modules.dlight.spi.impl.IndicatorProvider;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DLightTool
implements Validateable<DLightTarget> {
    private static final Logger log = DLightLogger.getLogger(DLightTool.class);
    private final String toolName;
    private final String detailedToolName;
    private boolean enabled;
    private final List<DataCollector<?>> dataCollectors;
    private final List<IndicatorDataProvider<?>> indicatorDataProviders;
    private final List<Indicator<?>> indicators;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private final List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());
    private boolean collectorsTurnedOn = true;
    private final String iconPath;
    private final DLightToolConfiguration configuration;

    private DLightTool(DLightToolConfiguration dLightToolConfiguration) {
        Validateable<DLightTarget> validateable;
        DLightToolConfigurationAccessor dLightToolConfigurationAccessor = DLightToolConfigurationAccessor.getDefault();
        this.toolName = dLightToolConfigurationAccessor.getToolName(dLightToolConfiguration);
        this.detailedToolName = dLightToolConfigurationAccessor.getDetailedToolName(dLightToolConfiguration);
        this.iconPath = dLightToolConfigurationAccessor.getIconPath(dLightToolConfiguration);
        this.dataCollectors = Collections.synchronizedList(new ArrayList());
        this.indicators = new ArrayList();
        this.configuration = dLightToolConfiguration;
        this.indicatorDataProviders = Collections.synchronizedList(new ArrayList());
        List<DataCollectorConfiguration> list = dLightToolConfigurationAccessor.getDataCollectors(dLightToolConfiguration);
        List<IndicatorDataProviderConfiguration> list2 = dLightToolConfigurationAccessor.getIndicatorDataProviders(dLightToolConfiguration);
        for (DataCollectorConfiguration object : list) {
            validateable = DataCollectorProvider.getInstance().createDataCollector(object);
            if (validateable == null) {
                log.info("Could not find DataCollector for configuration with id:" + object.getID() + " check if " + "DataColelctorFactory is registered in Global Lookup with the same ID");
                continue;
            }
            this.registerCollector((DataCollector)validateable);
            if (!list2.contains(object) || !(validateable instanceof IndicatorDataProvider)) continue;
            this.registerIndicatorDataProvider((IndicatorDataProvider)validateable);
        }
        for (IndicatorDataProviderConfiguration indicatorDataProviderConfiguration : list2) {
            if (list.contains(indicatorDataProviderConfiguration)) continue;
            validateable = IDPProvider.getInstance().create(indicatorDataProviderConfiguration);
            if (validateable == null) {
                log.info("Could not find IndicatorDataProvider for configuration with id:" + indicatorDataProviderConfiguration.getID() + " check if " + "IndicatorDataProviderFactory is registered in Global Lookup with the same ID");
                continue;
            }
            this.registerIndicatorDataProvider((IndicatorDataProvider)validateable);
        }
    }

    static DLightTool newDLightTool(DLightToolConfiguration dLightToolConfiguration) {
        return new DLightTool(dLightToolConfiguration);
    }

    public final void enable() {
        this.enabled = true;
    }

    public final void disable() {
        this.enabled = false;
    }

    void turnCollectorsState(String string, boolean bl) {
        this.collectorsTurnedOn = bl;
    }

    boolean collectorsTurnedOn() {
        return this.collectorsTurnedOn;
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final String getName() {
        return this.toolName;
    }

    public final String getDetailedName() {
        return this.detailedToolName;
    }

    public final boolean hasIcon() {
        return this.iconPath != null;
    }

    public final String getIconPath() {
        return this.iconPath;
    }

    public final List<DataCollector<?>> getCollectors() {
        return this.dataCollectors;
    }

    final List<DataCollector<?>> getCollectorsByName(String string) {
        return this.dataCollectors;
    }

    private final void registerIndicatorDataProvider(IndicatorDataProvider indicatorDataProvider) {
        if (!this.indicatorDataProviders.contains(indicatorDataProvider)) {
            this.indicatorDataProviders.add(indicatorDataProvider);
        }
    }

    public List<IndicatorDataProvider<?>> getIndicatorDataProviders() {
        return this.indicatorDataProviders;
    }

    List<IndicatorDataProvider<?>> getIndicatorDataProviders(String string) {
        return this.indicatorDataProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Indicator<?>> getIndicators() {
        List<Indicator<?>> list = this.indicators;
        synchronized (list) {
            if (this.indicators.size() == 0) {
                List<IndicatorConfiguration> list2 = DLightToolConfigurationAccessor.getDefault().getIndicators(this.configuration);
                for (IndicatorConfiguration indicatorConfiguration : list2) {
                    Indicator<?> indicator = IndicatorProvider.getInstance().createIndicator(this.toolName, indicatorConfiguration);
                    if (indicator == null) {
                        log.info("Could not find Indicator for configuration with id:" + indicatorConfiguration.getID() + " check if " + "IndicatorFactory is registered in Global Lookup with the same ID");
                        continue;
                    }
                    if (this.indicators.contains(indicator)) continue;
                    this.indicators.add(indicator);
                }
            }
            return this.indicators;
        }
    }

    void registerCollector(DataCollector dataCollector) {
        if (dataCollector == null) {
            log.info("Cannot register collector");
        }
        if (!this.dataCollectors.contains(dataCollector)) {
            this.dataCollectors.add(dataCollector);
        }
        dataCollector.addValidationListener(new ValidationListener(){

            public void validationStateChanged(Validateable validateable, ValidationStatus validationStatus, ValidationStatus validationStatus2) {
                DLightTool.this.notifyStatusChanged(validationStatus, validationStatus2);
            }
        });
    }

    @Override
    public final ValidationStatus validate(DLightTarget dLightTarget) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus validationStatus = this.validationStatus;
        ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
        this.notifyStatusChanged(validationStatus, validationStatus2);
        this.validationStatus = validationStatus2;
        return validationStatus2;
    }

    @Override
    public final void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
        this.notifyStatusChanged(null, this.validationStatus);
    }

    final synchronized ValidationStatus doValidation(DLightTarget dLightTarget) {
        if (this.dataCollectors.isEmpty()) {
            return ValidationStatus.validStatus();
        }
        ValidationStatus validationStatus = ValidationStatus.initialStatus();
        for (DataCollector<?> validateable : this.dataCollectors) {
            validationStatus = validationStatus.merge(validateable.validate(dLightTarget));
        }
        for (IndicatorDataProvider indicatorDataProvider : this.indicatorDataProviders) {
            validationStatus = validationStatus.merge(indicatorDataProvider.validate(dLightTarget));
        }
        return validationStatus;
    }

    @Override
    public final void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    @Override
    public final void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    private final void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus.equals(validationStatus2)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged(this, validationStatus, validationStatus2);
        }
    }

    public String toString() {
        return this.getName();
    }

    static {
        DLightToolAccessor.setDefault(new DLightToolAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DLightToolAccessorImpl
    extends DLightToolAccessor {
        private DLightToolAccessorImpl() {
        }

        @Override
        public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool dLightTool) {
            return dLightTool.getIndicatorDataProviders();
        }

        @Override
        public DLightTool newDLightTool(DLightToolConfiguration dLightToolConfiguration) {
            return new DLightTool(dLightToolConfiguration);
        }

        @Override
        public List<Indicator<?>> getIndicators(DLightTool dLightTool) {
            return dLightTool.getIndicators();
        }

        @Override
        public List<DataCollector<?>> getCollectors(DLightTool dLightTool) {
            return dLightTool.getCollectors();
        }

        @Override
        public boolean collectorsTurnedOn(DLightTool dLightTool) {
            return dLightTool.collectorsTurnedOn();
        }

        @Override
        public void turnCollectorsState(DLightTool dLightTool, boolean bl) {
            dLightTool.turnCollectorsState(null, bl);
        }
    }
}

