/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.support;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.SubstitutableTarget;
import org.netbeans.modules.dlight.api.support.NativeExecutableTargetConfiguration;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.openide.windows.InputOutput;

public final class NativeExecutableTarget
extends DLightTarget
implements SubstitutableTarget,
AttachableTarget,
ChangeListener {
    private static final Logger log = DLightLogger.getLogger(NativeExecutableTarget.class);
    private final ExecutionEnvironment execEnv;
    private final String templateCMD;
    private final Map<String, String> envs;
    private final String workingDirectory;
    private final ExternalTerminal externalTerminal;
    private final String[] templateArgs;
    private final InputOutput io;
    private String[] args;
    private String cmd;
    private boolean x11forwarding;
    private volatile Future<Integer> targetFutureResult;
    private volatile int pid = -1;
    private volatile Integer status = null;
    private final Object stateLock = new String(NativeExecutableTarget.class.getName() + " - state lock");
    private volatile DLightTarget.State state;

    public NativeExecutableTarget(NativeExecutableTargetConfiguration nativeExecutableTargetConfiguration) {
        super(new NativeExecutableTargetExecutionService());
        Object object;
        this.execEnv = nativeExecutableTargetConfiguration.getExecutionEvnitoment();
        this.cmd = nativeExecutableTargetConfiguration.getCmd();
        this.args = nativeExecutableTargetConfiguration.getArgs();
        this.workingDirectory = nativeExecutableTargetConfiguration.getWorkingDirectory();
        this.envs = new HashMap<String, String>();
        this.envs.putAll(nativeExecutableTargetConfiguration.getEnv());
        ExternalTerminal externalTerminal = nativeExecutableTargetConfiguration.getExternalTerminal();
        if (externalTerminal != null) {
            object = new StringBuilder(this.cmd);
            for (String string : this.args) {
                ((StringBuilder)object).append(" \"" + (String)string + '\"');
            }
            externalTerminal = externalTerminal.setTitle(((StringBuilder)object).toString());
        }
        this.externalTerminal = externalTerminal;
        this.templateCMD = this.cmd;
        object = nativeExecutableTargetConfiguration.getInfo();
        for (String string : object.keySet()) {
            this.putToInfo(string, (String)object.get(string));
        }
        Object object2 = null;
        if (this.args != null) {
            object2 = new String[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                object2[i] = this.args[i];
            }
        }
        this.templateArgs = object2;
        this.io = nativeExecutableTargetConfiguration.getIO();
        this.x11forwarding = nativeExecutableTargetConfiguration.getX11Forwarding();
    }

    public int getPID() {
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLightTarget.State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    public String toString() {
        return "Executable target: " + this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent changeEvent) {
        if (!(changeEvent instanceof NativeProcessChangeEvent)) {
            return;
        }
        NativeProcessChangeEvent nativeProcessChangeEvent = (NativeProcessChangeEvent)changeEvent;
        NativeProcess nativeProcess = (NativeProcess)nativeProcessChangeEvent.getSource();
        DLightTarget.State state = null;
        boolean bl = true;
        Object object = this.stateLock;
        synchronized (object) {
            switch (nativeProcessChangeEvent.state) {
                case INITIAL: {
                    this.state = DLightTarget.State.INIT;
                    break;
                }
                case STARTING: {
                    this.state = DLightTarget.State.STARTING;
                    break;
                }
                case RUNNING: {
                    this.state = DLightTarget.State.RUNNING;
                    this.pid = nativeProcessChangeEvent.pid;
                    break;
                }
                case CANCELLED: {
                    bl = false;
                    this.state = DLightTarget.State.TERMINATED;
                    log.fine("NativeTask " + nativeProcess.toString() + " cancelled!");
                    break;
                }
                case ERROR: {
                    bl = false;
                    this.state = DLightTarget.State.FAILED;
                    log.fine("NativeTask " + nativeProcess.toString() + " finished with error! ");
                    break;
                }
                case FINISHED: {
                    bl = false;
                    this.state = DLightTarget.State.DONE;
                    this.status = nativeProcess.exitValue();
                }
            }
            state = this.state;
        }
        if (bl) {
            this.notifyListeners(new DLightTargetChangeEvent(this, state, this.status));
        }
    }

    public int getExitCode() throws InterruptedException {
        if (this.targetFutureResult != null) {
            try {
                return this.targetFutureResult.get();
            }
            catch (ExecutionException executionException) {
                DLightLogger.instance.warning(executionException.getMessage());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return -1;
    }

    public boolean canBeSubstituted() {
        return true;
    }

    public void substitute(String string, String[] stringArray) {
        String string2 = string;
        String[] stringArray2 = stringArray;
        String string3 = this.templateCMD;
        String[] stringArray3 = this.templateArgs;
        this.cmd = string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray2));
        arrayList.add(string3);
        if (stringArray3 != null) {
            arrayList.addAll(Arrays.asList(stringArray3));
        }
        this.args = arrayList.toArray(new String[0]);
    }

    public ExecutionEnvironment getExecEnv() {
        return this.execEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(DLightTarget.ExecutionEnvVariablesProvider executionEnvVariablesProvider) {
        NativeExecutableTarget nativeExecutableTarget = this;
        synchronized (nativeExecutableTarget) {
            ExecutionService executionService;
            ExecutionDescriptor executionDescriptor = new ExecutionDescriptor();
            executionDescriptor = executionDescriptor.controllable(true).frontWindow(true);
            NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
            nativeProcessBuilder.setExecutable(this.cmd).setArguments(this.args);
            nativeProcessBuilder.addNativeProcessListener((ChangeListener)this);
            nativeProcessBuilder.setWorkingDirectory(this.workingDirectory);
            nativeProcessBuilder.addEnvironmentVariables(this.envs);
            nativeProcessBuilder.setX11Forwarding(this.x11forwarding);
            if (this.execEnv.isLocal() && this.externalTerminal != null) {
                nativeProcessBuilder = nativeProcessBuilder.useExternalTerminal(this.externalTerminal);
                executionDescriptor = executionDescriptor.inputVisible(false);
                if (this.io != null) {
                    executionDescriptor = executionDescriptor.inputOutput(this.io);
                    this.io.setInputVisible(false);
                }
            } else {
                nativeProcessBuilder = nativeProcessBuilder.unbufferOutput(true);
                executionDescriptor = executionDescriptor.inputVisible(true);
                if (this.io != null) {
                    executionDescriptor = executionDescriptor.inputOutput(this.io);
                    this.io.setInputVisible(true);
                }
            }
            if (executionEnvVariablesProvider != null) {
                try {
                    executionService = executionEnvVariablesProvider.getExecutionEnv(this);
                    if (executionService != null && !executionService.isEmpty()) {
                        nativeProcessBuilder = nativeProcessBuilder.addEnvironmentVariables(executionService);
                    }
                }
                catch (ConnectException connectException) {
                    log.severe(connectException.getMessage());
                }
            }
            executionDescriptor = executionDescriptor.postExecution(new Runnable(){

                public void run() {
                    NativeExecutableTarget.this.notifyListeners(new DLightTargetChangeEvent(NativeExecutableTarget.this, NativeExecutableTarget.this.state, NativeExecutableTarget.this.status));
                }
            });
            executionService = ExecutionService.newService((Callable)nativeProcessBuilder, (ExecutionDescriptor)executionDescriptor, (String)this.toString());
            this.targetFutureResult = executionService.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        NativeExecutableTarget nativeExecutableTarget = this;
        synchronized (nativeExecutableTarget) {
            if (this.targetFutureResult != null) {
                this.targetFutureResult.cancel(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NativeExecutableTargetExecutionService
    implements DLightTarget.DLightTargetExecutionService<NativeExecutableTarget> {
        private NativeExecutableTargetExecutionService() {
        }

        @Override
        public synchronized void start(final NativeExecutableTarget nativeExecutableTarget, final DLightTarget.ExecutionEnvVariablesProvider executionEnvVariablesProvider) {
            Runnable runnable = new Runnable(){

                public void run() {
                    nativeExecutableTarget.start(executionEnvVariablesProvider);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                DLightExecutorService.submit((Runnable)runnable, (String)("Start target " + this.toString()));
            } else {
                runnable.run();
            }
        }

        @Override
        public synchronized void terminate(NativeExecutableTarget nativeExecutableTarget) {
            nativeExecutableTarget.terminate();
        }
    }
}

