/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public abstract class BaseRubyCustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFileHelper;
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();

    public BaseRubyCustomizerProvider(Project project, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, GeneratedFilesHelper generatedFilesHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.genFileHelper = generatedFilesHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String string) {
        this.showCustomizer(string, null);
    }

    protected abstract SharedRubyProjectProperties createUiProperties(Project var1, UpdateHelper var2, PropertyEvaluator var3, ReferenceHelper var4, GeneratedFilesHelper var5);

    protected abstract String getCustomizerFolderPath();

    public void showCustomizer(String string, String string2) {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        SharedRubyProjectProperties sharedRubyProjectProperties = this.createUiProperties(this.project, this.updateHelper, this.evaluator, this.refHelper, this.genFileHelper);
        Lookup lookup = Lookups.fixed((Object[])new Object[]{this.project, sharedRubyProjectProperties, new SubCategoryProvider(string, string2)});
        OptionListener optionListener = new OptionListener(this.project, sharedRubyProjectProperties);
        dialog = ProjectCustomizer.createCustomizerDialog((String)this.getCustomizerFolderPath(), (Lookup)lookup, (String)string, (ActionListener)optionListener, null);
        dialog.addWindowListener(optionListener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage(BaseRubyCustomizerProvider.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.setVisible(true);
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String string, String string2) {
            this.category = string;
            this.subcategory = string2;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private SharedRubyProjectProperties uiProperties;

        OptionListener(Project project, SharedRubyProjectProperties sharedRubyProjectProperties) {
            this.project = project;
            this.uiProperties = sharedRubyProjectProperties;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.uiProperties.save();
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            project2Dialog.remove(this.project);
        }

        public void windowClosing(WindowEvent windowEvent) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }
}

