/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.gems.GemAction;
import org.netbeans.modules.ruby.rubyproject.PlatformChangeListener;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ui.GemChildrenFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

final class PlatformNode
extends AbstractNode {
    private static final Logger LOGGER = Logger.getLogger(PlatformNode.class.getName());
    private static final String PLATFORM_ICON = "org/netbeans/modules/ruby/rubyproject/resources/platform.gif";
    private final RubyBaseProject project;
    private final Action[] actions;

    PlatformNode(final RubyBaseProject rubyBaseProject) {
        super(Children.create((ChildFactory)GemChildrenFactory.create(rubyBaseProject), (boolean)false));
        this.project = rubyBaseProject;
        this.actions = new Action[]{new ChangePlatformAction(), new ManageRubyGemsAction()};
        this.setIconBaseWithExtension(PLATFORM_ICON);
        rubyBaseProject.addPlatformChangeListener(new PlatformChangeListener(){

            public void platformChanged() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        PlatformNode.this.setChildren(Children.create((ChildFactory)GemChildrenFactory.create(rubyBaseProject), (boolean)false));
                        PlatformNode.this.fireDisplayNameChange(null, null);
                        PlatformNode.this.fireNameChange(null, null);
                    }
                });
            }
        });
    }

    public String getDisplayName() {
        return this.project.getPlatform().getLabel();
    }

    public Action[] getActions(boolean bl) {
        return this.actions;
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(PlatformNode.class, (String)string);
    }

    private final class ManageRubyGemsAction
    extends AbstractAction {
        ManageRubyGemsAction() {
            super(PlatformNode.getMessage("PlatformNode.ManageRubyGems"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GemAction.showGemManager((RubyPlatform)PlatformNode.this.project.getPlatform());
        }
    }

    private final class ChangePlatformAction
    extends AbstractAction
    implements Presenter.Popup {
        private ChangePlatformAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            return this.createMenu();
        }

        private JMenuItem createMenu() {
            JMenu jMenu = new JMenu(PlatformNode.getMessage("PlatformNode.Change"));
            for (final RubyPlatform rubyPlatform : RubyPlatformManager.getSortedPlatforms()) {
                JMenuItem jMenuItem = new JMenuItem(rubyPlatform.getLabel());
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            PlatformNode.this.project.changeAndStorePlatform(rubyPlatform);
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.SEVERE, "Unable to change the platform: " + iOException.getLocalizedMessage(), iOException);
                        }
                    }
                });
                jMenu.add(jMenuItem);
            }
            return jMenu;
        }
    }
}

