/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.templates;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.rubyproject.templates.RubyTargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRubyFileWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private Type type;
    private static final long serialVersionUID = 1L;
    private final transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    NewRubyFileWizardIterator() {
        this(Type.FILE);
    }

    NewRubyFileWizardIterator(Type type) {
        this.type = type;
    }

    public static NewRubyFileWizardIterator classWizard() {
        return new NewRubyFileWizardIterator(Type.CLASS);
    }

    public static NewRubyFileWizardIterator moduleWizard() {
        return new NewRubyFileWizardIterator(Type.MODULE);
    }

    public static NewRubyFileWizardIterator testWizard() {
        return new NewRubyFileWizardIterator(Type.TEST);
    }

    public static NewRubyFileWizardIterator specWizard() {
        return new NewRubyFileWizardIterator(Type.SPEC);
    }

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("ruby");
        assert (sourceGroupArray != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if (sourceGroupArray.length == 0) {
            sourceGroupArray = sources.getSourceGroups("generic");
            return new WizardDescriptor.Panel[]{Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray)};
        }
        return new WizardDescriptor.Panel[]{new RubyTargetChooserPanel(project, sourceGroupArray, null, this.type)};
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        assert (panelArray != null);
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    public Set<FileObject> instantiate() throws IOException {
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String string = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        FileObject fileObject2 = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject fileObject3 = null;
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        HashMap hashMap = new HashMap(this.wiz.getProperties());
        hashMap.remove("project");
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string, hashMap);
        fileObject3 = dataObject2.getPrimaryFile();
        return Collections.singleton(fileObject3);
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels(wizardDescriptor);
        String[] stringArray = null;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        ChangeListener[] changeListenerArray;
        Object object = this.listeners;
        synchronized (object) {
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        FILE,
        CLASS,
        MODULE,
        TEST,
        SPEC;

    }
}

