/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.rubyproject.PlatformChangeListener;
import org.netbeans.modules.ruby.rubyproject.RubyLoggingOption;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.modules.ruby.spi.project.support.rake.FilterPropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectEvent;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectListener;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class RubyBaseProject
implements Project,
RakeProjectListener {
    public static final String SOURCES_TYPE_RUBY = "ruby";
    protected final RakeProjectHelper helper;
    private final PropertyEvaluator eval;
    protected final ReferenceHelper refHelper;
    protected final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    protected final UpdateHelper updateHelper;
    private final String projectConfigurationNamespace;
    private CopyOnWriteArrayList<PlatformChangeListener> platformCLs;

    protected RubyBaseProject(RakeProjectHelper rakeProjectHelper, String string) {
        this.helper = rakeProjectHelper;
        this.projectConfigurationNamespace = string;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration auxiliaryConfiguration = rakeProjectHelper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(rakeProjectHelper, auxiliaryConfiguration, this.eval);
        this.genFilesHelper = new GeneratedFilesHelper(rakeProjectHelper);
        this.updateHelper = new UpdateHelper(this, this.helper, auxiliaryConfiguration, this.genFilesHelper, UpdateHelper.createDefaultNotifier(), string);
        this.lookup = this.createLookup(auxiliaryConfiguration, rakeProjectHelper.createAuxiliaryProperties(), new Info(), new ProjectOpenedHookImpl());
        rakeProjectHelper.addRakeProjectListener((RakeProjectListener)this);
        this.platformCLs = new CopyOnWriteArrayList();
    }

    protected abstract Icon getIcon();

    protected abstract Lookup createLookup(AuxiliaryConfiguration var1, AuxiliaryProperties var2, ProjectInformation var3, ProjectOpenedHook var4);

    protected abstract void registerClassPath();

    protected abstract void unregisterClassPath();

    public RubyPlatform getPlatform() {
        return RubyPlatform.platformFor((Project)this);
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties")});
        PropertyEvaluator propertyEvaluator2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties"), new ConfigPropertyProvider(propertyEvaluator, "nbproject/private/configs", this.helper), this.helper.getPropertyProvider("nbproject/private/private.properties"), PropertyUtils.userPropertiesProvider((PropertyEvaluator)propertyEvaluator2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), new ConfigPropertyProvider(propertyEvaluator, "nbproject/configs", this.helper), this.helper.getPropertyProvider("nbproject/project.properties")});
    }

    private boolean hasRakeFile() {
        return this.getRakeFile() != null;
    }

    FileObject getRakeFile() {
        return RakeSupport.findRakeFile(this);
    }

    public abstract FileObject[] getSourceRootFiles();

    public abstract FileObject[] getTestSourceRootFiles();

    public PropertyEvaluator evaluator() {
        return this.eval;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public RakeProjectHelper getRakeProjectHelper() {
        return this.helper;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public void changeAndStorePlatform(final RubyPlatform rubyPlatform) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties editableProperties = RubyBaseProject.this.helper.getProperties("nbproject/private/private.properties");
                    SharedRubyProjectProperties.storePlatform(editableProperties, rubyPlatform);
                    RubyBaseProject.this.helper.putProperties("nbproject/private/private.properties", editableProperties);
                    ProjectManager.getDefault().saveProject((Project)RubyBaseProject.this);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
    }

    public void configurationXmlChanged(RakeProjectEvent rakeProjectEvent) {
        if (rakeProjectEvent.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(RakeProjectEvent rakeProjectEvent) {
        for (PlatformChangeListener platformChangeListener : this.platformCLs) {
            platformChangeListener.platformChanged();
        }
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Element element;
                Element element2 = RubyBaseProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS(RubyBaseProject.this.projectConfigurationNamespace, "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS(RubyBaseProject.this.projectConfigurationNamespace, "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                RubyBaseProject.this.helper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    public void addPlatformChangeListener(PlatformChangeListener platformChangeListener) {
        this.platformCLs.add(platformChangeListener);
    }

    public void removePlatformChangeListener(PlatformChangeListener platformChangeListener) {
        this.platformCLs.remove(platformChangeListener);
    }

    protected void open() {
        this.registerClassPath();
        FileObject fileObject = this.getRakeFile();
        if (fileObject != null) {
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    RubyBaseProject.this.updateRakeTasks();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    RubyBaseProject.this.updateRakeTasks();
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    RubyBaseProject.this.updateRakeTasks();
                }
            });
            this.updateRakeTasks();
        }
    }

    private void updateRakeTasks() {
        RubyPlatform rubyPlatform = this.getPlatform();
        if (this.hasRakeFile() && rubyPlatform != null && rubyPlatform.hasValidRake(false)) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    RakeSupport.refreshTasks(RubyBaseProject.this, false);
                }
            });
        }
    }

    static {
        RubyLoggingOption.initLoggers();
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            RubyBaseProject.this.open();
            RubyCoverageProvider rubyCoverageProvider = RubyCoverageProvider.get((Project)RubyBaseProject.this);
            if (rubyCoverageProvider.isEnabled()) {
                rubyCoverageProvider.notifyProjectOpened();
            }
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)RubyBaseProject.this);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            RubyBaseProject.this.unregisterClassPath();
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public String getDisplayName() {
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    Element element = RubyBaseProject.this.updateHelper.getPrimaryConfigurationData(true);
                    NodeList nodeList = element.getElementsByTagNameNS(RubyBaseProject.this.projectConfigurationNamespace, "name");
                    if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                        return ((Text)nodeList.item(0)).getNodeValue();
                    }
                    return "???";
                }
            });
        }

        public Icon getIcon() {
            return RubyBaseProject.this.getIcon();
        }

        public Project getProject() {
            return RubyBaseProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final RakeProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator propertyEvaluator, String string, RakeProjectHelper rakeProjectHelper) {
            super(ConfigPropertyProvider.computeDelegate(propertyEvaluator, string, rakeProjectHelper));
            this.baseEval = propertyEvaluator;
            this.prefix = string;
            this.helper = rakeProjectHelper;
            propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("config".equals(propertyChangeEvent.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator propertyEvaluator, String string, RakeProjectHelper rakeProjectHelper) {
            String string2 = propertyEvaluator.getProperty("config");
            if (string2 != null) {
                return rakeProjectHelper.getPropertyProvider(string + "/" + string2 + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }
}

