/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.GotoTest;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseActionProvider;
import org.netbeans.modules.ruby.rubyproject.RubyConfigurationProvider;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunner;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.MainClassWarning;
import org.netbeans.modules.ruby.spi.project.support.rake.EditableProperties;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class RubyActionProvider
extends RubyBaseActionProvider {
    public static final String COMMAND_IRB_CONSOLE = "irb-console";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "autotest", "autospec", "rdoc", "irb-console", "run", "run.single", "debug", "debug.single", "test", "rspec", "test.single", "debug.test.single", "delete", "copy", "move", "rename"};
    private static final String[] MIME_TYPES = new String[]{"text/x-ruby"};
    final RubyProject project;

    public RubyActionProvider(RubyProject rubyProject, UpdateHelper updateHelper) {
        super(rubyProject, updateHelper);
        this.project = rubyProject;
    }

    protected FileObject[] getSourceRoots() {
        return this.project.getSourceRoots().getRoots();
    }

    protected FileObject[] getTestSourceRoots() {
        return this.project.getTestSourceRoots().getRoots();
    }

    protected String[] getMimeTypes() {
        return MIME_TYPES;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public RubyExecutionDescriptor getScriptDescriptor(File object, FileObject fileObject, String string, String string2, Lookup lookup, boolean bl, LineConvertor ... lineConvertorArray) {
        RubyCoverageProvider rubyCoverageProvider;
        RubyExecutionDescriptor rubyExecutionDescriptor;
        Object object2;
        String string3;
        String string4 = SharedRubyProjectProperties.getRubyOptions(this.project);
        String string5 = RubyProjectUtil.getLoadPath(this.project);
        string4 = string4 != null ? string5 + " " + string4 : string5;
        RubyExecutionDescriptor rubyExecutionDescriptor2 = this.project.getSourceRoots().getRoots();
        FileObject[] fileObjectArray = this.project.getTestSourceRoots().getRoots();
        string = this.locate(string, (FileObject[])rubyExecutionDescriptor2, fileObjectArray);
        if (object == null) {
            string3 = this.project.evaluator().getProperty("work.dir");
            object = this.getSourceFolder();
            if (string3 != null && string3.length() > 0) {
                object2 = new File(string3);
                if (!((File)object2).exists() && !((File)(object2 = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), string3))).exists() && rubyExecutionDescriptor2 != null && ((FileObject[])rubyExecutionDescriptor2).length > 0) {
                    FileObject fileObject2;
                    rubyExecutionDescriptor = rubyExecutionDescriptor2;
                    int n = ((FileObject[])rubyExecutionDescriptor).length;
                    for (int i = 0; i < n && !((File)(object2 = new File(FileUtil.toFile((FileObject)(fileObject2 = rubyExecutionDescriptor[i])), string3))).exists(); ++i) {
                    }
                }
                if (((File)object2).exists()) {
                    object = object2;
                }
            }
        }
        string3 = this.project.evaluator().getProperty("javac.classpath");
        object2 = this.project.evaluator().getProperty("jvm.args");
        rubyExecutionDescriptor = new RubyExecutionDescriptor(this.getPlatform(), string2, (File)object, string);
        rubyExecutionDescriptor.debug(bl);
        rubyExecutionDescriptor.showSuspended(true);
        rubyExecutionDescriptor.allowInput();
        rubyExecutionDescriptor.fileObject(fileObject);
        rubyExecutionDescriptor.jvmArguments((String)object2);
        rubyExecutionDescriptor.initialArgs(string4);
        rubyExecutionDescriptor.classPath(string3);
        rubyExecutionDescriptor.additionalArgs(this.getApplicationArguments());
        rubyExecutionDescriptor.fileLocator((LineConvertors.FileLocator)new RubyFileLocator(lookup, this.project));
        rubyExecutionDescriptor.addStandardRecognizers();
        rubyExecutionDescriptor.addOutConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)rubyExecutionDescriptor.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        rubyExecutionDescriptor.addErrConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)rubyExecutionDescriptor.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        rubyExecutionDescriptor.setEncoding(this.getSourceEncoding());
        if (lineConvertorArray != null) {
            for (LineConvertor lineConvertor : lineConvertorArray) {
                rubyExecutionDescriptor.addOutConvertor(lineConvertor);
            }
        }
        if ((rubyCoverageProvider = RubyCoverageProvider.get((Project)this.project)) != null && rubyCoverageProvider.isEnabled()) {
            rubyExecutionDescriptor = rubyCoverageProvider.wrapWithCoverage(rubyExecutionDescriptor, false, null);
        }
        return rubyExecutionDescriptor;
    }

    private String locate(String string, FileObject[] fileObjectArray, FileObject[] fileObjectArray2) {
        if (!new File(string).exists() && fileObjectArray != null && fileObjectArray.length > 0) {
            FileObject fileObject;
            boolean bl = false;
            for (FileObject fileObject2 : fileObjectArray) {
                fileObject = fileObject2.getFileObject(string);
                if (fileObject == null) continue;
                string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
                bl = true;
                break;
            }
            if (!bl && fileObjectArray2 != null) {
                for (FileObject fileObject2 : fileObjectArray2) {
                    fileObject = fileObject2.getFileObject(string);
                    if (fileObject == null) continue;
                    string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
                    break;
                }
            }
        }
        return string;
    }

    private void openIrbConsole(Lookup lookup) {
        RubyPlatform rubyPlatform = this.getPlatform();
        String string = rubyPlatform.findExecutable("irb");
        if (string == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        String string2 = NbBundle.getMessage(RubyActionProvider.class, (String)"CTL_IrbTopComponent");
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String string3 = this.project.evaluator().getProperty("javac.classpath");
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string2, file, string).showSuspended(false).showProgress(false).classPath(string3).allowInput().additionalArgs(new String[]{"--simple-prompt", "--noreadline"}).fileLocator((LineConvertors.FileLocator)new RubyFileLocator(lookup, this.project)).addStandardRecognizers();
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, this.getSourceEncoding());
        ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string2).run();
    }

    public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
        Object object;
        Object object2;
        Object object3;
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        assert (rubyPlatform != null) : "Action '" + string + "' should be disabled when platform is invalid";
        if ("run".equals(string) || "debug".equals(string)) {
            if (!rubyPlatform.isValid(true)) {
                return;
            }
            String string2 = this.project.evaluator().getProperty("config");
            String string3 = string2 == null || string2.length() == 0 ? "nbproject/project.properties" : "nbproject/configs/" + string2 + ".properties";
            EditableProperties editableProperties = this.getUpdateHelper().getProperties(string3);
            String string4 = this.project.evaluator().getProperty("main.file");
            MainClassStatus mainClassStatus = this.isSetMainClass(this.project.getSourceRoots().getRoots(), string4);
            if (lookup.lookup(RubyConfigurationProvider.Config.class) != null) {
                mainClassStatus = MainClassStatus.SET_AND_VALID;
            }
            if (mainClassStatus != MainClassStatus.SET_AND_VALID) {
                do {
                    if (this.showMainClassWarning(string4, ProjectUtils.getInformation((Project)this.project).getDisplayName(), editableProperties, mainClassStatus)) {
                        return;
                    }
                    string4 = (String)editableProperties.get((Object)"main.file");
                } while ((mainClassStatus = this.isSetMainClass(this.project.getSourceRoots().getRoots(), string4)) != MainClassStatus.SET_AND_VALID);
                try {
                    if (!this.getUpdateHelper().requestSave()) {
                        return;
                    }
                    this.getUpdateHelper().putProperties(string3, editableProperties);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(1, "Error while saving project: " + iOException);
                }
            }
            LifecycleManager.getDefault().saveAll();
            String string5 = string4 != null ? NbBundle.getMessage(RubyActionProvider.class, (String)"Ruby") : NbBundle.getMessage(RubyActionProvider.class, (String)"Rake");
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
            if (projectInformation != null) {
                string5 = projectInformation.getDisplayName();
            }
            if (string4 != null) {
                FileObject fileObject = null;
                this.runRubyScript(fileObject, string4, string5, lookup, "debug".equals(string), new LineConvertor[0]);
                return;
            }
            if (!rubyPlatform.hasRubyGemsInstalled(true) || !rubyPlatform.hasValidRake(true)) {
                return;
            }
            RubyFileLocator rubyFileLocator = new RubyFileLocator(lookup, this.project);
            File file = this.getSourceFolder();
            String string6 = this.project.evaluator().getProperty("javac.classpath");
            RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string5, file, rubyPlatform.getRake()).fileLocator((LineConvertors.FileLocator)rubyFileLocator).allowInput().classPath(string6).appendJdkToPath(rubyPlatform.isJRuby()).addStandardRecognizers().addErrConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)rubyFileLocator, (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2)).addOutConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)rubyFileLocator, (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
            RubyCoverageProvider rubyCoverageProvider = RubyCoverageProvider.get((Project)this.project);
            if (rubyCoverageProvider != null && rubyCoverageProvider.isEnabled()) {
                rubyExecutionDescriptor = rubyCoverageProvider.wrapWithCoverage(rubyExecutionDescriptor, false, null);
            }
            RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, this.getSourceEncoding());
            ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string5);
            return;
        }
        if ("run.single".equals(string) || "debug.single".equals(string)) {
            TestRunner testRunner;
            if (!rubyPlatform.isValid(true)) {
                return;
            }
            FileObject fileObject = this.getCurrentFile(lookup);
            if (RakeSupport.isRakeFile(fileObject)) {
                if (!rubyPlatform.hasValidRake(true)) {
                    return;
                }
                LifecycleManager.getDefault().saveAll();
                RakeRunner rakeRunner = new RakeRunner(this.project);
                rakeRunner.setRakeFile(fileObject);
                rakeRunner.setFileLocator(new RubyFileLocator(lookup, this.project));
                rakeRunner.showWarnings(true);
                rakeRunner.setDebug("debug.single".equals(string));
                rakeRunner.run(new String[0]);
                return;
            }
            RSpecSupport rSpecSupport = new RSpecSupport(this.project);
            if (rSpecSupport.isRSpecInstalled() && RSpecSupport.isSpecFile(fileObject)) {
                LifecycleManager.getDefault().saveAll();
                TestRunner testRunner2 = Util.getTestRunner(TestRunner.TestType.RSPEC);
                if (testRunner2 != null) {
                    testRunner2.runTest(fileObject, "debug.single".equals(string));
                } else {
                    rSpecSupport.runRSpec(null, fileObject, fileObject.getName(), new RubyFileLocator(lookup, this.project), true, "debug.single".equals(string), new String[0]);
                }
                return;
            }
            this.saveFile(fileObject);
            if (fileObject.getName().endsWith("_test") && (testRunner = Util.getTestRunner(TestRunner.TestType.TEST_UNIT)) != null) {
                testRunner.getInstance().runTest(fileObject, "debug.single".equals(string));
                return;
            }
            this.runRubyScript(fileObject, FileUtil.toFile((FileObject)fileObject).getAbsolutePath(), fileObject.getNameExt(), lookup, "debug.single".equals(string), new LineConvertor[]{null});
            return;
        }
        if ("rebuild".equals(string) || "build".equals(string) || "clean".equals(string)) {
            RakeRunner rakeRunner = new RakeRunner(this.project);
            rakeRunner.showWarnings(true);
            if ("rebuild".equals(string)) {
                rakeRunner.run("clean", "gem");
            } else if ("build".equals(string)) {
                rakeRunner.run("gem");
            } else {
                rakeRunner.run("clean");
            }
            return;
        }
        if ("rdoc".equals(string)) {
            LifecycleManager.getDefault().saveAll();
            File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            Runnable runnable = new Runnable(){

                public void run() {
                    FileObject fileObject;
                    FileObject fileObject2 = RubyActionProvider.this.project.getProjectDirectory().getFileObject("doc");
                    if (fileObject2 != null && (fileObject = fileObject2.getFileObject("index.html")) != null) {
                        try {
                            URL uRL = FileUtil.toFile((FileObject)fileObject).toURI().toURL();
                            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ErrorManager.getDefault().notify((Throwable)malformedURLException);
                        }
                    }
                }
            };
            RubyFileLocator rubyFileLocator = new RubyFileLocator(lookup, this.project);
            String string7 = NbBundle.getMessage(RubyActionProvider.class, (String)"RubyDocumentation");
            RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string7, file).additionalArgs(new String[]{"-r", "rdoc/rdoc", "-e", "begin; r = RDoc::RDoc.new; r.document(ARGV); end"}).fileLocator((LineConvertors.FileLocator)rubyFileLocator).postBuild(runnable).addStandardRecognizers();
            RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, this.getSourceEncoding());
            ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string7).run();
            return;
        }
        if ("autotest".equals(string)) {
            if (AutoTestSupport.isInstalled(this.project, TestRunner.TestType.AUTOTEST)) {
                AutoTestSupport autoTestSupport = new AutoTestSupport(lookup, this.project, this.getSourceEncoding());
                autoTestSupport.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                autoTestSupport.start(TestRunner.TestType.AUTOTEST);
            }
            return;
        }
        if ("autospec".equals(string)) {
            if (AutoTestSupport.isInstalled(this.project, TestRunner.TestType.AUTOSPEC)) {
                AutoTestSupport autoTestSupport = new AutoTestSupport(lookup, this.project, this.getSourceEncoding());
                autoTestSupport.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                autoTestSupport.start(TestRunner.TestType.AUTOSPEC);
            }
            return;
        }
        if ("test.single".equals(string) || "debug.test.single".equals(string)) {
            if (!rubyPlatform.isValid(true)) {
                return;
            }
            object3 = this.getCurrentFile(lookup);
            if (object3 == null) {
                return;
            }
            this.saveFile((FileObject)object3);
            object2 = new GotoTest().findTest((FileObject)object3, -1);
            if (object2 != DeclarationFinder.DeclarationLocation.NONE) {
                object3 = object2.getFileObject();
                this.saveFile((FileObject)object3);
            }
            boolean bl = "debug.test.single".equals(string);
            object = new RSpecSupport(this.project);
            if (((RSpecSupport)object).isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)object3)) {
                TestRunner testRunner = Util.getTestRunner(TestRunner.TestType.RSPEC);
                if (testRunner != null) {
                    testRunner.runTest((FileObject)object3, bl);
                } else {
                    ((RSpecSupport)object).runRSpec(null, (FileObject)object3, object3.getName(), new RubyFileLocator(lookup, this.project), true, bl, new String[0]);
                }
                return;
            }
            TestRunner testRunner = Util.getTestRunner(TestRunner.TestType.TEST_UNIT);
            if (testRunner != null) {
                testRunner.getInstance().runTest((FileObject)object3, bl);
            } else {
                this.runRubyScript((FileObject)object3, FileUtil.toFile((FileObject)object3).getAbsolutePath(), object3.getNameExt(), lookup, bl, new TestNotifierLineConvertor(true, true));
            }
        }
        if ("test".equals(string)) {
            boolean bl;
            object3 = Util.getTestRunner(TestRunner.TestType.TEST_UNIT);
            boolean bl2 = bl = RakeSupport.getRakeTask(this.project, "test") != null;
            if (bl) {
                File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                object = new RakeRunner(this.project);
                ((RakeRunner)object).setPWD(file);
                ((RakeRunner)object).setFileLocator(new RubyFileLocator(lookup, this.project));
                ((RakeRunner)object).showWarnings(true);
                ((RakeRunner)object).setDebug("debug.single".equals(string));
                ((RakeRunner)object).run("test");
            } else if (object3 != null) {
                object3.getInstance().runAllTests(this.project, false);
            }
            return;
        }
        if ("rspec".equals(string)) {
            boolean bl = RakeSupport.getRakeTask(this.project, "spec") != null;
            object2 = Util.getTestRunner(TestRunner.TestType.RSPEC);
            if (bl) {
                File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                object = new RakeRunner(this.project);
                ((RakeRunner)object).setPWD(file);
                ((RakeRunner)object).setFileLocator(new RubyFileLocator(lookup, this.project));
                ((RakeRunner)object).showWarnings(true);
                ((RakeRunner)object).run("spec");
            } else if (object2 != null) {
                object2.getInstance().runAllTests(this.project, false);
            }
            return;
        }
        if ("rspec-all".equals(string)) {
            object3 = Util.getTestRunner(TestRunner.TestType.RSPEC);
            if (object3 != null) {
                object3.getInstance().runAllTests(this.project, false);
            }
            return;
        }
        if (COMMAND_IRB_CONSOLE.equals(string)) {
            this.openIrbConsole(lookup);
            return;
        }
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        if (this.getPlatform() == null) {
            return false;
        }
        if (string.equals("compile.single")) {
            return this.findSourcesAndPackages(lookup, this.project.getSourceRoots().getRoots()) != null || this.findSourcesAndPackages(lookup, this.project.getTestSourceRoots().getRoots()) != null;
        }
        if (string.equals("run.single") || string.equals("debug.single")) {
            if (RakeSupport.isRakeFileSelected(lookup)) {
                return true;
            }
            FileObject[] fileObjectArray = this.findSources(lookup);
            if (fileObjectArray != null && fileObjectArray.length == 1) {
                return true;
            }
            fileObjectArray = this.findTestSources(lookup);
            return fileObjectArray != null && fileObjectArray.length == 1;
        }
        return true;
    }

    protected FileObject[] findSourcesAndPackages(Lookup lookup, FileObject fileObject) {
        if (fileObject != null) {
            FileObject[] fileObjectArray = RubyActionProvider.findSelectedFiles(lookup, fileObject, null, true);
            if (fileObjectArray != null) {
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (fileObjectArray[i].isFolder() || !fileObjectArray[i].getMIMEType().equals("text/x-ruby")) continue;
                    return null;
                }
            }
            return fileObjectArray;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup lookup, FileObject[] fileObjectArray) {
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = this.findSourcesAndPackages(lookup, fileObjectArray[i]);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    private FileObject getRoot(FileObject[] fileObjectArray, FileObject fileObject) {
        assert (fileObject != null) : "File can't be null";
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            assert (fileObjectArray[i] != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)fileObjectArray[i], (FileObject)fileObject) && !fileObjectArray[i].equals(fileObject)) continue;
            fileObject2 = fileObjectArray[i];
            break;
        }
        return fileObject2;
    }

    private MainClassStatus isSetMainClass(FileObject[] fileObjectArray, String string) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult != false ? MainClassStatus.SET_AND_VALID : MainClassStatus.SET_BUT_INVALID;
        }
        if (string == null || string.length() == 0) {
            return MainClassStatus.UNSET;
        }
        if (RubyProjectUtil.isMainClass(string, fileObjectArray)) {
            return MainClassStatus.SET_AND_VALID;
        }
        return MainClassStatus.SET_BUT_INVALID;
    }

    private boolean showMainClassWarning(String string, String string2, EditableProperties editableProperties, MainClassStatus mainClassStatus) {
        boolean bl;
        String string3;
        final JButton jButton = new JButton(NbBundle.getMessage(RubyActionProvider.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyActionProvider.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (mainClassStatus) {
            case UNSET: {
                string3 = MessageFormat.format(NbBundle.getMessage(RubyActionProvider.class, (String)"LBL_MainClassNotFound"), string2);
                break;
            }
            case SET_BUT_INVALID: {
                string3 = MessageFormat.format(NbBundle.getMessage(RubyActionProvider.class, (String)"LBL_MainClassWrong"), string, string2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning mainClassWarning = new MainClassWarning(string3, this.project.getSourceRoots().getRoots());
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        mainClassWarning.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                    jButton.doClick();
                } else {
                    jButton.setEnabled(mainClassWarning.getSelectedMainClass() != null);
                }
            }
        });
        jButton.setEnabled(false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mainClassWarning, NbBundle.getMessage(RubyActionProvider.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != objectArray[0]) {
            bl = true;
        } else {
            string = mainClassWarning.getSelectedMainClass();
            bl = false;
            editableProperties.put("main.file", string == null ? "" : string);
        }
        dialog.dispose();
        return bl;
    }

    private File getSourceFolder() {
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        if (fileObjectArray != null && fileObjectArray.length > 0) {
            return FileUtil.toFile((FileObject)fileObjectArray[0]);
        }
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MainClassStatus {
        SET_AND_VALID,
        SET_BUT_INVALID,
        UNSET;

    }
}

