/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.debugger.jpda.ui.debugging.SwitcherTableItem;
import org.netbeans.modules.debugger.jpda.ui.debugging.SwitcherTableModel;
import org.openide.util.Utilities;

public class SwitcherTable
extends JTable {
    private static final Border rendererBorder = BorderFactory.createEmptyBorder(2, 5, 0, 5);
    private Icon nullIcon = new NullIcon();
    private Color foreground;
    private Color background;
    private Color selForeground;
    private Color selBackground;
    private Dimension prefSize;
    private boolean needCalcRowHeight = true;
    private static SoftReference<BufferedImage> ctx = null;

    public SwitcherTable(SwitcherTableItem[] switcherTableItemArray) {
        this(switcherTableItemArray, 0);
    }

    public SwitcherTable(SwitcherTableItem[] switcherTableItemArray, int n) {
        this.init();
        int n2 = n == 0 ? 10 : 5;
        int n3 = Utilities.getUsableScreenBounds().height - n - n2;
        this.setModel(new SwitcherTableModel(switcherTableItemArray, this.getRowHeight(), n3));
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().setAnchorSelectionIndex(-1);
        this.getSelectionModel().setLeadSelectionIndex(-1);
        this.setAutoscrolls(false);
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(this.getForeground()));
        this.setShowHorizontalLines(false);
        this.calcRowHeight(SwitcherTable.getOffscreenGraphics());
    }

    public void updateUI() {
        this.needCalcRowHeight = true;
        super.updateUI();
    }

    public void setFont(Font font) {
        this.needCalcRowHeight = true;
        super.setFont(font);
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        SwitcherTableItem switcherTableItem = (SwitcherTableItem)this.getSwitcherTableModel().getValueAt(n, n2);
        boolean bl = n == this.getSelectedRow() && n2 == this.getSelectedColumn() && switcherTableItem != null;
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)tableCellRenderer.getTableCellRendererComponent(this, switcherTableItem, bl, bl, n, n2);
        if (switcherTableItem == null) {
            defaultTableCellRenderer.setOpaque(false);
            defaultTableCellRenderer.setIcon(null);
            return defaultTableCellRenderer;
        }
        Icon icon = switcherTableItem.getIcon();
        if (icon == null) {
            icon = this.nullIcon;
        }
        defaultTableCellRenderer.setText(bl || switcherTableItem.isActive() ? this.stripHtml(switcherTableItem.getHtmlName()) : switcherTableItem.getHtmlName());
        defaultTableCellRenderer.setIcon(icon);
        defaultTableCellRenderer.setBorder(rendererBorder);
        defaultTableCellRenderer.setIconTextGap(42 - icon.getIconWidth());
        if (switcherTableItem.isActive()) {
            defaultTableCellRenderer.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        }
        defaultTableCellRenderer.setOpaque(true);
        return defaultTableCellRenderer;
    }

    private String stripHtml(String string) {
        if (null == string) {
            return null;
        }
        String string2 = string.replaceAll("<[^>]*>", "");
        string2 = string2.replaceAll("&nbsp;", " ");
        string2 = string2.trim();
        return string2;
    }

    public Color getForeground() {
        if (this.foreground == null) {
            this.foreground = UIManager.getColor("ComboBox.foreground");
        }
        return this.foreground != null ? this.foreground : super.getForeground();
    }

    public Color getBackground() {
        if (this.background == null) {
            this.background = UIManager.getColor("ComboBox.background");
        }
        return this.background != null ? this.background : super.getBackground();
    }

    public Color getSelectionForeground() {
        if (this.selForeground == null) {
            this.selForeground = UIManager.getColor("ComboBox.selectionForeground");
        }
        return this.selForeground != null ? this.selForeground : super.getSelectionForeground();
    }

    public Color getSelectionBackground() {
        if (this.selBackground == null) {
            this.selBackground = UIManager.getColor("ComboBox.selectionBackground");
        }
        return this.selBackground != null ? this.selBackground : super.getSelectionBackground();
    }

    private void calcRowHeight(Graphics graphics) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = Math.max(fontMetrics.getHeight(), 16) + 4;
        this.needCalcRowHeight = false;
        this.setRowHeight(n);
    }

    private static Graphics2D getOffscreenGraphics() {
        BufferedImage bufferedImage = null;
        if (ctx != null) {
            bufferedImage = ctx.get();
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(bufferedImage);
        }
        return (Graphics2D)bufferedImage.getGraphics();
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            int n;
            int n2 = this.getColumnCount();
            int n3 = this.getRowCount();
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(i, n);
                    Component component = this.prepareRenderer(tableCellRenderer, i, n);
                    n4 = Math.max(component.getPreferredSize().width + 1, n4);
                }
            }
            n4 = Math.min(n4, 400);
            for (n = 0; n < n2; ++n) {
                this.getColumnModel().getColumn(n).setPreferredWidth(n4);
            }
            this.prefSize = new Dimension(n4 * n2, n3 * this.getRowHeight());
        }
        return this.prefSize;
    }

    private SwitcherTableModel getSwitcherTableModel() {
        return (SwitcherTableModel)this.getModel();
    }

    public SwitcherTableItem getSelectedItem() {
        return (SwitcherTableItem)this.getValueAt(this.getSelectedRow(), this.getSelectedColumn());
    }

    public void paint(Graphics graphics) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(graphics);
        }
        super.paint(graphics);
    }

    public int getLastValidRow() {
        int n = this.getColumnCount() - 1;
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            if (this.getValueAt(i, n) == null) continue;
            return i;
        }
        return -1;
    }

    private static class NullIcon
    implements Icon {
        private NullIcon() {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

