/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.actions.JPDADebuggerAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public class MakeCallerCurrentActionProvider
extends JPDADebuggerAction {
    private RequestProcessor rp;

    public MakeCallerCurrentActionProvider(ContextProvider contextProvider) {
        super((JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.rp = (RequestProcessor)contextProvider.lookupFirst(null, RequestProcessor.class);
        this.getDebuggerImpl().addPropertyChangeListener("currentCallStackFrame", (PropertyChangeListener)this);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
    }

    public void doAction(Object object) {
        JPDAThread jPDAThread = this.getDebuggerImpl().getCurrentThread();
        if (jPDAThread == null) {
            return;
        }
        int n = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.getDebuggerImpl());
        if (n >= jPDAThread.getStackDepth() - 1) {
            return;
        }
        MakeCallerCurrentActionProvider.setCurrentCallStackFrameIndex(this.getDebuggerImpl(), ++n);
    }

    protected void checkEnabled(int n) {
        JPDAThread jPDAThread;
        this.getDebuggerImpl();
        if (n == 3 && (jPDAThread = this.getDebuggerImpl().getCurrentThread()) != null) {
            this.checkEnabledLazySingleAction(n, this.rp);
            return;
        }
        this.setEnabledSingleAction(false);
    }

    protected boolean checkEnabledLazyImpl(int n) {
        int n2 = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.getDebuggerImpl());
        JPDAThread jPDAThread = this.getDebuggerImpl().getCurrentThread();
        if (jPDAThread == null) {
            return false;
        }
        return n2 < jPDAThread.getStackDepth() - 1;
    }

    static int getCurrentCallStackFrameIndex(JPDADebugger jPDADebugger) {
        try {
            JPDAThread jPDAThread = jPDADebugger.getCurrentThread();
            if (jPDAThread == null) {
                return -1;
            }
            CallStackFrame callStackFrame = jPDADebugger.getCurrentCallStackFrame();
            if (callStackFrame == null) {
                return -1;
            }
            CallStackFrame[] callStackFrameArray = jPDAThread.getCallStack();
            int n = callStackFrameArray.length;
            for (int i = 0; i < n; ++i) {
                if (!callStackFrame.equals(callStackFrameArray[i])) continue;
                return i;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return -1;
    }

    static void setCurrentCallStackFrameIndex(JPDADebugger jPDADebugger, int n) {
        try {
            JPDAThread jPDAThread = jPDADebugger.getCurrentThread();
            if (jPDAThread == null) {
                return;
            }
            if (jPDAThread.getStackDepth() <= n) {
                return;
            }
            CallStackFrame callStackFrame = jPDAThread.getCallStack(n, n + 1)[0];
            callStackFrame.makeCurrent();
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }
}

