/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.FilteredKeymap;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class WatchPanel {
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    public static void setupContext(final JEditorPane jEditorPane, final ActionListener actionListener) {
        Context context;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (EventQueue.isDispatchThread() && debuggerEngine != null) {
            context = (RequestProcessor)debuggerEngine.lookupFirst(null, RequestProcessor.class);
            if (context != null) {
                final DebuggerEngine debuggerEngine2 = debuggerEngine;
                context.post(new Runnable(){

                    public void run() {
                        final Context context = WatchPanel.retrieveContext(debuggerEngine2);
                        if (context != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    WatchPanel.setupContext(jEditorPane, context.url, context.line);
                                    if (actionListener != null) {
                                        actionListener.actionPerformed(null);
                                    }
                                }
                            });
                        }
                    }
                });
                Context context2 = WatchPanel.retrieveContext(null);
                if (context2 != null) {
                    WatchPanel.setupContext(jEditorPane, context2.url, context2.line);
                } else {
                    WatchPanel.setupUI(jEditorPane);
                }
                return;
            }
            debuggerEngine = null;
        }
        if ((context = WatchPanel.retrieveContext(debuggerEngine)) != null) {
            WatchPanel.setupContext(jEditorPane, context.url, context.line);
        } else {
            WatchPanel.setupUI(jEditorPane);
        }
        if (actionListener != null) {
            actionListener.actionPerformed(null);
        }
    }

    private static Context retrieveContext(DebuggerEngine debuggerEngine) {
        Object object;
        CallStackFrame callStackFrame = null;
        if (debuggerEngine != null && (object = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class)) != null) {
            callStackFrame = object.getCurrentCallStackFrame();
        }
        if (callStackFrame != null) {
            object = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
            SourcePath sourcePath = (SourcePath)debuggerEngine.lookupFirst(null, SourcePath.class);
            Context context = new Context();
            context.url = sourcePath.getURL(callStackFrame, (String)object);
            context.line = callStackFrame.getLineNumber((String)object);
            return context;
        }
        object = EditorContextBridge.getContext();
        String string = object.getCurrentURL();
        if (string != null && string.length() > 0) {
            Context context = new Context();
            context.url = string;
            context.line = object.getCurrentLineNumber();
            if (context.line == -1) {
                context.line = 1;
            }
            return context;
        }
        string = EditorContextDispatcher.getDefault().getMostRecentURLAsString();
        if (string != null && string.length() > 0) {
            Context context = new Context();
            context.url = string;
            context.line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
            if (context.line == -1) {
                context.line = 1;
            }
            return context;
        }
        return null;
    }

    public static void setupContext(JEditorPane jEditorPane, String string, int n) {
        StyledDocument styledDocument;
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (fileObject == null) {
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
            DialogBinding.bindComponentToDocument((Document)styledDocument, (int)n2, (int)0, (JTextComponent)jEditorPane);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
        }
        WatchPanel.setupUI(jEditorPane);
    }

    private static void setupUI(final JEditorPane jEditorPane) {
        Runnable runnable = new Runnable(){

            public void run() {
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jEditorPane);
                if (editorUI == null) {
                    return;
                }
                editorUI.removeLayer("highlight-row-layer");
                try {
                    Field field = EditorUI.class.getDeclaredField("textLimitLineVisible");
                    field.setAccessible(true);
                    field.set(editorUI, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public JComponent getPanel() {
        Object object;
        String string;
        Object object2;
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_Watch_Name"));
        if (this.expression != null && this.expression.trim().length() == 0 && (object2 = EditorContextDispatcher.getDefault().getMostRecentEditor()) != null && ((JTextComponent)object2).getDocument() instanceof StyledDocument && (string = WatchPanel.getSelectedIdentifier((StyledDocument)(object = (StyledDocument)((JTextComponent)object2).getDocument()), (JEditorPane)object2, ((JTextComponent)object2).getCaret().getDot())) != null) {
            this.expression = string;
        }
        this.editorPane = new JEditorPane();
        this.editorPane.setText(this.expression);
        object2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WatchPanel.this.editorPane.setText(WatchPanel.this.expression);
                WatchPanel.this.editorPane.selectAll();
            }
        };
        WatchPanel.setupContext(this.editorPane, (ActionListener)object2);
        object = WatchPanel.createScrollableLineEditor(this.editorPane);
        int n = ((JComponent)object).getPreferredSize().height;
        int n2 = Math.min(70 * this.editorPane.getFontMetrics(this.editorPane.getFont()).charWidth('a'), WindowManager.getDefault().getMainWindow().getSize().width);
        ((JComponent)object).setPreferredSize(new Dimension(n2, n));
        FontMetrics fontMetrics = this.editorPane.getFontMetrics(this.editorPane.getFont());
        int n3 = 2 * fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        Insets insets = this.editorPane.getInsets();
        Insets insets2 = ((JComponent)object).getInsets();
        ((JComponent)object).setPreferredSize(new Dimension(30 * n3, n3 + insets.bottom + insets.top + insets2.bottom + insets2.top));
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.panel.add("Center", (Component)object);
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        HelpCtx.setHelpIDString((JComponent)this.editorPane, (String)"debug.customize.watch");
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    public static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        jEditorPane.setKeymap(new FilteredKeymap(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField("M");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(jTextField.getBackground());
        jScrollPane.setBorder(jTextField.getBorder());
        jScrollPane.setBackground(jTextField.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        jScrollPane.setViewportView(jPanel);
        int n = jTextField.getPreferredSize().height;
        if (jScrollPane.getPreferredSize().height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        }
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        WatchPanel.setupUI(jEditorPane);
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }

    private static String getSelectedIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static final class Context {
        public String url;
        public int line;

        private Context() {
        }
    }
}

