/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryPanel
extends JPanel {
    private transient HistoryTableModel historyModel = new HistoryTableModel();
    private HistoryTable historyTable = new HistoryTable();
    private JLabel historyLabel;
    private JPanel separatorPanel;

    HistoryPanel() {
        this.initComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        JTableHeader jTableHeader = this.historyTable.getTableHeader();
        jTableHeader.setFocusable(false);
        this.add((Component)jTableHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.historyTable, gridBagConstraints);
        this.historyTable.setModel(this.historyModel);
    }

    public void addItem(final String string, final String string2, final String string3, final String string4) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HistoryPanel.this.historyModel.addItem(string, string2, string3, string4);
            }
        });
    }

    public void clearHistory() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HistoryPanel.this.historyModel.clearHistory();
            }
        });
    }

    public ArrayList<Item> getHistoryItems() {
        return this.historyModel.getHistory();
    }

    private void initComponents() {
        this.historyLabel = new JLabel();
        this.separatorPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.historyLabel.setText(NbBundle.getMessage(HistoryPanel.class, (String)"HistoryPanel.historyLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.historyLabel, gridBagConstraints);
        this.separatorPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        this.separatorPanel.setPreferredSize(new Dimension(10, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.separatorPanel, gridBagConstraints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HistoryTableModel
    extends DefaultTableModel {
        private static final int MAX_ITEMS = 100;
        private ArrayList<Item> historyItems = new ArrayList();

        HistoryTableModel() {
        }

        private void addItem(String string, String string2, String string3, String string4) {
            Item item = new Item(string, string2, string3, string4);
            this.historyItems.add(0, item);
            if (this.historyItems.size() > 100) {
                this.historyItems.remove(100);
            }
            this.fireTableDataChanged();
        }

        public ArrayList<Item> getHistory() {
            return this.historyItems;
        }

        public void clearHistory() {
            this.historyItems.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.historyItems == null) {
                this.historyItems = new ArrayList();
            }
            return this.historyItems.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "CTL_Expression";
                    break;
                }
                case 1: {
                    string = "CTL_Type";
                    break;
                }
                case 2: {
                    string = "CTL_Value";
                }
            }
            return NbBundle.getMessage(HistoryPanel.class, (String)string);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= this.historyItems.size()) {
                return "<???>";
            }
            Item item = this.historyItems.get(n);
            switch (n2) {
                case 0: {
                    return item.expr;
                }
                case 1: {
                    return item.type;
                }
                case 2: {
                    return item.value;
                }
            }
            return "<???>";
        }
    }

    class HistoryTable
    extends JTable {
        HistoryTable() {
            this.setBackground(UIManager.getDefaults().getColor("Button.background"));
            this.setGridColor(UIManager.getDefaults().getColor("Button.light"));
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            if (n < 0 || n2 < 0) {
                return super.getToolTipText(mouseEvent);
            }
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 < 0) {
                return super.getToolTipText(mouseEvent);
            }
            TableModel tableModel = this.getModel();
            String string = (String)tableModel.getValueAt(n, n3);
            string = string.replace("\n", "<br/>");
            return "<html>" + string + "</html>";
        }
    }

    public class Item {
        public String expr;
        public String type;
        public String value;
        public String toString;
        public String tooltip;
        public String exprFormatted;

        Item(String string, String string2, String string3, String string4) {
            this.expr = string;
            this.type = string2;
            this.value = string3;
            this.toString = string4;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            String string5 = string.replaceAll("&", "&amp;");
            string5 = string5.replaceAll("<", "&lt;");
            string5 = string5.replaceAll(">", "&gt;");
            string5 = string5.replaceAll("\n", "<br/>");
            string5 = string5.replaceAll("\r", "");
            stringBuffer.append(string5);
            stringBuffer.append("</html>");
            this.tooltip = stringBuffer.toString();
        }

        Vector toVector() {
            Vector<String> vector = new Vector<String>();
            vector.add(this.expr);
            vector.add(this.type);
            vector.add(this.value);
            vector.add(this.toString);
            return vector;
        }

        public String toString() {
            return this.expr;
        }
    }
}

