/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.DependencyGraphScene;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixVersionConflictPanel
extends JPanel {
    private DependencyGraphScene scene;
    private ArtifactGraphNode conflictNode;
    private List<ArtifactVersion> clashingVersions;
    private ExclusionTargets eTargets;
    private JCheckBox addSetCheck;
    private JPanel addSetP;
    private JLabel conflictL;
    private JCheckBox excludeCheck;
    private JPanel excludeP;
    private JList excludesList;
    private JLabel fixPossibL;
    private JPanel fixesP;
    private JLabel fromDirectL;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel sumContent;
    private JLabel summaryL;
    private JLabel versionL;
    private JList versionList;

    public FixVersionConflictPanel(DependencyGraphScene dependencyGraphScene, ArtifactGraphNode artifactGraphNode) {
        this.scene = dependencyGraphScene;
        this.conflictNode = artifactGraphNode;
        this.initComponents();
        ExclTargetRenderer exclTargetRenderer = new ExclTargetRenderer(this.excludesList, this);
        this.excludesList.setCellRenderer(exclTargetRenderer);
        this.excludesList.addMouseListener(exclTargetRenderer);
        this.excludesList.addKeyListener(exclTargetRenderer);
        this.eTargets = new ExclusionTargets(this.conflictNode, this.getClashingVersions().get(0));
        this.visualizeRecommandations(this.computeRecommandations());
    }

    FixDescription getResult() {
        FixDescription fixDescription = new FixDescription();
        fixDescription.isSet = this.addSetCheck.isSelected();
        fixDescription.version2Set = fixDescription.isSet ? (ArtifactVersion)this.versionList.getSelectedValue() : null;
        fixDescription.isExclude = this.excludeCheck.isSelected();
        if (fixDescription.isExclude) {
            fixDescription.exclusionTargets = new HashSet<Artifact>();
            fixDescription.conflictParents = new HashSet<DependencyNode>();
            ListModel listModel = this.excludesList.getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                ExclTargetEntry exclTargetEntry = (ExclTargetEntry)listModel.getElementAt(i);
                if (!exclTargetEntry.isSelected) continue;
                fixDescription.exclusionTargets.add(exclTargetEntry.artif);
                fixDescription.conflictParents.addAll(this.eTargets.getConflictParents(exclTargetEntry.artif));
            }
        }
        return fixDescription;
    }

    private void addSetCheckChanged() {
        boolean bl = this.addSetCheck.isSelected();
        this.versionL.setEnabled(bl);
        this.versionList.setEnabled(bl);
        if (bl && this.versionList.getSelectedValue() == null) {
            this.versionList.setSelectedIndex(0);
        }
    }

    private void excludeCheckChanged() {
        boolean bl = this.excludeCheck.isSelected();
        this.fromDirectL.setEnabled(bl);
        this.excludesList.setEnabled(bl);
    }

    private String getClashingVersionsAsText() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (ArtifactVersion artifactVersion : this.getClashingVersions()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(artifactVersion.toString());
        }
        return stringBuilder.toString();
    }

    private List<ArtifactVersion> getClashingVersions() {
        if (this.clashingVersions == null) {
            this.clashingVersions = new ArrayList<ArtifactVersion>();
            this.clashingVersions.add((ArtifactVersion)new DefaultArtifactVersion(this.conflictNode.getArtifact().getArtifact().getVersion()));
            Set<DependencyNode> set = this.conflictNode.getDuplicatesOrConflicts();
            DefaultArtifactVersion defaultArtifactVersion = null;
            for (DependencyNode dependencyNode : set) {
                if (dependencyNode.getState() != 2 || this.clashingVersions.contains(defaultArtifactVersion = new DefaultArtifactVersion(dependencyNode.getArtifact().getVersion()))) continue;
                this.clashingVersions.add((ArtifactVersion)defaultArtifactVersion);
            }
            Collections.sort(this.clashingVersions);
            Collections.reverse(this.clashingVersions);
        }
        return this.clashingVersions;
    }

    private FixDescription computeRecommandations() {
        Set<Artifact> set;
        FixDescription fixDescription = new FixDescription();
        boolean bl = this.conflictNode.getPrimaryLevel() == 1;
        DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(this.conflictNode.getArtifact().getArtifact().getVersion());
        ArtifactVersion artifactVersion = this.getClashingVersions().get(0);
        if (bl && defaultArtifactVersion.compareTo((Object)artifactVersion) < 0) {
            fixDescription.isSet = true;
            fixDescription.version2Set = artifactVersion;
        }
        if (!(set = this.eTargets.getNonConflicting()).isEmpty() && this.eTargets.getAll().size() > 1) {
            fixDescription.isExclude = true;
            fixDescription.exclusionTargets = this.eTargets.getConflicting();
        }
        if (!fixDescription.isSet && !fixDescription.isExclude && defaultArtifactVersion.compareTo((Object)artifactVersion) < 0) {
            fixDescription.isSet = true;
            fixDescription.version2Set = artifactVersion;
            fixDescription.isExclude = true;
            fixDescription.exclusionTargets = this.eTargets.getAll();
        }
        return fixDescription;
    }

    private void visualizeRecommandations(FixDescription fixDescription) {
        this.addSetCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.addSetCheck.text", (Object)this.getSetText()));
        this.addSetCheck.setSelected(fixDescription.isSet);
        this.addSetCheckChanged();
        List<ArtifactVersion> list = this.getClashingVersions();
        DefaultListModel<ArtifactVersion> defaultListModel = new DefaultListModel<ArtifactVersion>();
        for (ArtifactVersion object : list) {
            defaultListModel.addElement(object);
        }
        this.versionList.setModel(defaultListModel);
        this.versionList.setSelectedIndex(0);
        if (fixDescription.version2Set != null) {
            this.versionList.setSelectedValue(fixDescription.version2Set, true);
        }
        this.excludeCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.excludeCheck.text"));
        this.excludeCheck.setSelected(fixDescription.isExclude);
        this.excludeCheckChanged();
        Set<Artifact> set = this.eTargets.getAll();
        if (!set.isEmpty()) {
            DefaultListModel<ExclTargetEntry> defaultListModel2 = new DefaultListModel<ExclTargetEntry>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                defaultListModel2.addElement(new ExclTargetEntry(artifact, fixDescription.exclusionTargets != null && fixDescription.exclusionTargets.contains(artifact)));
            }
            this.excludesList.setModel(defaultListModel2);
        } else {
            this.excludeCheck.setEnabled(false);
        }
        this.updateSummary();
    }

    private String getSetText() {
        return this.conflictNode.getPrimaryLevel() == 1 ? NbBundle.getMessage(FixVersionConflictPanel.class, (String)"LBL_SetDep") : NbBundle.getMessage(FixVersionConflictPanel.class, (String)"LBL_AddDep");
    }

    private void updateSummary() {
        FixDescription fixDescription = this.getResult();
        String string = "";
        String string2 = "";
        if (fixDescription.isSet && fixDescription.version2Set != null) {
            string = NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumPart1.text", (Object)this.getSetText(), (Object)fixDescription.version2Set.toString(), (Object)this.conflictNode.getArtifact().getArtifact().getArtifactId());
        }
        if (fixDescription.isExclude && !fixDescription.exclusionTargets.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (Artifact artifact : fixDescription.exclusionTargets) {
                if (!bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = false;
                }
                stringBuilder.append(artifact.getArtifactId());
            }
            string2 = NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumPart2.text", (Object)this.conflictNode.getArtifact().getArtifact().getArtifactId(), (Object)stringBuilder.toString());
        }
        if (string.equals("") && string2.equals("")) {
            string = NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.noChanges");
        }
        if (!string.equals("") && !string2.equals("")) {
            string = string + " ";
        }
        this.sumContent.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumContent.text", (Object)string, (Object)string2));
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.fixesP = new JPanel();
        this.addSetP = new JPanel();
        this.addSetCheck = new JCheckBox();
        this.versionL = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.versionList = new JList();
        this.excludeP = new JPanel();
        this.excludeCheck = new JCheckBox();
        this.fromDirectL = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.excludesList = new JList();
        this.fixPossibL = new JLabel();
        this.summaryL = new JLabel();
        this.jPanel1 = new JPanel();
        this.sumContent = new JLabel();
        this.jPanel2 = new JPanel();
        this.conflictL = new JLabel();
        this.addSetCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.addSetCheck.text"));
        this.addSetCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FixVersionConflictPanel.this.addSetCheckActionPerformed(actionEvent);
            }
        });
        this.versionL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.versionL.text"));
        this.versionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FixVersionConflictPanel.this.versionListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.versionList);
        GroupLayout groupLayout = new GroupLayout((Container)this.addSetP);
        this.addSetP.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addSetCheck).add((Component)this.versionL)).add(46, 46, 46)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 208, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addSetCheck).addPreferredGap(0).add((Component)this.versionL).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 156, Short.MAX_VALUE).addContainerGap()));
        this.excludeCheck.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.excludeCheck.text"));
        this.excludeCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FixVersionConflictPanel.this.excludeCheckActionPerformed(actionEvent);
            }
        });
        this.fromDirectL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.fromDirectL.text"));
        this.jScrollPane2.setViewportView(this.excludesList);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.excludeP);
        this.excludeP.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.excludeCheck).add((Component)this.fromDirectL)).addContainerGap(46, Short.MAX_VALUE)).add((Component)this.jScrollPane2, -1, 268, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.excludeCheck).addPreferredGap(0).add((Component)this.fromDirectL).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 156, Short.MAX_VALUE).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.fixesP);
        this.fixesP.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.addSetP, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.excludeP, -1, -1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.addSetP, -1, -1, Short.MAX_VALUE).add((Component)this.excludeP, -1, -1, Short.MAX_VALUE));
        this.fixPossibL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.fixPossibL.text"));
        this.summaryL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.summaryL.text"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.sumContent.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.sumContent.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sumContent, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.conflictL.setText(NbBundle.getMessage(FixVersionConflictPanel.class, (String)"FixVersionConflictPanel.conflictL.text", (Object[])new Object[]{this.conflictNode.getArtifact().getArtifact().getArtifactId(), this.getClashingVersionsAsText()}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.conflictL, gridBagConstraints);
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.summaryL).add((Component)this.fixPossibL).add(2, (GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, 494, Short.MAX_VALUE).add((Component)this.jPanel2, -1, 494, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 494, Short.MAX_VALUE).add(1, (Component)this.fixesP, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 14, -2).addPreferredGap(0).add((Component)this.fixPossibL).addPreferredGap(0).add((Component)this.fixesP, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.summaryL).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap()));
    }

    private void excludeCheckActionPerformed(ActionEvent actionEvent) {
        this.excludeCheckChanged();
        this.updateSummary();
    }

    private void addSetCheckActionPerformed(ActionEvent actionEvent) {
        this.addSetCheckChanged();
        this.updateSummary();
    }

    private void versionListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateSummary();
    }

    private static class ExclTargetRenderer
    extends JCheckBox
    implements ListCellRenderer,
    MouseListener,
    KeyListener {
        private JList parentList;
        private FixVersionConflictPanel parentPanel;

        public ExclTargetRenderer(JList jList, FixVersionConflictPanel fixVersionConflictPanel) {
            this.parentList = jList;
            this.parentPanel = fixVersionConflictPanel;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ExclTargetEntry exclTargetEntry = (ExclTargetEntry)object;
            this.setText(exclTargetEntry.artif.getArtifactId());
            this.setSelected(exclTargetEntry.isSelected);
            this.setEnabled(jList.isEnabled());
            this.setOpaque(bl && jList.isEnabled());
            if (bl && jList.isEnabled()) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.parentList.locationToIndex(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            Rectangle rectangle = this.parentList.getCellBounds(n, n);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.doCheck();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32) {
                this.doCheck();
            }
        }

        private void doCheck() {
            int n = this.parentList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            ExclTargetEntry exclTargetEntry = (ExclTargetEntry)this.parentList.getModel().getElementAt(n);
            exclTargetEntry.isSelected = !exclTargetEntry.isSelected;
            this.parentList.repaint();
            this.parentPanel.updateSummary();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private static class ExclTargetEntry {
        Artifact artif;
        boolean isSelected = false;

        public ExclTargetEntry(Artifact artifact, boolean bl) {
            this.artif = artifact;
            this.isSelected = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExclusionTargets {
        Map<Artifact, Set<ArtifactVersion>> targets2Versions;
        Map<Artifact, Set<DependencyNode>> targets2ConfPar;
        ArtifactGraphNode conflictNode;
        ArtifactVersion usedVersion;
        ArtifactVersion newestVersion;

        public ExclusionTargets(ArtifactGraphNode artifactGraphNode, ArtifactVersion artifactVersion) {
            this.conflictNode = artifactGraphNode;
            this.newestVersion = artifactVersion;
            this.usedVersion = new DefaultArtifactVersion(artifactGraphNode.getArtifact().getArtifact().getVersion());
            this.initialize();
        }

        private void initialize() {
            this.targets2Versions = new HashMap<Artifact, Set<ArtifactVersion>>();
            this.targets2ConfPar = new HashMap<Artifact, Set<DependencyNode>>();
            DependencyNode dependencyNode = null;
            DependencyNode dependencyNode2 = null;
            ArrayList<DependencyNode> arrayList = new ArrayList<DependencyNode>(this.conflictNode.getDuplicatesOrConflicts());
            if (this.conflictNode.getPrimaryLevel() > 1) {
                arrayList.add(this.conflictNode.getArtifact());
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DependencyNode dependencyNode3;
                dependencyNode = dependencyNode3 = (DependencyNode)iterator.next();
                dependencyNode2 = dependencyNode.getParent();
                while (dependencyNode2.getParent() != null) {
                    dependencyNode2 = dependencyNode2.getParent();
                    dependencyNode = dependencyNode.getParent();
                }
                Set<DependencyNode> set = this.targets2ConfPar.get(dependencyNode.getArtifact());
                if (set == null) {
                    set = new HashSet<DependencyNode>();
                    this.targets2ConfPar.put(dependencyNode.getArtifact(), set);
                }
                set.add(dependencyNode3.getParent());
                Set<ArtifactVersion> set2 = this.targets2Versions.get(dependencyNode.getArtifact());
                if (set2 == null) {
                    set2 = new HashSet<ArtifactVersion>();
                    this.targets2Versions.put(dependencyNode.getArtifact(), set2);
                }
                set2.add((ArtifactVersion)new DefaultArtifactVersion(dependencyNode3.getArtifact().getVersion()));
            }
        }

        public Set<Artifact> getAll() {
            return this.targets2Versions.keySet();
        }

        public Set<Artifact> getNonConflicting() {
            HashSet<Artifact> hashSet = new HashSet<Artifact>();
            for (Artifact artifact : this.getAll()) {
                if (!this.isNonConflicting(artifact)) continue;
                hashSet.add(artifact);
            }
            return hashSet;
        }

        public Set<Artifact> getConflicting() {
            HashSet<Artifact> hashSet = new HashSet<Artifact>();
            for (Artifact artifact : this.getAll()) {
                if (this.isNonConflicting(artifact)) continue;
                hashSet.add(artifact);
            }
            return hashSet;
        }

        public boolean isNonConflicting(Artifact artifact) {
            Set<ArtifactVersion> set = this.targets2Versions.get(artifact);
            return set != null && set.size() == 1 && this.newestVersion.equals(set.iterator().next());
        }

        public Set<DependencyNode> getConflictParents(Artifact artifact) {
            return this.targets2ConfPar.get(artifact);
        }
    }

    static class FixDescription {
        boolean isSet = false;
        boolean isExclude = false;
        ArtifactVersion version2Set = null;
        Set<Artifact> exclusionTargets = null;
        Set<DependencyNode> conflictParents = null;

        FixDescription() {
        }
    }
}

