/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Scene;

class CenteredZoomAnimator
extends Animator {
    private double sourceZoom;
    private double targetZoom;
    private Point center;
    private Point sceneCenter;

    public CenteredZoomAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setZoomFactor(double d, Point point) {
        this.sourceZoom = this.getScene().getZoomFactor();
        this.targetZoom = d;
        this.center = point;
        Rectangle rectangle = this.getScene().getBounds();
        this.sceneCenter = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
        this.start();
    }

    public double getTargetZoom() {
        return this.targetZoom;
    }

    public Point getCenter() {
        return this.center;
    }

    public void tick(double d) {
        double d2 = d >= 1.0 ? this.targetZoom : this.sourceZoom + d * (this.targetZoom - this.sourceZoom);
        Scene scene = this.getScene();
        JComponent jComponent = scene.getView();
        if (jComponent != null) {
            Point point = jComponent.getVisibleRect().getLocation();
            Dimension dimension = jComponent.getVisibleRect().getSize();
            Point point2 = scene.convertSceneToView(this.center);
            scene.setZoomFactor(d2);
            scene.validate();
            Point point3 = scene.convertSceneToView(this.center);
            Rectangle rectangle = jComponent.getVisibleRect();
            Point point4 = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
            point3.x = (int)((long)point3.x + Math.round((double)(point3.x - point4.x) * d));
            point3.y = (int)((long)point3.y + Math.round((double)(point3.y - point4.y) * d));
            jComponent.scrollRectToVisible(new Rectangle(point3.x - point2.x + point.x, point3.y - point2.y + point.y, dimension.width, dimension.height));
        } else {
            scene.setZoomFactor(d2);
        }
    }
}

