/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.impl.MethodCustomizerPanel;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatingPropertyChangeListener
implements PropertyChangeListener {
    private final MethodCustomizerPanel panel;
    private final NotifyDescriptor notifyDescriptor;
    private final NotificationLineSupport statusLine;
    private final boolean checkInterfaces;
    private final Collection<MethodModel> existingMethods;
    private final Set<String> existingMethodsNames;

    public ValidatingPropertyChangeListener(MethodCustomizerPanel methodCustomizerPanel, NotifyDescriptor notifyDescriptor, Collection<MethodModel> collection) {
        this.panel = methodCustomizerPanel;
        this.notifyDescriptor = notifyDescriptor;
        this.statusLine = notifyDescriptor.createNotificationLineSupport();
        this.checkInterfaces = methodCustomizerPanel.supportsInterfacesChecking();
        this.existingMethods = collection;
        this.existingMethodsNames = new HashSet<String>();
        for (MethodModel methodModel : collection) {
            this.existingMethodsNames.add(methodModel.getName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.validate();
    }

    protected boolean validate() {
        this.statusLine.clearMessages();
        this.notifyDescriptor.setValid(false);
        String string = this.panel.getMethodName();
        if (!Utilities.isJavaIdentifier((String)string)) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_nameNonJavaIdentifier"));
            return false;
        }
        String string2 = this.panel.getReturnType();
        if ("".equals(string2)) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_returnTypeInvalid"));
            return false;
        }
        if (this.checkInterfaces) {
            boolean bl = this.panel.hasLocal();
            boolean bl2 = this.panel.hasRemote();
            if (!bl && !bl2) {
                this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_selectSomeInterface"));
                return false;
            }
            if (bl && bl2) {
                this.statusLine.setWarningMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"LBL_commonImplForBothInterfaces"));
            }
        }
        if (this.existingMethodsNames.contains(string)) {
            List<MethodModel.Variable> list = this.panel.getParameters();
            for (MethodModel object : this.existingMethods) {
                if (!this.sameParams(list, object.getParameters())) continue;
                this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_methodExists"));
                return false;
            }
        }
        List<MethodModel.Variable> list = this.panel.getParameters();
        for (MethodModel.Variable variable : list) {
            String string3 = variable.getName();
            int n = 0;
            for (MethodModel.Variable variable2 : list) {
                if (!string3.equals(variable2.getName())) continue;
                ++n;
            }
            if (n <= true) continue;
            this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_duplicateParameterName", (Object)string3));
            return false;
        }
        this.notifyDescriptor.setValid(true);
        return true;
    }

    private boolean sameParams(List<MethodModel.Variable> list, List<MethodModel.Variable> list2) {
        if (list2.size() == list.size()) {
            for (int i = 0; i < list2.size(); ++i) {
                String string = list2.get(i).getType();
                String string2 = list.get(i).getType();
                int n = string.lastIndexOf(46);
                int n2 = string2.lastIndexOf(46);
                if (n == -1 && n2 != -1) {
                    string2 = string2.substring(n2 + 1);
                } else if (n != -1 && n2 == -1) {
                    string = string.substring(n + 1);
                }
                if (string.equals(string2)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

