/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.AntBasedGenericType;
import org.netbeans.modules.project.ant.ProjectXMLCatalogReader;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AntBasedProjectFactorySingleton
implements ProjectFactory2 {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final Map<Project, Reference<AntProjectHelper>> project2Helper;
    private static final Map<AntProjectHelper, Reference<Project>> helper2Project;
    private static final Map<AntBasedProjectType, List<Reference<AntProjectHelper>>> type2Projects;
    private static final Lookup.Result<AntBasedProjectType> antBasedProjectTypes;
    private static Map<String, AntBasedProjectType> antBasedProjectTypesByType;
    public static AntProjectHelperCallback HELPER_CALLBACK;

    private static void antBasedProjectTypesRemoved(Set<AntBasedProjectType> set) {
        for (AntBasedProjectType antBasedProjectType : set) {
            List<Reference<AntProjectHelper>> list = type2Projects.get(antBasedProjectType);
            if (list != null) {
                for (Reference<AntProjectHelper> reference : list) {
                    AntProjectHelper antProjectHelper = reference.get();
                    if (antProjectHelper == null) continue;
                    antProjectHelper.notifyDeleted();
                }
            }
            type2Projects.remove(antBasedProjectType);
        }
    }

    private static synchronized AntBasedProjectType findAntBasedProjectType(String string) {
        if (antBasedProjectTypesByType == null) {
            antBasedProjectTypesByType = new HashMap<String, AntBasedProjectType>();
            for (AntBasedProjectType antBasedProjectType : antBasedProjectTypes.allInstances()) {
                antBasedProjectTypesByType.put(antBasedProjectType.getType(), antBasedProjectType);
            }
        }
        return antBasedProjectTypesByType.get(string);
    }

    public boolean isProject(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return false;
        }
        File file2 = new File(new File(file, "nbproject"), "project.xml");
        return file2.isFile();
    }

    public ProjectManager.Result isProject2(FileObject fileObject) {
        if (FileUtil.toFile((FileObject)fileObject) == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(PROJECT_XML_PATH);
        if (fileObject2 == null || !fileObject2.isData() || fileObject2.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            return null;
        }
        try {
            AntBasedProjectType antBasedProjectType;
            String string;
            Element element;
            Document document = this.loadProjectXml(file);
            if (document != null && (element = Util.findElement(document.getDocumentElement(), "type", PROJECT_NS)) != null && (string = Util.findText(element)) != null && (antBasedProjectType = AntBasedProjectFactorySingleton.findAntBasedProjectType(string)) != null) {
                if (antBasedProjectType instanceof AntBasedGenericType) {
                    return new ProjectManager.Result(((AntBasedGenericType)antBasedProjectType).getIcon());
                }
                return new ProjectManager.Result(null);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(AntBasedProjectFactorySingleton.class.getName()).log(Level.FINE, "Failed to load the project.xml file.", iOException);
        }
        return new ProjectManager.Result(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project loadProject(FileObject fileObject, ProjectState projectState) throws IOException {
        if (FileUtil.toFile((FileObject)fileObject) == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(PROJECT_XML_PATH);
        if (fileObject2 == null || !fileObject2.isData() || fileObject2.isVirtual()) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject2);
        if (file == null) {
            return null;
        }
        Document document = this.loadProjectXml(file);
        if (document == null) {
            return null;
        }
        Element element = Util.findElement(document.getDocumentElement(), "type", PROJECT_NS);
        if (element == null) {
            return null;
        }
        String string = Util.findText(element);
        if (string == null) {
            return null;
        }
        AntBasedProjectType antBasedProjectType = AntBasedProjectFactorySingleton.findAntBasedProjectType(string);
        if (antBasedProjectType == null) {
            return null;
        }
        AntProjectHelper antProjectHelper = HELPER_CALLBACK.createHelper(fileObject, document, projectState, antBasedProjectType);
        Project project = antBasedProjectType.createProject(antProjectHelper);
        project2Helper.put(project, new WeakReference<AntProjectHelper>(antProjectHelper));
        ArrayList<WeakReference<AntProjectHelper>> arrayList = helper2Project;
        synchronized (arrayList) {
            helper2Project.put(antProjectHelper, new WeakReference<Project>(project));
        }
        arrayList = type2Projects.get(antBasedProjectType);
        if (arrayList == null) {
            arrayList = new ArrayList<WeakReference<AntProjectHelper>>();
            type2Projects.put(antBasedProjectType, arrayList);
        }
        arrayList.add(new WeakReference<AntProjectHelper>(antProjectHelper));
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadProjectXml(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileUtil.copy((InputStream)fileInputStream, (OutputStream)byteArrayOutputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
        inputSource.setSystemId(file.toURI().toString());
        try {
            Document document;
            block19: {
                document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)true, (ErrorHandler)Util.defaultErrorHandler(), null);
                Element element = document.getDocumentElement();
                if (!"project".equals(element.getLocalName()) || !PROJECT_NS.equals(element.getNamespaceURI())) {
                    return null;
                }
                Preferences preferences = NbPreferences.forModule(AntBasedProjectFactorySingleton.class);
                String string = "knownValidProjectXmlCRC32s";
                ArrayList<Long> arrayList = new ArrayList<Long>();
                String string2 = preferences.get(string, null);
                if (string2 != null) {
                    for (String object : string2.split(",")) {
                        try {
                            arrayList.add(Long.valueOf(object, 16));
                        }
                        catch (NumberFormatException i) {
                            // empty catch block
                        }
                    }
                }
                CRC32 cRC32 = new CRC32();
                cRC32.update(byArray);
                long l = cRC32.getValue();
                if (!arrayList.contains(l)) {
                    Logger.getLogger(AntBasedProjectFactorySingleton.class.getName()).log(Level.FINE, "Validating: {0}", file);
                    try {
                        ProjectXMLCatalogReader.validate(element);
                        StringBuilder sAXException = new StringBuilder(Long.toString(l, 16));
                        for (int element2 = 0; element2 < arrayList.size() && element2 < 100; ++element2) {
                            sAXException.append(',');
                            sAXException.append(Long.toString((Long)arrayList.get(element2), 16));
                        }
                        preferences.put(string, sAXException.toString());
                    }
                    catch (SAXException sAXException) {
                        Element element2 = ProjectXMLCatalogReader.autocorrect(element, sAXException);
                        if (element2 != null) {
                            document.replaceChild(element2, element);
                            element = element2;
                            if (!file.canWrite()) break block19;
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            try {
                                XMLUtil.write((Document)document, (OutputStream)fileOutputStream, (String)"UTF-8");
                            }
                            finally {
                                ((OutputStream)fileOutputStream).close();
                            }
                        }
                        throw sAXException;
                    }
                }
            }
            return document;
        }
        catch (SAXException sAXException) {
            IOException iOException = (IOException)new IOException(file + ": " + sAXException.toString()).initCause(sAXException);
            String string = sAXException.getMessage().replaceFirst("^cvc-[^:]+: ", "").replaceAll("http://www.netbeans.org/ns/", ".../");
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(AntBasedProjectFactorySingleton.class, (String)"AntBasedProjectFactorySingleton.parseError", (Object)file.getName(), (Object)string));
            throw iOException;
        }
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference<AntProjectHelper> reference = project2Helper.get(project);
        if (reference == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(project.getClass().getName() + "\n");
            stringBuffer.append("argument project: " + project + " => " + project.hashCode() + "\n");
            stringBuffer.append("project2Helper keys: \n");
            for (Project project2 : project2Helper.keySet()) {
                stringBuffer.append("    project: " + project2 + " => " + project2.hashCode() + "\n");
            }
            throw new ClassCastException(stringBuffer.toString());
        }
        AntProjectHelper antProjectHelper = reference.get();
        assert (antProjectHelper != null) : "AntProjectHelper collected for " + project;
        HELPER_CALLBACK.save(antProjectHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project getProjectFor(AntProjectHelper antProjectHelper) {
        Reference<Project> reference;
        Project project = helper2Project;
        synchronized (project) {
            reference = helper2Project.get(antProjectHelper);
        }
        assert (reference != null) : "Expecting a Project reference for " + antProjectHelper;
        project = reference.get();
        assert (project != null) : "Expecting a non-null Project for " + antProjectHelper;
        return project;
    }

    public static AntProjectHelper getHelperFor(Project project) {
        Reference<AntProjectHelper> reference = project2Helper.get(project);
        return reference != null ? reference.get() : null;
    }

    public static AntBasedProjectType create(Map map) {
        return new AntBasedGenericType(map);
    }

    static {
        block3: {
            project2Helper = new WeakHashMap<Project, Reference<AntProjectHelper>>();
            helper2Project = new WeakHashMap<AntProjectHelper, Reference<Project>>();
            type2Projects = new HashMap<AntBasedProjectType, List<Reference<AntProjectHelper>>>();
            antBasedProjectTypesByType = null;
            antBasedProjectTypes = Lookup.getDefault().lookupResult(AntBasedProjectType.class);
            antBasedProjectTypes.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Class<AntBasedProjectFactorySingleton> clazz = AntBasedProjectFactorySingleton.class;
                    synchronized (AntBasedProjectFactorySingleton.class) {
                        Set set = type2Projects.keySet();
                        HashSet hashSet = new HashSet(set);
                        hashSet.removeAll(antBasedProjectTypes.allInstances());
                        AntBasedProjectFactorySingleton.antBasedProjectTypesRemoved(hashSet);
                        antBasedProjectTypesByType = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            Class<AntProjectHelper> clazz = AntProjectHelper.class;
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        assert (HELPER_CALLBACK != null);
    }

    public static interface AntProjectHelperCallback {
        public AntProjectHelper createHelper(FileObject var1, Document var2, ProjectState var3, AntBasedProjectType var4);

        public void save(AntProjectHelper var1) throws IOException;
    }
}

