/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.navigation.DocumentationScrollPane;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyIcons;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.JavaMembersModel;
import org.netbeans.modules.java.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.java.navigation.NoBorderToolBar;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JavaMembersPanel
extends JPanel {
    private static TreeModel pleaseWaitTreeModel;
    private FileObject fileObject;
    private JavaMembersModel javaMembersModel;
    private JavaMembersModel.FilterModel javaMembersFilterModel;
    private Component lastFocusedComponent;
    private DocumentationScrollPane docPane;
    public JCheckBox caseSensitiveFilterCheckBox;
    public JButton closeButton;
    public JLabel filterLabel;
    public JTextField filterTextField;
    public JLabel filtersLabel;
    public JToolBar filtersToolbar;
    public JTree javaMembersTree;
    public JScrollPane javaMembersTreeScrollPane;
    public JToggleButton showConstructorsToggleButton;
    public JToggleButton showEnumConstantsToggleButton;
    public JToggleButton showFQNToggleButton;
    public JToggleButton showFieldsToggleButton;
    public JToggleButton showInheritedToggleButton;
    public JToggleButton showInnerToggleButton;
    public JToggleButton showMethodsToggleButton;
    public JToggleButton showPackageToggleButton;
    public JToggleButton showPrivateToggleButton;
    public JToggleButton showProtectedToggleButton;
    public JToggleButton showStaticToggleButton;
    public JEditorPane signatureEditorPane;
    public JSplitPane splitPane;

    public JavaMembersPanel(FileObject fileObject, Element[] elementArray, CompilationInfo compilationInfo) {
        this.fileObject = fileObject;
        this.initComponents();
        this.docPane = new DocumentationScrollPane(true);
        this.splitPane.setRightComponent(this.docPane);
        this.splitPane.setDividerLocation(JavaMembersAndHierarchyOptions.getMembersDividerLocation());
        ToolTipManager.sharedInstance().registerComponent(this.javaMembersTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.caseSensitiveFilterCheckBox.setSelected(JavaMembersAndHierarchyOptions.isCaseSensitive());
        this.showInheritedToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowInherited());
        this.showFQNToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowFQN());
        this.showInnerToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowInner());
        this.showConstructorsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowConstructors());
        this.showMethodsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowMethods());
        this.showFieldsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowFields());
        this.showEnumConstantsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowEnumConstants());
        this.showProtectedToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowProtected());
        this.showPackageToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowPackage());
        this.showPrivateToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowPrivate());
        this.showStaticToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowStatic());
        this.javaMembersTree.getSelectionModel().setSelectionMode(1);
        this.javaMembersTree.setRootVisible(false);
        this.javaMembersTree.setShowsRootHandles(true);
        this.javaMembersTree.setCellRenderer(new JavaTreeCellRenderer());
        this.javaMembersModel = new JavaMembersModel(fileObject, elementArray, compilationInfo);
        this.javaMembersFilterModel = this.javaMembersModel.getFilterModel();
        this.javaMembersTree.setModel(this.javaMembersFilterModel);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                JavaMembersPanel.this.applyFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JavaMembersPanel.this.applyFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = JavaMembersPanel.this.docPane.getViewport().getView();
                if (component instanceof JEditorPane) {
                    JEditorPane jEditorPane = (JEditorPane)component;
                    ActionListener actionListener = jEditorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0, false));
                    actionListener.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
                }
            }
        }, KeyStroke.getKeyStroke(33, 1, false), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){
            private boolean firstTime = true;

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = JavaMembersPanel.this.docPane.getViewport().getView();
                if (component instanceof JEditorPane) {
                    JEditorPane jEditorPane = (JEditorPane)component;
                    ActionListener actionListener = jEditorPane.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0, false));
                    actionEvent = new ActionEvent(jEditorPane, 1001, "");
                    actionListener.actionPerformed(actionEvent);
                    if (this.firstTime) {
                        actionListener.actionPerformed(actionEvent);
                        this.firstTime = false;
                    }
                }
            }
        }, KeyStroke.getKeyStroke(34, 1, false), 0);
        this.signatureEditorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaElement javaElement = (JavaElement)object;
                    JavaMembersPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaMembersPanel.this.gotoElement((JavaElement)object);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.caseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JavaMembersPanel.this.filterTextField.getText().trim().length() > 0) {
                    JavaMembersPanel.this.applyFilter();
                }
            }
        });
        this.javaMembersTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                Point point = mouseEvent.getPoint();
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    if (mouseEvent.getClickCount() == 1) {
                        if (mouseEvent.isControlDown()) {
                            JavaMembersPanel.this.filterTextField.setText("");
                            JavaElement javaElement = (JavaElement)object;
                            JavaMembersPanel.this.applyFilter();
                        }
                    } else if (mouseEvent.getClickCount() == 2) {
                        JavaMembersPanel.this.gotoElement((JavaElement)object);
                    }
                }
            }
        });
        this.javaMembersTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                JavaMembersPanel.this.showSignature();
                JavaMembersPanel.this.showJavaDoc();
            }
        });
        this.javaMembersTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaMembersPanel.this.gotoElement((JavaElement)object);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.javaMembersTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaMembersPanel.this.filterTextField.setText("");
                    JavaMembersPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.showInheritedToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter(true);
            }
        });
        this.showFQNToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersAndHierarchyOptions.setShowFQN(JavaMembersPanel.this.showFQNToggleButton.isSelected());
                JavaMembersPanel.this.javaMembersFilterModel.fireTreeNodesChanged();
            }
        });
        this.showInnerToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter(true);
            }
        });
        this.showConstructorsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showMethodsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showFieldsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showEnumConstantsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showProtectedToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showPackageToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showPrivateToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showStaticToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.close();
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavaMembersPanel.this.applyFilter(true);
                JavaMembersPanel.this.filterTextField.requestFocusInWindow();
            }
        });
    }

    public void removeNotify() {
        JavaMembersAndHierarchyOptions.setMembersDividerLocation(this.splitPane.getDividerLocation());
        this.docPane.setData(null);
        super.removeNotify();
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        JRootPane jRootPane;
        if ((keyEvent.getKeyCode() == 112 || keyEvent.getKeyCode() == 156) && (jRootPane = SwingUtilities.getRootPane(this)) != null) {
            jRootPane.putClientProperty("help", Boolean.TRUE);
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private void enterBusy() {
        Window window;
        this.javaMembersTree.setModel(pleaseWaitTreeModel);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
        if ((window = SwingUtilities.getWindowAncestor(this)) != null) {
            this.lastFocusedComponent = window.getFocusOwner();
        }
        this.filterTextField.setEnabled(false);
        this.caseSensitiveFilterCheckBox.setEnabled(false);
        this.showInheritedToggleButton.setEnabled(false);
        this.showFQNToggleButton.setEnabled(false);
        this.showInnerToggleButton.setEnabled(false);
        this.showConstructorsToggleButton.setEnabled(false);
        this.showMethodsToggleButton.setEnabled(false);
        this.showFieldsToggleButton.setEnabled(false);
        this.showEnumConstantsToggleButton.setEnabled(false);
        this.showProtectedToggleButton.setEnabled(false);
        this.showPackageToggleButton.setEnabled(false);
        this.showPrivateToggleButton.setEnabled(false);
        this.showStaticToggleButton.setEnabled(false);
    }

    private void leaveBusy() {
        this.javaMembersTree.setModel(this.javaMembersFilterModel);
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            jRootPane.setCursor(Cursor.getDefaultCursor());
        }
        this.filterTextField.setEnabled(true);
        this.caseSensitiveFilterCheckBox.setEnabled(true);
        this.showInheritedToggleButton.setEnabled(true);
        this.showFQNToggleButton.setEnabled(true);
        this.showInnerToggleButton.setEnabled(true);
        this.showConstructorsToggleButton.setEnabled(true);
        this.showMethodsToggleButton.setEnabled(true);
        this.showFieldsToggleButton.setEnabled(true);
        this.showEnumConstantsToggleButton.setEnabled(true);
        this.showProtectedToggleButton.setEnabled(true);
        this.showPackageToggleButton.setEnabled(true);
        this.showPrivateToggleButton.setEnabled(true);
        this.showStaticToggleButton.setEnabled(true);
        if (this.lastFocusedComponent != null) {
            if (this.lastFocusedComponent.isDisplayable()) {
                this.lastFocusedComponent.requestFocusInWindow();
            }
            this.lastFocusedComponent = null;
        }
    }

    private void applyFilter() {
        this.applyFilter(false);
    }

    private void applyFilter(final boolean bl) {
        if (bl) {
            this.enterBusy();
        }
        this.javaMembersFilterModel.setPattern(this.filterTextField.getText());
        JavaMembersAndHierarchyOptions.setCaseSensitive(this.caseSensitiveFilterCheckBox.isSelected());
        JavaMembersAndHierarchyOptions.setShowInherited(this.showInheritedToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowFQN(this.showFQNToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowInner(this.showInnerToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowConstructors(this.showConstructorsToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowMethods(this.showMethodsToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowFields(this.showFieldsToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowEnumConstants(this.showEnumConstantsToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowProtected(this.showProtectedToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowPackage(this.showPackageToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowPrivate(this.showPrivateToggleButton.isSelected());
        JavaMembersAndHierarchyOptions.setShowStatic(this.showStaticToggleButton.isSelected());
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (bl) {
                        JavaMembersPanel.this.javaMembersModel.update();
                    }
                    JavaMembersPanel.this.javaMembersFilterModel.update();
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Object object;
                            TreePath treePath;
                            if (bl) {
                                JavaMembersPanel.this.leaveBusy();
                            }
                            for (int i = 0; i < JavaMembersPanel.this.javaMembersTree.getRowCount(); ++i) {
                                JavaMembersPanel.this.javaMembersTree.expandRow(i);
                            }
                            JavaMembersPanel.this.filterTextField.setForeground(UIManager.getColor("TextField.foreground"));
                            String string = JavaMembersPanel.this.filterTextField.getText();
                            if (string.trim().length() > 0) {
                                for (int i = 0; i < JavaMembersPanel.this.javaMembersTree.getRowCount(); ++i) {
                                    JavaElement javaElement;
                                    ElementKind elementKind;
                                    Object object2 = JavaMembersPanel.this.javaMembersTree.getPathForRow(i).getLastPathComponent();
                                    if (!(object2 instanceof JavaElement) || (elementKind = (javaElement = (JavaElement)object2).getElementKind()) == ElementKind.PACKAGE || !JavaMembersModel.patternMatch((JavaElement)object2, string)) continue;
                                    JavaMembersPanel.this.javaMembersTree.setSelectionRow(i);
                                    break;
                                }
                                if (JavaMembersPanel.this.javaMembersTree.getSelectionCount() == 0) {
                                    JavaMembersPanel.this.filterTextField.setForeground(Color.red);
                                }
                            } else if (JavaMembersPanel.this.javaMembersTree.getRowCount() > 1 && (treePath = JavaMembersPanel.this.javaMembersTree.getPathForRow(0)) != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
                                JavaElement javaElement = (JavaElement)object;
                                if (javaElement.getElementKind() == ElementKind.PACKAGE) {
                                    JavaMembersPanel.this.javaMembersTree.setSelectionRow(1);
                                } else {
                                    JavaMembersPanel.this.javaMembersTree.setSelectionRow(0);
                                }
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoElement(JavaElement javaElement) {
        try {
            javaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showSignature() {
        Object object;
        this.signatureEditorPane.setText("");
        this.signatureEditorPane.setToolTipText(null);
        TreePath treePath = this.javaMembersTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.signatureEditorPane.setText(((JavaElement)object).getTooltip());
            this.signatureEditorPane.setCaretPosition(0);
            this.signatureEditorPane.setToolTipText(((JavaElement)object).getTooltip());
        }
    }

    private void showJavaDoc() {
        Object object;
        TreePath treePath = this.javaMembersTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.docPane.setData(((JavaElement)object).getJavaDoc());
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private void gotoClass(TypeElement typeElement) {
    }

    private void initComponents() {
        this.filterLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.caseSensitiveFilterCheckBox = new JCheckBox();
        this.splitPane = new JSplitPane();
        this.javaMembersTreeScrollPane = new JScrollPane();
        this.javaMembersTree = new JTree();
        this.signatureEditorPane = new JEditorPane();
        this.filtersLabel = new JLabel();
        this.closeButton = new JButton();
        this.filtersToolbar = new NoBorderToolBar();
        this.showInheritedToggleButton = new JToggleButton();
        this.showFQNToggleButton = new JToggleButton();
        this.showInnerToggleButton = new JToggleButton();
        this.showConstructorsToggleButton = new JToggleButton();
        this.showMethodsToggleButton = new JToggleButton();
        this.showFieldsToggleButton = new JToggleButton();
        this.showEnumConstantsToggleButton = new JToggleButton();
        this.showProtectedToggleButton = new JToggleButton();
        this.showPackageToggleButton = new JToggleButton();
        this.showPrivateToggleButton = new JToggleButton();
        this.showStaticToggleButton = new JToggleButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.filterLabel.setLabelFor(this.filterTextField);
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getBundle(JavaMembersPanel.class).getString("LABEL_filterLabel"));
        this.filterTextField.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_filterTextField"));
        this.filterTextField.setNextFocusableComponent(this.javaMembersTree);
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveFilterCheckBox, (String)NbBundle.getBundle(JavaMembersPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.caseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.splitPane.setDividerLocation(350);
        this.splitPane.setOneTouchExpandable(true);
        this.javaMembersTreeScrollPane.setBorder(null);
        this.javaMembersTreeScrollPane.setViewportView(this.javaMembersTree);
        this.javaMembersTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavaMembersPanel.class, (String)"ACSN_JavaMembersTree"));
        this.javaMembersTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMembersPanel.class, (String)"ACSD_JavaMembersTree"));
        this.splitPane.setLeftComponent(this.javaMembersTreeScrollPane);
        this.signatureEditorPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.signatureEditorPane.setContentType("text/x-java");
        this.signatureEditorPane.setEditable(false);
        this.signatureEditorPane.setNextFocusableComponent(this.filtersToolbar);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(JavaMembersPanel.class, (String)"LABEL_filtersLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(JavaMembersPanel.class, (String)"LABEL_Close"));
        this.filtersToolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.filtersToolbar.setFloatable(false);
        this.filtersToolbar.setBorderPainted(false);
        this.filtersToolbar.setOpaque(false);
        this.showInheritedToggleButton.setIcon(JavaMembersAndHierarchyIcons.INHERITED_ICON);
        this.showInheritedToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showInheritedToggleButton"));
        this.showInheritedToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showInheritedToggleButton);
        this.showFQNToggleButton.setIcon(JavaMembersAndHierarchyIcons.FQN_ICON);
        this.showFQNToggleButton.setSelected(true);
        this.showFQNToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.showFQNToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showFQNToggleButton);
        this.showInnerToggleButton.setIcon(JavaMembersAndHierarchyIcons.INNER_CLASS_ICON);
        this.showInnerToggleButton.setSelected(true);
        this.showInnerToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showInnerToggleButton"));
        this.showInnerToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showInnerToggleButton);
        this.showConstructorsToggleButton.setIcon(JavaMembersAndHierarchyIcons.CONSTRUCTOR_ICON);
        this.showConstructorsToggleButton.setSelected(true);
        this.showConstructorsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showConstructorsToggleButton"));
        this.showConstructorsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showConstructorsToggleButton);
        this.showMethodsToggleButton.setIcon(JavaMembersAndHierarchyIcons.METHOD_ICON);
        this.showMethodsToggleButton.setSelected(true);
        this.showMethodsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showMethodsToggleButton"));
        this.showMethodsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showMethodsToggleButton);
        this.showFieldsToggleButton.setIcon(JavaMembersAndHierarchyIcons.FIELD_ICON);
        this.showFieldsToggleButton.setSelected(true);
        this.showFieldsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showFieldsToggleButton"));
        this.showFieldsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showFieldsToggleButton);
        this.showEnumConstantsToggleButton.setIcon(JavaMembersAndHierarchyIcons.ENUM_CONSTANTS_ICON);
        this.showEnumConstantsToggleButton.setSelected(true);
        this.showEnumConstantsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showEnumConstantsToggleButton"));
        this.showEnumConstantsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showEnumConstantsToggleButton);
        this.showProtectedToggleButton.setIcon(JavaMembersAndHierarchyIcons.PROTECTED_ICON);
        this.showProtectedToggleButton.setSelected(true);
        this.showProtectedToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showProtectedToggleButton"));
        this.showProtectedToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showProtectedToggleButton);
        this.showPackageToggleButton.setIcon(JavaMembersAndHierarchyIcons.PACKAGE_ICON);
        this.showPackageToggleButton.setSelected(true);
        this.showPackageToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showPackageToggleButton"));
        this.showPackageToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showPackageToggleButton);
        this.showPrivateToggleButton.setIcon(JavaMembersAndHierarchyIcons.PRIVATE_ICON);
        this.showPrivateToggleButton.setSelected(true);
        this.showPrivateToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showPrivateToggleButton"));
        this.showPrivateToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showPrivateToggleButton);
        this.showStaticToggleButton.setIcon(JavaMembersAndHierarchyIcons.STATIC_ICON);
        this.showStaticToggleButton.setSelected(true);
        this.showStaticToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showStaticToggleButton"));
        this.showStaticToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.filtersToolbar.add(this.showStaticToggleButton);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.splitPane, -1, 740, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filterLabel).addPreferredGap(0).add((Component)this.filterTextField, -1, 580, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caseSensitiveFilterCheckBox)).add((Component)this.signatureEditorPane, -1, 740, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.filtersLabel).addPreferredGap(0).add((Component)this.filtersToolbar, -1, 611, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.filterLabel).add((Component)this.caseSensitiveFilterCheckBox).add((Component)this.filterTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.splitPane, -1, 331, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.signatureEditorPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.filtersLabel).add((Component)this.closeButton)).add((Component)this.filtersToolbar, -2, 25, -2)).addContainerGap()));
        this.caseSensitiveFilterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaMembersPanel.class, (String)"caseSensitiveFilterCheckBox_ACSD"));
    }

    static {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(NbBundle.getMessage(JavaMembersPanel.class, (String)"LBL_WaitNode")));
        pleaseWaitTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
    }
}

