/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sync;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.RepairPanel;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.sync.SyncIndicatorConfiguration;
import org.netbeans.modules.dlight.sync.SyncIndicatorPanel;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.UIUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncIndicator
extends Indicator<SyncIndicatorConfiguration> {
    private SyncIndicatorPanel panel;
    private final Set<String> acceptedColumnNames = new HashSet<String>();
    private final List<String> acceptedThreadsCountColumnNames;
    private float lastLocks;
    private int lastThreads = 1;

    public SyncIndicator(SyncIndicatorConfiguration syncIndicatorConfiguration) {
        super((IndicatorConfiguration)syncIndicatorConfiguration);
        for (DataTableMetadata.Column column : this.getMetadataColumns()) {
            this.acceptedColumnNames.add(column.getColumnName());
        }
        this.acceptedThreadsCountColumnNames = syncIndicatorConfiguration.getThreadColumnNames();
    }

    public synchronized JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new SyncIndicatorPanel();
        }
        return this.panel.getPanel();
    }

    public void reset() {
    }

    public void updated(List<DataRow> list) {
        for (DataRow dataRow : list) {
            for (String string : dataRow.getColumnNames()) {
                String string2;
                if (this.acceptedThreadsCountColumnNames.contains(string)) {
                    string2 = dataRow.getStringValue(string);
                    try {
                        this.lastThreads = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        DLightLogger.instance.log(Level.WARNING, null, numberFormatException);
                    }
                    continue;
                }
                if (!this.acceptedColumnNames.contains(string)) continue;
                string2 = dataRow.getStringValue(string);
                try {
                    this.lastLocks = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    DLightLogger.instance.log(Level.WARNING, null, numberFormatException);
                }
            }
        }
    }

    protected void tick() {
        this.panel.addData(Math.round((float)this.lastThreads * Math.min(this.lastLocks, 100.0f) / 100.0f), this.lastThreads);
    }

    protected void repairNeeded(boolean bl) {
        if (bl) {
            final RepairPanel repairPanel = new RepairPanel(this.getRepairActionProvider().getValidationStatus());
            repairPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final Future future = SyncIndicator.this.getRepairActionProvider().asyncRepair();
                    DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(false);
                                }
                            });
                            Boolean bl = (Boolean)future.get();
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(true);
                                }
                            });
                            return bl;
                        }
                    }, (String)"Click On Repair in Sync Indicator task");
                }
            });
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    SyncIndicator.this.panel.getPanel().setOverlay((JComponent)repairPanel);
                }
            });
        } else {
            final JEditorPane jEditorPane = UIUtilities.createJEditorPane((String)this.getRepairActionProvider().getMessage(this.getRepairActionProvider().getValidationStatus()), (boolean)true, (Color)GraphConfig.TEXT_COLOR);
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    SyncIndicator.this.panel.getPanel().setOverlay((JComponent)jEditorPane);
                }
            });
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SyncIndicator.class, (String)string);
    }
}

