/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.imports.CancellableTask;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.FixDuplicateImportStmts;
import org.netbeans.modules.java.editor.semantic.SemanticHighlighter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFixAllImports {
    private static final String PREFS_KEY = JavaFixAllImports.class.getName();
    private static final String KEY_REMOVE_UNUSED_IMPORTS = "removeUnusedImports";
    private static final JavaFixAllImports INSTANCE = new JavaFixAllImports();

    public static JavaFixAllImports getDefault() {
        return INSTANCE;
    }

    private JavaFixAllImports() {
    }

    public void fixAllImports(FileObject fileObject) {
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            /*
             * WARNING - void declaration
             */
            public void run(WorkingCopy workingCopy) {
                try {
                    boolean bl;
                    Object object;
                    ArrayList<String> arrayList;
                    String[] stringArray52;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    ComputeImports.Pair<Map<String, List<TypeElement>>, Map<String, List<TypeElement>>> pair = new ComputeImports().computeCandidates((CompilationInfo)workingCopy);
                    Map map = (Map)pair.a;
                    Map map2 = (Map)pair.b;
                    int n = map2.size();
                    String[] stringArray2 = new String[n];
                    String[][] stringArray3 = new String[n][];
                    Icon[][] iconArray = new Icon[n][];
                    String[] stringArray4 = new String[n];
                    HashMap<String, TypeElement> hashMap = new HashMap<String, TypeElement>();
                    HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
                    Preferences preferences = NbPreferences.forModule(JavaFixAllImports.class).node(PREFS_KEY);
                    int n2 = 0;
                    boolean bl2 = false;
                    for (String[] stringArray52 : map2.keySet()) {
                        stringArray2[n2] = stringArray52;
                        List list = (List)map2.get(stringArray52);
                        arrayList = (List)map.get(stringArray52);
                        bl2 |= list.size() > 1;
                        if (!list.isEmpty()) {
                            stringArray3[n2] = new String[list.size()];
                            iconArray[n2] = new Icon[stringArray3[n2].length];
                            int n3 = -1;
                            int n4 = Integer.MAX_VALUE;
                            for (TypeElement typeElement : arrayList) {
                                stringArray3[n2][++n3] = typeElement.getQualifiedName().toString();
                                iconArray[n2][n3] = ElementIcons.getElementIcon((ElementKind)typeElement.getKind(), typeElement.getModifiers());
                                int n5 = Utilities.getImportanceLevel(stringArray3[n2][n3]);
                                if (n5 < n4) {
                                    stringArray4[n2] = stringArray3[n2][n3];
                                    n4 = n5;
                                }
                                hashMap.put(typeElement.getQualifiedName().toString(), typeElement);
                            }
                            for (TypeElement typeElement : list) {
                                if (arrayList.contains(typeElement)) continue;
                                String string = typeElement.getQualifiedName().toString();
                                object = "<html><font color='#808080'><s>" + string;
                                stringArray3[n2][++n3] = object;
                                int n6 = Utilities.getImportanceLevel(string);
                                if (n6 < n4) {
                                    stringArray4[n2] = stringArray3[n2][n3];
                                    n4 = n6;
                                }
                                hashMap.put(string, typeElement);
                                hashMap2.put(object, string);
                            }
                        } else {
                            stringArray3[n2] = new String[1];
                            stringArray3[n2][0] = NbBundle.getMessage(JavaFixAllImports.class, (String)"FixDupImportStmts_CannotResolve");
                            stringArray4[n2] = stringArray3[n2][0];
                            iconArray[n2] = new Icon[1];
                            iconArray[n2][0] = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/editor/resources/error-glyph.gif", (boolean)false);
                        }
                        ++n2;
                    }
                    boolean bl3 = false;
                    stringArray52 = null;
                    if (bl2) {
                        arrayList = new FixDuplicateImportStmts();
                        ((FixDuplicateImportStmts)((Object)arrayList)).initPanel(stringArray2, stringArray3, iconArray, stringArray4, preferences.getBoolean(JavaFixAllImports.KEY_REMOVE_UNUSED_IMPORTS, true));
                        DialogDescriptor dialogDescriptor = new DialogDescriptor(arrayList, NbBundle.getMessage(JavaFixAllImports.class, (String)"FixDupImportStmts_Title"));
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                        dialog.setVisible(true);
                        dialog.setVisible(false);
                        dialog.dispose();
                        bl3 = dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
                        stringArray52 = ((FixDuplicateImportStmts)((Object)arrayList)).getSelections();
                        bl = ((FixDuplicateImportStmts)((Object)arrayList)).getRemoveUnusedImports();
                    } else {
                        bl3 = true;
                        stringArray52 = stringArray4;
                        bl = preferences.getBoolean(JavaFixAllImports.KEY_REMOVE_UNUSED_IMPORTS, true);
                    }
                    if (bl3) {
                        void var19_27;
                        if (bl2) {
                            preferences.putBoolean(JavaFixAllImports.KEY_REMOVE_UNUSED_IMPORTS, bl);
                        }
                        arrayList = new ArrayList<String>();
                        for (String string : stringArray52) {
                            String string2 = (String)hashMap2.get(string);
                            object = (TypeElement)hashMap.get(string2 != null ? string2 : string);
                            if (object == null) continue;
                            arrayList.add(object.getQualifiedName().toString());
                        }
                        CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                        int n7 = 0;
                        if (bl) {
                            List<TreePathHandle> list = SemanticHighlighter.computeUnusedImports((CompilationInfo)workingCopy);
                            list.addAll(JavaFixAllImports.getImportsFromSamePackage(workingCopy));
                            n7 = !list.isEmpty() ? 1 : 0;
                            for (TreePathHandle treePathHandle : list) {
                                object = treePathHandle.resolve((CompilationInfo)workingCopy);
                                assert (object != null);
                                CompilationUnitTree compilationUnitTree2 = workingCopy.getTreeMaker().removeCompUnitImport((CompilationUnitTree)var19_27, (ImportTree)((TreePath)object).getLeaf());
                            }
                        }
                        CompilationUnitTree compilationUnitTree3 = JavaFixAllImports.addImports((CompilationUnitTree)var19_27, arrayList, workingCopy.getTreeMaker());
                        workingCopy.rewrite((Tree)workingCopy.getCompilationUnit(), (Tree)compilationUnitTree3);
                        if (!bl2) {
                            String string;
                            if (arrayList.isEmpty() && n7 == 0) {
                                Toolkit.getDefaultToolkit().beep();
                                string = NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_NothingToFix");
                            } else {
                                string = arrayList.isEmpty() && n7 != 0 ? NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_UnusedImportsRemoved") : NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_ImportsFixed");
                            }
                            StatusDisplayer.getDefault().setStatusText(string);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaFixAllImports.class, (String)"MSG_CannotFixImports"));
            } else {
                CancellableTask cancellableTask = new CancellableTask(new ModificationRunnable(javaSource, task));
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JavaFixAllImports.class, (String)"fix-imports"), (Cancellable)cancellableTask);
                cancellableTask.setHandle(progressHandle);
                progressHandle.start();
                javaSource.runWhenScanFinished((Task)cancellableTask, true);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static List<TreePathHandle> getImportsFromSamePackage(WorkingCopy workingCopy) {
        ImportVisitor importVisitor = new ImportVisitor((CompilationInfo)workingCopy);
        importVisitor.scan(workingCopy.getCompilationUnit(), null);
        return importVisitor.getImports();
    }

    public static CompilationUnitTree addImports(CompilationUnitTree compilationUnitTree, List<String> list, TreeMaker treeMaker) throws IOException {
        String string;
        list = new ArrayList<String>(list);
        Collections.sort(list);
        ArrayList<? extends ImportTree> arrayList = new ArrayList<ImportTree>(compilationUnitTree.getImports());
        int n = list.size() - 1;
        int n2 = arrayList.size() - 1;
        while (n >= 0 && n2 >= 0) {
            string = list.get(n);
            while (n2 >= 0 && (((ImportTree)arrayList.get(n2)).isStatic() || ((ImportTree)arrayList.get(n2)).getQualifiedIdentifier().toString().compareTo(string) > 0)) {
                --n2;
            }
            if (n2 < 0) continue;
            arrayList.add(n2 + 1, treeMaker.Import((Tree)treeMaker.Identifier((CharSequence)string), false));
            --n;
        }
        while (n >= 0) {
            string = list.get(n);
            arrayList.add(0, treeMaker.Import((Tree)treeMaker.Identifier((CharSequence)string), false));
            --n;
        }
        return treeMaker.CompilationUnit(compilationUnitTree.getPackageName(), arrayList, compilationUnitTree.getTypeDecls(), compilationUnitTree.getSourceFile());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportVisitor
    extends TreePathScanner {
        private CompilationInfo info;
        private String currentPackage;
        private List<TreePathHandle> imports;

        private ImportVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
            ExpressionTree expressionTree = compilationInfo.getCompilationUnit().getPackageName();
            this.currentPackage = expressionTree != null ? expressionTree.toString() : "";
            this.imports = new ArrayList<TreePathHandle>();
        }

        @Override
        public Object visitImport(ImportTree importTree, Object object) {
            ExpressionTree expressionTree;
            if (importTree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT && (expressionTree = ((MemberSelectTree)importTree.getQualifiedIdentifier()).getExpression()).toString().equals(this.currentPackage)) {
                this.imports.add(TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)this.info));
            }
            super.visitImport(importTree, null);
            return null;
        }

        List<TreePathHandle> getImports() {
            return this.imports;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModificationRunnable
    implements Runnable {
        private JavaSource javaSource;
        private Task<WorkingCopy> task;

        public ModificationRunnable(JavaSource javaSource, Task<WorkingCopy> task) {
            this.javaSource = javaSource;
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.javaSource.runModificationTask(this.task).commit();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

