/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.fold;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JavaElementFoldManager
extends JavaFoldManager {
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private boolean foldImportsPreset = false;
    private boolean foldInnerClassesPreset = false;
    private boolean foldJavadocsPreset = false;
    private boolean foldCodeBlocksPreset = false;
    private boolean foldInitialCommentsPreset = false;
    private Map<FoldInfo, Fold> currentFolds;
    private Fold initialCommentFold;
    private Fold importsFold;

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
        this.foldInitialCommentsPreset = preferences.getBoolean("code-folding-collapse-initial-comment", this.foldInitialCommentsPreset);
        this.foldImportsPreset = preferences.getBoolean("code-folding-collapse-import", this.foldImportsPreset);
        this.foldCodeBlocksPreset = preferences.getBoolean("code-folding-collapse-method", this.foldCodeBlocksPreset);
        this.foldInnerClassesPreset = preferences.getBoolean("code-folding-collapse-innerclass", this.foldInnerClassesPreset);
        this.foldJavadocsPreset = preferences.getBoolean("code-folding-collapse-javadoc", this.foldJavadocsPreset);
    }

    public synchronized void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        Document document = this.operation.getHierarchy().getComponent().getDocument();
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            this.currentFolds = new HashMap<FoldInfo, Fold>();
            this.task = JavaElementFoldTask.getTask(((DataObject)object).getPrimaryFile());
            this.task.setJavaElementFoldManager(this);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeDamagedNotify(fold);
    }

    public void removeDamagedNotify(Fold fold) {
        this.currentFolds.remove(this.operation.getExtraInfo(fold));
        if (this.importsFold == fold) {
            this.importsFold = null;
        }
        if (this.initialCommentFold == fold) {
            this.initialCommentFold = null;
        }
    }

    public void expandNotify(Fold fold) {
    }

    public synchronized void release() {
        if (this.task != null) {
            this.task.setJavaElementFoldManager(null);
        }
        this.task = null;
        this.file = null;
        this.currentFolds = null;
        this.importsFold = null;
        this.initialCommentFold = null;
    }

    protected static final class FoldInfo
    implements Comparable {
        private Position start;
        private Position end;
        private JavaFoldManager.FoldTemplate template;
        private boolean collapseByDefault;

        public FoldInfo(Document document, int n, int n2, JavaFoldManager.FoldTemplate foldTemplate, boolean bl) throws BadLocationException {
            this.start = document.createPosition(n);
            this.end = document.createPosition(n2);
            this.template = foldTemplate;
            this.collapseByDefault = bl;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FoldInfo)) {
                return false;
            }
            return this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            FoldInfo foldInfo = (FoldInfo)object;
            if (this.start.getOffset() < foldInfo.start.getOffset()) {
                return -1;
            }
            if (this.start.getOffset() > foldInfo.start.getOffset()) {
                return 1;
            }
            if (this.end.getOffset() < foldInfo.end.getOffset()) {
                return -1;
            }
            if (this.end.getOffset() > foldInfo.end.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JavaElementFoldVisitor
    extends CancellableTreePathScanner<Object, Object> {
        private List<FoldInfo> folds = new ArrayList<FoldInfo>();
        private CompilationInfo info;
        private CompilationUnitTree cu;
        private SourcePositions sp;
        private boolean stopped;

        public JavaElementFoldVisitor(CompilationInfo compilationInfo, CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions) {
            this.info = compilationInfo;
            this.cu = compilationUnitTree;
            this.sp = sourcePositions;
        }

        public void checkInitialFold() {
            try {
                TokenHierarchy tokenHierarchy = this.info.getTokenHierarchy();
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language());
                while (tokenSequence.moveNext()) {
                    Token token = tokenSequence.token();
                    if (token.id() == JavaTokenId.BLOCK_COMMENT) {
                        Document document = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                        int n = tokenSequence.offset();
                        boolean bl = JavaElementFoldManager.this.foldInitialCommentsPreset;
                        if (JavaElementFoldManager.this.initialCommentFold != null) {
                            bl = JavaElementFoldManager.this.initialCommentFold.isCollapsed();
                        }
                        this.folds.add(new FoldInfo(document, n, n + token.length(), JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE, bl));
                    }
                    if (token.id() == JavaTokenId.WHITESPACE) continue;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.stopped = true;
            }
        }

        private void handleJavadoc(Tree tree) throws BadLocationException, ConcurrentModificationException {
            int n = (int)this.sp.getStartPosition(this.cu, tree);
            if (n == -1) {
                return;
            }
            TokenHierarchy tokenHierarchy = this.info.getTokenHierarchy();
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language());
            if (tokenSequence.move(n) == Integer.MAX_VALUE) {
                return;
            }
            while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                if (token.id() == JavaTokenId.JAVADOC_COMMENT) {
                    Document document = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    int n2 = tokenSequence.offset();
                    this.folds.add(new FoldInfo(document, n2, n2 + token.length(), JavaFoldManager.JAVADOC_FOLD_TEMPLATE, JavaElementFoldManager.this.foldJavadocsPreset));
                }
                if (token.id() == JavaTokenId.WHITESPACE || token.id() == JavaTokenId.BLOCK_COMMENT || token.id() == JavaTokenId.LINE_COMMENT) continue;
                break;
            }
        }

        private void handleTree(Tree tree, Tree tree2, boolean bl) {
            try {
                if (!bl) {
                    Document document = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    int n = (int)this.sp.getStartPosition(this.cu, tree);
                    int n2 = (int)this.sp.getEndPosition(this.cu, tree);
                    if (n != -1 && n2 != -1) {
                        this.folds.add(new FoldInfo(document, n, n2, JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE, JavaElementFoldManager.this.foldCodeBlocksPreset));
                    }
                }
                this.handleJavadoc(tree2 != null ? tree2 : tree);
            }
            catch (BadLocationException badLocationException) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.stopped = true;
            }
        }

        public Object visitMethod(MethodTree methodTree, Object object) {
            super.visitMethod(methodTree, object);
            this.handleTree(methodTree.getBody(), methodTree, false);
            return null;
        }

        public Object visitClass(ClassTree classTree, Object object) {
            super.visitClass(classTree, (Object)Boolean.TRUE);
            try {
                if (object == Boolean.TRUE) {
                    Document document = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    int n = Utilities.findBodyStart(classTree, this.cu, this.sp, document);
                    int n2 = (int)this.sp.getEndPosition(this.cu, classTree);
                    if (n != -1 && n2 != -1) {
                        this.folds.add(new FoldInfo(document, n, n2, JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE, JavaElementFoldManager.this.foldInnerClassesPreset));
                    }
                }
                this.handleJavadoc(classTree);
            }
            catch (BadLocationException badLocationException) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                this.stopped = true;
            }
            return null;
        }

        public Object visitVariable(VariableTree variableTree, Object object) {
            super.visitVariable(variableTree, object);
            this.handleTree(variableTree, null, true);
            return null;
        }

        public Object visitBlock(BlockTree blockTree, Object object) {
            super.visitBlock(blockTree, object);
            TreePath treePath = this.getCurrentPath();
            if (treePath.getParentPath().getLeaf().getKind() == Tree.Kind.CLASS) {
                this.handleTree(blockTree, null, false);
            }
            return null;
        }

        public Object visitCompilationUnit(CompilationUnitTree compilationUnitTree, Object object) {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            for (ImportTree importTree : compilationUnitTree.getImports()) {
                int n3 = (int)this.sp.getStartPosition(this.cu, importTree);
                int n4 = (int)this.sp.getEndPosition(this.cu, importTree);
                if (n > n3) {
                    n = n3;
                }
                if (n4 <= n2) continue;
                n2 = n4;
            }
            if (n2 != -1 && n != -1) {
                try {
                    boolean bl;
                    Document document = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    boolean bl2 = JavaElementFoldManager.this.foldImportsPreset;
                    if (JavaElementFoldManager.this.importsFold != null) {
                        bl = JavaElementFoldManager.this.importsFold.isCollapsed();
                    }
                    if ((n += 7) < n2) {
                        this.folds.add(new FoldInfo(document, n, n2, JavaFoldManager.IMPORTS_FOLD_TEMPLATE, bl));
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.stopped = true;
                }
            }
            return super.visitCompilationUnit(compilationUnitTree, object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private List<FoldInfo> infos;
        private long startTime;

        public CommitFolds(List<FoldInfo> list) {
            this.infos = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument().render(this);
                return;
            }
            JavaElementFoldManager.this.operation.getHierarchy().lock();
            try {
                FoldHierarchyTransaction foldHierarchyTransaction = JavaElementFoldManager.this.operation.openTransaction();
                try {
                    if (JavaElementFoldManager.this.currentFolds == null) {
                        return;
                    }
                    TreeMap<FoldInfo, Fold> treeMap = new TreeMap<FoldInfo, Fold>();
                    ArrayList arrayList = new ArrayList(JavaElementFoldManager.this.currentFolds.keySet());
                    for (FoldInfo foldInfo : this.infos) {
                        if (JavaElementFoldManager.this.currentFolds.containsKey(foldInfo)) {
                            arrayList.remove(foldInfo);
                            continue;
                        }
                        int n = foldInfo.start.getOffset();
                        int n2 = foldInfo.end.getOffset();
                        if (n2 <= n || n2 - n <= foldInfo.template.getStartGuardedLength() + foldInfo.template.getEndGuardedLength() || treeMap.containsKey(foldInfo)) continue;
                        Fold fold = JavaElementFoldManager.this.operation.addToHierarchy(foldInfo.template.getType(), foldInfo.template.getDescription(), foldInfo.collapseByDefault, n, n2, foldInfo.template.getStartGuardedLength(), foldInfo.template.getEndGuardedLength(), (Object)foldInfo, foldHierarchyTransaction);
                        treeMap.put(foldInfo, fold);
                        if (foldInfo.template == JavaFoldManager.IMPORTS_FOLD_TEMPLATE) {
                            JavaElementFoldManager.this.importsFold = fold;
                        }
                        if (foldInfo.template != JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE) continue;
                        JavaElementFoldManager.this.initialCommentFold = fold;
                    }
                    for (FoldInfo foldInfo : arrayList) {
                        Fold fold = (Fold)JavaElementFoldManager.this.currentFolds.remove(foldInfo);
                        JavaElementFoldManager.this.operation.removeFromHierarchy(fold, foldHierarchyTransaction);
                        if (JavaElementFoldManager.this.importsFold == fold) {
                            JavaElementFoldManager.this.importsFold = null;
                        }
                        if (JavaElementFoldManager.this.initialCommentFold != fold) continue;
                        JavaElementFoldManager.this.initialCommentFold = null;
                    }
                    JavaElementFoldManager.this.currentFolds.putAll(treeMap);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                finally {
                    foldHierarchyTransaction.commit();
                }
            }
            finally {
                JavaElementFoldManager.this.operation.getHierarchy().unlock();
            }
            long l = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{JavaElementFoldManager.this.file, l - this.startTime});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JavaElementFoldTask
    extends ScanningCancellableTask<CompilationInfo> {
        private static Map<DataObject, JavaElementFoldTask> file2Task = new WeakHashMap<DataObject, JavaElementFoldTask>();
        private Reference<JavaElementFoldManager> manager;

        JavaElementFoldTask() {
        }

        static JavaElementFoldTask getTask(FileObject fileObject) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                JavaElementFoldTask javaElementFoldTask = file2Task.get(dataObject);
                if (javaElementFoldTask == null) {
                    javaElementFoldTask = new JavaElementFoldTask();
                    file2Task.put(dataObject, javaElementFoldTask);
                }
                return javaElementFoldTask;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Logger.getLogger(JavaElementFoldManager.class.getName()).log(Level.FINE, null, dataObjectNotFoundException);
                return new JavaElementFoldTask();
            }
        }

        synchronized void setJavaElementFoldManager(JavaElementFoldManager javaElementFoldManager) {
            this.manager = new WeakReference<JavaElementFoldManager>(javaElementFoldManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(CompilationInfo compilationInfo) {
            JavaElementFoldManager javaElementFoldManager;
            this.resume();
            JavaElementFoldTask javaElementFoldTask = this;
            synchronized (javaElementFoldTask) {
                javaElementFoldManager = this.manager != null ? this.manager.get() : null;
            }
            if (javaElementFoldManager == null) {
                return;
            }
            long l = System.currentTimeMillis();
            CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
            JavaElementFoldManager javaElementFoldManager2 = javaElementFoldManager;
            ((Object)((Object)javaElementFoldManager2)).getClass();
            JavaElementFoldVisitor javaElementFoldVisitor = javaElementFoldManager2.new JavaElementFoldVisitor(compilationInfo, compilationUnitTree, compilationInfo.getTrees().getSourcePositions());
            this.scan(javaElementFoldVisitor, (Tree)compilationUnitTree, null);
            if (javaElementFoldVisitor.stopped || this.isCancelled()) {
                return;
            }
            javaElementFoldVisitor.checkInitialFold();
            if (javaElementFoldVisitor.stopped || this.isCancelled()) {
                return;
            }
            JavaElementFoldManager javaElementFoldManager3 = javaElementFoldManager;
            ((Object)((Object)javaElementFoldManager3)).getClass();
            SwingUtilities.invokeLater(javaElementFoldManager3.new CommitFolds(javaElementFoldVisitor.folds));
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{compilationInfo.getFileObject(), l2 - l});
        }
    }
}

