/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.ImplementOverridePanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ImplementOverrideMethodGenerator
implements CodeGenerator {
    private JTextComponent component;
    private ElementNode.Description description;
    private boolean isImplement;

    private ImplementOverrideMethodGenerator(JTextComponent jTextComponent, ElementNode.Description description, boolean bl) {
        this.component = jTextComponent;
        this.description = description;
        this.isImplement = bl;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImplementOverrideMethodGenerator.class, (String)(this.isImplement ? "LBL_implement_method" : "LBL_override_method"));
    }

    public void invoke() {
        JavaSource javaSource;
        final ImplementOverridePanel implementOverridePanel = new ImplementOverridePanel(this.description, this.isImplement);
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(implementOverridePanel, NbBundle.getMessage(ConstructorGenerator.class, (String)(this.isImplement ? "LBL_generate_implement" : "LBL_generate_override")));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue() && (javaSource = JavaSource.forDocument((Document)this.component.getDocument())) != null) {
            try {
                final int n = this.component.getCaretPosition();
                ModificationResult modificationResult = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy workingCopy) throws IOException {
                        workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                        treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                        int n2 = GeneratorUtils.findClassMemberIndex(workingCopy, (ClassTree)treePath.getLeaf(), n);
                        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
                        for (ElementHandle<? extends Element> elementHandle : implementOverridePanel.getSelectedMethods()) {
                            arrayList.add((ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy));
                        }
                        if (ImplementOverrideMethodGenerator.this.isImplement) {
                            GeneratorUtils.generateAbstractMethodImplementations(workingCopy, treePath, arrayList, n2);
                        } else {
                            GeneratorUtils.generateMethodOverrides(workingCopy, treePath, arrayList, n2);
                        }
                    }
                });
                GeneratorUtils.guardedCommit(this.component, modificationResult);
                int[] nArray = modificationResult.getSpan((Object)"methodBodyTag");
                if (nArray != null) {
                    this.component.setSelectionStart(nArray[0]);
                    this.component.setSelectionEnd(nArray[1]);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        /*
         * WARNING - void declaration
         */
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<ImplementOverrideMethodGenerator> arrayList = new ArrayList<ImplementOverrideMethodGenerator>();
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
            TreePath treePath = (TreePath)lookup.lookup(TreePath.class);
            TreePath treePath2 = treePath = treePath != null ? Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath) : null;
            if (jTextComponent == null || compilationController == null || treePath == null) {
                return arrayList;
            }
            try {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException iOException) {
                return arrayList;
            }
            TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
            if (typeElement == null || !typeElement.getKind().isClass()) {
                return arrayList;
            }
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (ExecutableElement object22 : GeneratorUtils.findUndefs((CompilationInfo)compilationController, typeElement)) {
                void var10_13;
                List list = (List)linkedHashMap.get(object22.getEnclosingElement());
                if (list == null) {
                    ArrayList arrayList2 = new ArrayList();
                    linkedHashMap.put(object22.getEnclosingElement(), arrayList2);
                }
                var10_13.add(ElementNode.Description.create(object22, null, true, false));
            }
            ArrayList arrayList2 = new ArrayList();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                arrayList2.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
            }
            if (!arrayList2.isEmpty()) {
                arrayList.add(new ImplementOverrideMethodGenerator(jTextComponent, ElementNode.Description.create(arrayList2), true));
            }
            linkedHashMap = new LinkedHashMap();
            ArrayList<Element> arrayList3 = new ArrayList<Element>();
            for (ExecutableElement executableElement : GeneratorUtils.findOverridable((CompilationInfo)compilationController, typeElement)) {
                List list = (List)linkedHashMap.get(executableElement.getEnclosingElement());
                if (list == null) {
                    list = new ArrayList();
                    Element element = executableElement.getEnclosingElement();
                    linkedHashMap.put(element, list);
                    if (!arrayList3.contains(element)) {
                        arrayList3.add(element);
                    }
                }
                list.add(ElementNode.Description.create(executableElement, null, true, false));
            }
            ArrayList<ElementNode.Description> arrayList4 = new ArrayList<ElementNode.Description>();
            for (List list : arrayList3) {
                arrayList4.add(ElementNode.Description.create(list, (List)linkedHashMap.get(list), false, false));
            }
            if (!arrayList4.isEmpty()) {
                arrayList.add(new ImplementOverrideMethodGenerator(jTextComponent, ElementNode.Description.create(arrayList4), false));
            }
            return arrayList;
        }
    }
}

