/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchemaTableProvider
implements TableProvider {
    private final SchemaElement schemaElement;
    private final Set<Table> tables;

    public DBSchemaTableProvider(SchemaElement schemaElement) {
        this.schemaElement = schemaElement;
        this.tables = this.buildTables();
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    public static boolean isJoinTable(TableElement tableElement) {
        ForeignKeyElement[] foreignKeyElementArray = tableElement.getForeignKeys();
        if (foreignKeyElementArray == null || foreignKeyElementArray.length != 2) {
            return false;
        }
        int n = foreignKeyElementArray[0].getColumns().length + foreignKeyElementArray[1].getColumns().length;
        if (n < tableElement.getColumns().length) {
            return false;
        }
        String string = tableElement.getName().getName();
        for (int i = 0; i < 2; ++i) {
            if (!string.equals(foreignKeyElementArray[i].getReferencedTable().getName().getName())) continue;
            return false;
        }
        return !DBSchemaTableProvider.isFkUnique(foreignKeyElementArray[0]) && !DBSchemaTableProvider.isFkUnique(foreignKeyElementArray[1]);
    }

    private static boolean isFkUnique(ForeignKeyElement foreignKeyElement) {
        UniqueKeyElement[] uniqueKeyElementArray = foreignKeyElement.getDeclaringTable().getUniqueKeys();
        if (uniqueKeyElementArray == null) {
            return false;
        }
        ColumnElement[] columnElementArray = foreignKeyElement.getColumns();
        for (int i = 0; i < uniqueKeyElementArray.length; ++i) {
            if (!DBSchemaTableProvider.containsSameColumns(columnElementArray, uniqueKeyElementArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSameColumns(ColumnElement[] columnElementArray, UniqueKeyElement uniqueKeyElement) {
        if (columnElementArray.length == uniqueKeyElement.getColumns().length) {
            for (int i = 0; i < columnElementArray.length; ++i) {
                if (uniqueKeyElement.getColumn(columnElementArray[i].getName()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<Table> buildTables() {
        ForeignKeyElement[] foreignKeyElementArray;
        Object object;
        HashMap<ForeignKeyElement[], ForeignKeyElement[]> hashMap = new HashMap<ForeignKeyElement[], ForeignKeyElement[]>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        TableElement[] tableElementArray = this.schemaElement.getTables();
        for (Object object2 : tableElementArray) {
            Object object3;
            if (!object2.isTable()) continue;
            boolean bl = DBSchemaTableProvider.isJoinTable(object2);
            object = DBSchemaTableProvider.getDisabledReasons(object2);
            foreignKeyElementArray = null;
            ForeignKeyElement[] foreignKeyElementArray2 = object.iterator();
            while (foreignKeyElementArray2.hasNext()) {
                object3 = foreignKeyElementArray2.next();
                if (bl && object3 instanceof Table.NoPrimaryKeyDisabledReason) continue;
                foreignKeyElementArray = object3;
                break;
            }
            foreignKeyElementArray2 = object2.getName().getName();
            object3 = new DBSchemaTable((String)foreignKeyElementArray2, (Table.DisabledReason)foreignKeyElementArray);
            hashMap.put(foreignKeyElementArray2, (ForeignKeyElement[])object3);
            hashMap2.put(foreignKeyElementArray2, new HashSet());
            hashMap3.put(foreignKeyElementArray2, new HashSet());
            hashMap4.put(foreignKeyElementArray2, new HashSet());
        }
        for (Object object2 : tableElementArray) {
            if (!object2.isTable()) continue;
            String string = object2.getName().getName();
            object = (Table)hashMap.get(string);
            foreignKeyElementArray = object2.getForeignKeys();
            if (foreignKeyElementArray == null) continue;
            for (ForeignKeyElement foreignKeyElement : foreignKeyElementArray) {
                TableElement tableElement = foreignKeyElement.getReferencedTable();
                String string2 = tableElement.getName().getName();
                Table table = (Table)hashMap.get(string2);
                ((Set)hashMap2.get(string)).add(table);
                ((Set)hashMap3.get(string2)).add(object);
                if (!((Table)object).isJoin()) continue;
                ((Set)hashMap4.get(string2)).add(object);
            }
        }
        HashSet hashSet = new HashSet();
        for (DBSchemaTable dBSchemaTable : hashMap.values()) {
            Object object2;
            object2 = dBSchemaTable.getName();
            dBSchemaTable.setReferencedTables(Collections.unmodifiableSet((Set)hashMap2.get(object2)));
            dBSchemaTable.setReferencedByTables(Collections.unmodifiableSet((Set)hashMap3.get(object2)));
            dBSchemaTable.setJoinTables(Collections.unmodifiableSet((Set)hashMap4.get(object2)));
            hashSet.add(dBSchemaTable);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static List<Table.DisabledReason> getDisabledReasons(TableElement tableElement) {
        ArrayList<Table.DisabledReason> arrayList = new ArrayList<Table.DisabledReason>();
        if (DBSchemaTableProvider.hasNoPrimaryKey(tableElement)) {
            arrayList.add(new Table.NoPrimaryKeyDisabledReason());
        }
        return arrayList;
    }

    private static boolean hasNoPrimaryKey(TableElement tableElement) {
        return tableElement.getPrimaryKey() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DBSchemaTable
    extends Table {
        private Set<Table> referencedTables;
        private Set<Table> referencedByTables;
        private Set<Table> joinTables;

        public DBSchemaTable(String string, Table.DisabledReason disabledReason) {
            super(string, false, disabledReason);
        }

        @Override
        public Set<Table> getReferencedTables() {
            return this.referencedTables;
        }

        private void setReferencedTables(Set<Table> set) {
            this.referencedTables = set;
        }

        @Override
        public Set<Table> getReferencedByTables() {
            return this.referencedByTables;
        }

        private void setReferencedByTables(Set<Table> set) {
            this.referencedByTables = set;
        }

        @Override
        public Set<Table> getJoinTables() {
            return this.joinTables;
        }

        private void setJoinTables(Set<Table> set) {
            this.joinTables = set;
        }
    }
}

