/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.samples.depot;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.samples.depot.DepotWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepotWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;

    public static DepotWizardIterator createIterator() {
        return new DepotWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new DepotWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(DepotWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set<FileObject> instantiate() throws IOException {
        File file;
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        File file2 = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        file2.mkdirs();
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wiz);
        if (!fileObject.isValid()) {
            fileObject = FileUtil.getConfigFile((String)fileObject.getPath());
        }
        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
        DepotWizardIterator.unZipFile(fileObject.getInputStream(), fileObject2);
        linkedHashSet.add(fileObject2);
        Enumeration enumeration = fileObject2.getFolders(true);
        while (enumeration.hasMoreElements()) {
            file = (FileObject)enumeration.nextElement();
            if (!ProjectManager.getDefault().isProject((FileObject)file)) continue;
            linkedHashSet.add((FileObject)file);
        }
        file = file2.getParentFile();
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        File file3 = File.createTempFile("depotReadme", ".url");
        file3.deleteOnExit();
        FileObject fileObject3 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file3));
        DepotWizardIterator.writeLines(fileObject3, fileObject2.getFileObject("README-DEPOT.html").getURL().toString());
        linkedHashSet.add(fileObject3);
        return linkedHashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream inputStream, FileObject fileObject) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static void writeLines(FileObject fileObject, String ... stringArray) throws FileAlreadyLockedException, IOException {
        PrintWriter printWriter = new PrintWriter(fileObject.getOutputStream());
        for (String string : stringArray) {
            printWriter.println(string);
        }
        printWriter.close();
    }
}

