/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public class CsmStatementResolver {
    private CsmStatementResolver() {
    }

    public static boolean findInnerObject(CsmStatement csmStatement, int n, CsmContext csmContext) {
        if (csmStatement == null) {
            CsmStatementResolver.print("STATEMENT is null");
            return false;
        }
        if (!CsmOffsetUtilities.isInObject((CsmObject)csmStatement, n)) {
            CsmStatementResolver.print("Offset " + n + " is not in statement " + csmStatement);
            return false;
        }
        CsmContextUtilities.updateContext((CsmObject)csmStatement, n, csmContext);
        CsmStatement.Kind kind = csmStatement.getKind();
        boolean bl = true;
        switch (kind) {
            case COMPOUND: {
                bl = CsmStatementResolver.findInner((CsmCompoundStatement)csmStatement, n, csmContext);
                break;
            }
            case IF: {
                bl = CsmStatementResolver.findInner((CsmIfStatement)csmStatement, n, csmContext);
                break;
            }
            case TRY_CATCH: {
                bl = CsmStatementResolver.findInner((CsmTryCatchStatement)csmStatement, n, csmContext);
                break;
            }
            case CATCH: {
                bl = CsmStatementResolver.findInner((CsmExceptionHandler)csmStatement, n, csmContext);
                break;
            }
            case DECLARATION: {
                bl = CsmStatementResolver.findInner((CsmDeclarationStatement)csmStatement, n, csmContext);
                break;
            }
            case WHILE: 
            case DO_WHILE: {
                bl = CsmStatementResolver.findInner((CsmLoopStatement)csmStatement, n, csmContext);
                break;
            }
            case FOR: {
                bl = CsmStatementResolver.findInner((CsmForStatement)csmStatement, n, csmContext);
                break;
            }
            case SWITCH: {
                bl = CsmStatementResolver.findInner((CsmSwitchStatement)csmStatement, n, csmContext);
                break;
            }
            case BREAK: 
            case CASE: 
            case CONTINUE: 
            case DEFAULT: 
            case EXPRESSION: 
            case GOTO: 
            case LABEL: 
            case RETURN: {
                break;
            }
            default: {
                CsmStatementResolver.print("unexpected statement kind");
            }
        }
        return bl;
    }

    private static boolean findInner(CsmCompoundStatement csmCompoundStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmCompoundStatement, n)) : "we must be in statement when called";
        if (csmCompoundStatement != null) {
            for (CsmStatement csmStatement : csmCompoundStatement.getStatements()) {
                if (CsmOffsetUtilities.sameOffsets((CsmObject)csmCompoundStatement, (CsmObject)csmStatement) && (!CsmKindUtilities.isCompoundStatement((CsmObject)csmCompoundStatement) || !CsmKindUtilities.isTryCatchStatement((CsmObject)csmStatement)) || !CsmStatementResolver.findInnerObject(csmStatement, n, csmContext)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean findInner(CsmTryCatchStatement csmTryCatchStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmTryCatchStatement, n)) : "we must be in statement when called";
        if (CsmStatementResolver.findInnerObject(csmTryCatchStatement.getTryStatement(), n, csmContext)) {
            return true;
        }
        for (CsmExceptionHandler csmExceptionHandler : csmTryCatchStatement.getHandlers()) {
            if (!CsmStatementResolver.findInnerObject((CsmStatement)csmExceptionHandler, n, csmContext)) continue;
            return true;
        }
        return false;
    }

    private static boolean findInner(CsmExceptionHandler csmExceptionHandler, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmExceptionHandler, n)) : "we must be in statement when called";
        return CsmStatementResolver.findInner((CsmCompoundStatement)csmExceptionHandler, n, csmContext);
    }

    private static boolean findInner(CsmIfStatement csmIfStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmIfStatement, n)) : "we must be in statement when called";
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)csmIfStatement, (CsmObject)csmIfStatement.getCondition()) && CsmOffsetUtilities.isInObject((CsmObject)csmIfStatement.getCondition(), n)) {
            CsmStatementResolver.print("in CONDITION of if statement ");
            CsmContextUtilities.updateContextObject((CsmObject)csmIfStatement.getCondition(), n, csmContext);
            return true;
        }
        if (CsmStatementResolver.findInnerObject(csmIfStatement.getThen(), n, csmContext)) {
            CsmStatementResolver.print("in THEN: ");
            return true;
        }
        if (CsmStatementResolver.findInnerObject(csmIfStatement.getElse(), n, csmContext)) {
            CsmStatementResolver.print("in ELSE: ");
            return true;
        }
        return false;
    }

    private static boolean findInner(CsmDeclarationStatement csmDeclarationStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmDeclarationStatement, n)) : "we must be in declaration statement when called";
        List list = csmDeclarationStatement.getDeclarators();
        CsmDeclaration csmDeclaration = (CsmDeclaration)CsmOffsetUtilities.findObject(list, csmContext, n);
        if (!(csmDeclaration == null || list.size() != 1 && CsmOffsetUtilities.sameOffsets((CsmObject)csmDeclarationStatement, (CsmObject)csmDeclaration))) {
            CsmClassifier csmClassifier;
            CsmStatementResolver.print("we have declarator " + csmDeclaration);
            if (CsmKindUtilities.isTypedef((CsmObject)csmDeclaration) && CsmOffsetUtilities.isInObject((CsmObject)csmDeclaration, (CsmObject)(csmClassifier = ((CsmTypedef)csmDeclaration).getType().getClassifier())) && !CsmOffsetUtilities.sameOffsets((CsmObject)csmDeclaration, (CsmObject)csmClassifier)) {
                csmDeclaration = csmClassifier;
            }
            if (CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) {
                CsmStatementResolver.findInner((CsmEnum)csmDeclaration, n, csmContext);
            } else if (CsmKindUtilities.isClass((CsmObject)csmDeclaration)) {
                CsmStatementResolver.findInner((CsmClass)csmDeclaration, n, csmContext);
            } else if (CsmKindUtilities.isFunction((CsmObject)csmDeclaration)) {
                csmClassifier = (CsmFunction)csmDeclaration;
                CsmFunctionParameterList csmFunctionParameterList = csmClassifier.getParameterList();
                CsmParameter csmParameter = (CsmParameter)CsmOffsetUtilities.findObject(csmFunctionParameterList.getParameters(), csmContext, n);
                if (CsmOffsetUtilities.isInObject((CsmObject)csmFunctionParameterList, n) || csmParameter != null && !CsmOffsetUtilities.sameOffsets((CsmObject)csmClassifier, (CsmObject)csmParameter)) {
                    csmContext.add((CsmScope)csmClassifier);
                    if (csmParameter != null) {
                        CsmType csmType = csmParameter.getType();
                        if (!CsmOffsetUtilities.sameOffsets((CsmObject)csmParameter, (CsmObject)csmType) && CsmOffsetUtilities.isInObject((CsmObject)csmType, n)) {
                            csmContext.setLastObject((CsmObject)csmType);
                        } else {
                            csmContext.setLastObject((CsmObject)csmParameter);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean findInner(CsmEnum csmEnum, int n, CsmContext csmContext) {
        CsmContextUtilities.updateContext((CsmObject)csmEnum, n, csmContext);
        CsmEnumerator csmEnumerator = (CsmEnumerator)CsmOffsetUtilities.findObject(csmEnum.getEnumerators(), csmContext, n);
        if (csmEnumerator != null && !CsmOffsetUtilities.sameOffsets((CsmObject)csmEnum, (CsmObject)csmEnumerator)) {
            CsmContextUtilities.updateContext((CsmObject)csmEnumerator, n, csmContext);
        }
        return true;
    }

    private static boolean findInner(CsmClass csmClass, int n, CsmContext csmContext) {
        CsmContextUtilities.updateContext((CsmObject)csmClass, n, csmContext);
        CsmMember csmMember = (CsmMember)CsmOffsetUtilities.findObject(csmClass.getMembers(), csmContext, n);
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)csmClass, (CsmObject)csmMember)) {
            if (CsmKindUtilities.isClass((CsmObject)csmMember)) {
                CsmStatementResolver.findInner((CsmClass)csmMember, n, csmContext);
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmMember)) {
                CsmContextUtilities.updateContext((CsmObject)csmMember, n, csmContext);
                CsmCompoundStatement csmCompoundStatement = ((CsmFunctionDefinition)csmMember).getBody();
                if (!CsmOffsetUtilities.sameOffsets((CsmObject)csmMember, (CsmObject)csmCompoundStatement)) {
                    CsmStatementResolver.findInnerObject((CsmStatement)csmCompoundStatement, n, csmContext);
                }
            }
        }
        return true;
    }

    private static boolean findInner(CsmLoopStatement csmLoopStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmLoopStatement, n)) : "we must be in statement when called";
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)csmLoopStatement, (CsmObject)csmLoopStatement.getCondition()) && CsmOffsetUtilities.isInObject((CsmObject)csmLoopStatement.getCondition(), n)) {
            CsmStatementResolver.print("in condition of loop statement isPostCheck()=" + csmLoopStatement.isPostCheck());
            CsmContextUtilities.updateContextObject((CsmObject)csmLoopStatement.getCondition(), n, csmContext);
            return true;
        }
        return CsmStatementResolver.findInnerObject(csmLoopStatement.getBody(), n, csmContext);
    }

    private static boolean findInner(CsmForStatement csmForStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmForStatement, n)) : "we must be in statement when called";
        if (CsmStatementResolver.findInnerObject(csmForStatement.getInitStatement(), n, csmContext)) {
            CsmStatementResolver.print("in INIT of for statement");
            return true;
        }
        if (CsmOffsetUtilities.isInObject((CsmObject)csmForStatement.getIterationExpression(), n)) {
            CsmStatementResolver.print("in ITERATION  of for statement");
            CsmContextUtilities.updateContextObject((CsmObject)csmForStatement.getIterationExpression(), n, csmContext);
            return true;
        }
        if (CsmOffsetUtilities.isInObject((CsmObject)csmForStatement.getCondition(), n)) {
            CsmStatementResolver.print("in CONDITION of for statement ");
            CsmContextUtilities.updateContextObject((CsmObject)csmForStatement.getCondition(), n, csmContext);
            return true;
        }
        return CsmStatementResolver.findInnerObject(csmForStatement.getBody(), n, csmContext);
    }

    private static boolean findInner(CsmSwitchStatement csmSwitchStatement, int n, CsmContext csmContext) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)csmSwitchStatement, n)) : "we must be in statement when called";
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)csmSwitchStatement, (CsmObject)csmSwitchStatement.getCondition()) && CsmOffsetUtilities.isInObject((CsmObject)csmSwitchStatement.getCondition(), n)) {
            CsmContextUtilities.updateContextObject((CsmObject)csmSwitchStatement.getCondition(), n, csmContext);
            return true;
        }
        return CsmStatementResolver.findInnerObject(csmSwitchStatement.getBody(), n, csmContext);
    }

    private static void print(String string) {
        if (CsmUtilities.DEBUG) {
            System.out.println(string);
        }
    }
}

