/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.EmptyTestCaseWizardIterator;
import org.netbeans.modules.junit.wizards.SimpleTestStepLocation;
import org.netbeans.modules.junit.wizards.StepProblemMessage;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTestCaseWizardIterator
implements TemplateWizard.Iterator {
    private static SimpleTestCaseWizardIterator instance;
    private TemplateWizard wizard;
    private static final int INDEX_CHOOSE_CLASS = 2;
    private final String nameChooseClass = NbBundle.getMessage(SimpleTestCaseWizardIterator.class, (String)"LBL_panel_ChooseClass");
    private int current;
    private List<ChangeListener> changeListeners;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel<WizardDescriptor> classChooserPanel;

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(2);
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator<ChangeListener> iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().stateChanged(changeEvent);
            }
        }
    }

    public boolean hasPrevious() {
        return this.current > 2;
    }

    public boolean hasNext() {
        return this.current < 2;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.current;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        switch (this.current) {
            case 2: {
                return this.getClassChooserPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel<WizardDescriptor> getClassChooserPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (this.classChooserPanel == null || project != this.lastSelectedProject) {
            SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test");
            Utils utils = new Utils(project);
            if (utils.getSourcesToTestsMap(true).isEmpty()) {
                this.classChooserPanel = new StepProblemMessage(project, NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
            } else {
                if (this.classChooserPanel == null) {
                    this.classChooserPanel = new SimpleTestStepLocation();
                }
                ((SimpleTestStepLocation)this.classChooserPanel).setUp(utils);
            }
        }
        this.lastSelectedProject = project;
        return this.classChooserPanel;
    }

    public String name() {
        switch (this.current) {
            case 2: {
                return this.nameChooseClass;
            }
        }
        throw new AssertionError(this.current);
    }

    private void loadSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        templateWizard.putProperty("Public", (Object)jUnitSettings.isMembersPublic());
        templateWizard.putProperty("Protected", (Object)jUnitSettings.isMembersProtected());
        templateWizard.putProperty("Package", (Object)jUnitSettings.isMembersPackage());
        templateWizard.putProperty("SetUp", (Object)jUnitSettings.isGenerateSetUp());
        templateWizard.putProperty("TearDown", (Object)jUnitSettings.isGenerateTearDown());
        templateWizard.putProperty("Content", (Object)jUnitSettings.isBodyContent());
        templateWizard.putProperty("JavaDoc", (Object)jUnitSettings.isJavaDoc());
        templateWizard.putProperty("Comments", (Object)jUnitSettings.isBodyComments());
        templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(SimpleTestStepLocation.class, (String)"LBL_simpleTestWizard_stepName"));
    }

    private void saveSettings(TemplateWizard templateWizard) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        jUnitSettings.setMembersPublic(Boolean.TRUE.equals(templateWizard.getProperty("Public")));
        jUnitSettings.setMembersProtected(Boolean.TRUE.equals(templateWizard.getProperty("Protected")));
        jUnitSettings.setMembersPackage(Boolean.TRUE.equals(templateWizard.getProperty("Package")));
        jUnitSettings.setGenerateSetUp(Boolean.TRUE.equals(templateWizard.getProperty("SetUp")));
        jUnitSettings.setGenerateTearDown(Boolean.TRUE.equals(templateWizard.getProperty("TearDown")));
        jUnitSettings.setBodyContent(Boolean.TRUE.equals(templateWizard.getProperty("Content")));
        jUnitSettings.setJavaDoc(Boolean.TRUE.equals(templateWizard.getProperty("JavaDoc")));
        jUnitSettings.setBodyComments(Boolean.TRUE.equals(templateWizard.getProperty("Comments")));
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wizard = templateWizard;
        this.current = 2;
        this.loadSettings(templateWizard);
        String[] stringArray = new String[]{NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_chooseFileType"), NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_ChooseClass")};
        ((JComponent)this.getClassChooserPanel().getComponent()).putClientProperty("WizardPanel_contentData", stringArray);
        ((JComponent)this.getClassChooserPanel().getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (this.classChooserPanel != null && !(this.classChooserPanel instanceof StepProblemMessage)) {
            assert (this.classChooserPanel instanceof SimpleTestStepLocation);
            ((SimpleTestStepLocation)this.classChooserPanel).cleanUp();
        }
        this.classChooserPanel = null;
        this.changeListeners = null;
        this.wizard = null;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        this.saveSettings(templateWizard);
        FileObject fileObject = (FileObject)this.wizard.getProperty("classToTest");
        FileObject fileObject2 = (FileObject)this.wizard.getProperty("testRootFolder");
        Map<JUnitPlugin.CreateTestParam, Object> map = TestUtil.getSettingsMap(false);
        JUnitPlugin jUnitPlugin = TestUtil.getPluginForProject(Templates.getProject((WizardDescriptor)this.wizard));
        if (!JUnitPluginTrampoline.DEFAULT.createTestActionCalled(jUnitPlugin, new FileObject[]{fileObject})) {
            return null;
        }
        FileObject[] fileObjectArray = JUnitPluginTrampoline.DEFAULT.createTests(jUnitPlugin, new FileObject[]{fileObject}, fileObject2, map);
        if (fileObjectArray == null) {
            throw new IOException();
        }
        HashSet<DataObject> hashSet = new HashSet<DataObject>((int)((float)fileObjectArray.length * 1.5f));
        for (FileObject fileObject3 : fileObjectArray) {
            try {
                hashSet.add(DataObject.find((FileObject)fileObject3));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        if (hashSet.isEmpty()) {
            throw new IOException();
        }
        return hashSet;
    }

    public static SimpleTestCaseWizardIterator singleton() {
        if (instance == null) {
            instance = new SimpleTestCaseWizardIterator();
        }
        return instance;
    }
}

